/****************************************************************************/
/* GE18 ( 位置情報管理ﾃｰﾌﾞﾙ )                                               */
/*                                                                          */
/* Created : 2021/06/29 13:32:29                                            */
/****************************************************************************/

CREATE TABLE GE18 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  1 ｼｽﾃﾑID        */
 , LOC_GRP      VARCHAR2 (   30 )                   NOT NULL            /*  2 位置ｸﾞﾙｰﾌﾟ    */
 , LOC_KEY      VARCHAR2 (   30 )                   NOT NULL            /*  3 固有ID        */
 , LOC_COL      NUMBER   (   22 )       DEFAULT 0   NOT NULL            /*  4 列位置        */
 , LOC_ROW      NUMBER   (   22 )       DEFAULT 0   NOT NULL            /*  5 行位置        */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  6 名称          */
 , LABEL_NAME   VARCHAR2 (   60 )                                       /*  7 表示名称      */
 , BIKO         VARCHAR2 ( 2000 )                                       /*  8 備考          */
 , ICON         VARCHAR2 (  200 )                                       /*  9 ｱｲｺﾝ          */
 , R_KEY1       VARCHAR2 (   30 )                                       /* 10 連結ｷｰ1       */
 , R_KEY2       VARCHAR2 (   30 )                                       /* 11 連結ｷｰ2       */
 , R_KEY3       VARCHAR2 (   30 )                                       /* 12 連結ｷｰ3       */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 13 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 14 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                       /* 15 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                       /* 16 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                       /* 17 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                       /* 18 作成者        */
 , DYUPD        VARCHAR2 (   14 )                                       /* 19 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                       /* 20 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 21 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                       /* 22 更新者        */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GE18S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE18T00 
  BEFORE INSERT ON GE18
  FOR EACH ROW 
  BEGIN 
    SELECT GE18S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
