/****************************************************************************/
/* GEA11 ( 画面定義 )                                                       */
/*                                                                          */
/* Created : 2021/06/29 13:32:29                                            */
/****************************************************************************/

CREATE TABLE GEA11 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  1 ｼｽﾃﾑID    */
 , SEQNO            NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  2 表示順    */
 , GUIKEY           VARCHAR2 (   30 )                   NOT NULL            /*  3 画面ID    */
 , NAME_JA          VARCHAR2 (  200 )                                       /*  4 名称      */
 , GUILVL           VARCHAR2 (    1 )       DEFAULT '3' NOT NULL            /*  5 画面Lv    */
 , ADDRESS          VARCHAR2 (  256 )                                       /*  6 ｱﾄﾞﾚｽ     */
 , ROLES            VARCHAR2 ( 2000 )                                       /*  7 ﾛｰﾙｽﾞ     */
 , RWMODE           VARCHAR2 (    3 )                                       /*  8 ﾓｰﾄﾞ      */
 , TARGET           VARCHAR2 (   10 )                                       /*  9 ﾀｰｹﾞｯﾄ    */
 , PARAM            VARCHAR2 (  500 )                                       /* 10 設定値    */
 , CDKH             VARCHAR2 (    1 )                                       /* 11 改廃ｺｰﾄﾞ  */
 , KBSAKU           VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 12 作成区分  */
 , RELEASE_NOTES    VARCHAR2 (  120 )                                       /* 13 ﾘﾘｰｽﾉｰﾄ   */
 , RDC_CODE         VARCHAR2 (   20 )                                       /* 14 設変番号  */
 , GROUPS           VARCHAR2 (  500 )                                       /* 15 ｸﾞﾙｰﾌﾟｽ   */
 , LABEL_CLM        VARCHAR2 (   50 )                                       /* 16 ﾗﾍﾞﾙｶﾗﾑ   */
 , COMMENTS         VARCHAR2 (  500 )                                       /* 17 ｺﾒﾝﾄ      */
 , KBLINK           VARCHAR2 (   10 )                                       /* 18 ﾘﾝｸ区分   */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 19 ﾕﾆｰｸｷｰ    */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 20 状態ﾌﾗｸﾞ  */
 , DYSET            VARCHAR2 (   14 )                                       /* 21 登録日時  */
 , PGSET            VARCHAR2 (   10 )                                       /* 22 作成PG    */
 , PGPSET           VARCHAR2 (   10 )                                       /* 23 作成親PG  */
 , USRSET           VARCHAR2 (   10 )                                       /* 24 作成社員  */
 , DYUPD            VARCHAR2 (   14 )                                       /* 25 更新日時  */
 , PGUPD            VARCHAR2 (   10 )                                       /* 26 更新PG    */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 27 更新親PG  */
 , USRUPD           VARCHAR2 (   10 )                                       /* 28 更新者    */
 , SUBSYS           VARCHAR2 (  200 )                                       /* 29 ｻﾌﾞｼｽﾃﾑ   */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 192K );


CREATE SEQUENCE GEA11S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA11T00 
  BEFORE INSERT ON GEA11
  FOR EACH ROW 
  BEGIN 
    SELECT GEA11S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
