/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* HTTP_REQ ( PROCEDURE )                                                   */
/* Created : 2021/06/29 14:03:46                                            */
/****************************************************************************/

CREATE 
PROCEDURE HTTP_REQ (
	 XURL		IN	VARCHAR2
	,XBASE		IN	VARCHAR2 := 'http://localhost:8823/gf/jsp/TYPEB1/'
	,XUSER		IN	VARCHAR2 := 'C00000'
	,XPASSWD	IN	VARCHAR2 := 'C00000'
)
/**********************************************************************/
/* HTTPリクエストをCALLします。                                       */
/*  HTTP_REQ( url,user,passwd )                                       */
/*                                                                    */
/*   url       in varchar2   CALLするHTTPアドレスの個別PG             */
/*   base      in varchar2   CALLするHTTPアドレスのベース             */
/*   user      in varchar2   ログインユーザー                         */
/*   passwd    in varchar2   ログインパスワード                       */
/*                                                                    */
/*  指定されたURLに対して、リクエストをCALLします。ここでは、値の取得 */
/*  ではなく、指定のアドレスにコマンドを届ける(CALLする)事が目的です。*/
/*                                                                    */
/*  呼び出されたリクエストが正常に処理されたかどうかは、判定しません。*/
/*  それは、呼び出された側の実行ログにて、判断してください。          */
/*                                                                    */
/**********************************************************************/
IS
	-- XURL  := 'AndonTP316.jsp';
--	XBASE	VARCHAR2(1024) := 'http://localhost:8823/gf/jsp/TYPEB1/';

	REQ		UTL_HTTP.REQ;
	RESP	UTL_HTTP.RESP;
--	VAL		VARCHAR2(1024);
BEGIN
--	P_KEKKA := 2;
	IF SUBSTR(XURL,1,7) = 'http://' THEN
		REQ := UTL_HTTP.BEGIN_REQUEST( UTL_URL.ESCAPE( XURL ) );
	ELSE
		REQ := UTL_HTTP.BEGIN_REQUEST( UTL_URL.ESCAPE( XBASE || XURL ) );
	END IF;

	UTL_HTTP.SET_AUTHENTICATION( REQ, XUSER, XPASSWD );
	UTL_HTTP.SET_HEADER( REQ, 'USER-AGENT', 'MOZILLA/4.0' );
	RESP := UTL_HTTP.GET_RESPONSE( REQ );
--	LOOP
--		UTL_HTTP.READ_LINE( RESP, VAL, TRUE );
--		DBMS_OUTPUT.PUT_LINE( SUBSTR(VAL,1,255) );
--	END LOOP;

--	IF RESP.STATUS_CODE = UTL_HTTP.HTTP_OK THEN
--		P_KEKKA := 0;
--	ELSE
--		P_ERRMSGS := RESP.REASON_PHRASE ;
--	END IF;

	UTL_HTTP.END_RESPONSE( RESP );
--	UTL_HTTP.END_REQUEST( REQ );

EXCEPTION
	WHEN UTL_HTTP.END_OF_BODY THEN
		UTL_HTTP.END_RESPONSE( RESP );
END HTTP_REQ;
;
