<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA08"
	title	= "統計情報収集"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@TABLE_NAME}" val2="{@TABLE_NAME}" >
  <og:query
	notfoundMsg = ""
	command    = "{@command}"
	names      = "TABLE_OWNER,TABLE_NAME"
	queryType  = "JDBCUpdate" >
		{ call DBMS_STATS.GATHER_TABLE_STATS( ?,? ) }
  </og:query>
  <og:text>DBMS_STATS.GATHER_TABLE_STATS ( TABLE={@TABLE_NAME} ) </og:text>
  <og:message lbl="MSG0062" comment="実行しました。" /><br />
</og:equals>

<og:equals val1="{@INDEX_NAME}" val2="{@INDEX_NAME}" >
  <og:query
	notfoundMsg = ""
	command    = "{@command}"
	names      = "TABLE_OWNER,INDEX_NAME"
	queryType  = "JDBCUpdate" >
		{ call DBMS_STATS.GATHER_INDEX_STATS( ?,? ) }
  </og:query>
  <og:text>DBMS_STATS.GATHER_INDEX_STATS ( INDEX={@INDEX_NAME} ) </og:text>
  <og:message lbl="MSG0062" comment="実行しました。" /><br />
</og:equals>

<og:equals val1="{@TABLE_NAME}{@INDEX_NAME}" nullCheck="true" >
  <og:query
	notfoundMsg = ""
	command    = "{@command}"
	names      = "TABLE_OWNER"
	queryType  = "JDBCUpdate" >
		{ call DBMS_STATS.GATHER_SCHEMA_STATS( ?,DBMS_STATS.AUTO_SAMPLE_SIZE ) }
  </og:query>
  <og:text>DBMS_STATS.GATHER_SCHEMA_STATS ( OWNER={@TABLE_OWNER} ) </og:text>
  <og:message lbl="MSG0062" comment="実行しました。" /><br />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
	<jsp:directive.include file="/jsp/ORA03/check_analyze_obj.sql" />
</og:query>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
