/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.manila.BackendStoragePool;
import org.openstack4j.openstack.common.ListResult;

public class ManilaBackendStoragePool
implements BackendStoragePool {
    private String backend;
    private String host;
    private String pool;
    private String name;
    private ManilaCapabilities capabilities;

    @Override
    public String getBackend() {
        return this.backend;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BackendStoragePool.Capabilities getCapabilities() {
        return this.capabilities;
    }

    public static class BackendStoragePools
    extends ListResult<ManilaBackendStoragePool> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="pools")
        private List<ManilaBackendStoragePool> pools;

        @Override
        protected List<ManilaBackendStoragePool> value() {
            return this.pools;
        }
    }

    public static class ManilaCapabilities
    implements BackendStoragePool.Capabilities {
        @JsonProperty(value="QoS_support")
        private Boolean qosSupport;
        @JsonProperty(value="consistency_group_support")
        private BackendStoragePool.ConsistencyGroupSupport consistencyGroupSupport;
        private String timestamp;
        @JsonProperty(value="share_backend_name")
        private String shareBackendName;
        @JsonProperty(value="server_pools_mapping")
        private Map<String, List<String>> serverPoolsMapping;
        @JsonProperty(value="driver_handles_share_servers")
        private Boolean driverHandlesShareServers;
        @JsonProperty(value="driver_version")
        private String driverVersion;
        @JsonProperty(value="total_capacity_gb")
        private String totalCapacityGb;
        @JsonProperty(value="free_capacity_gb")
        private String freeCapacityGb;
        @JsonProperty(value="reserved_percentage")
        private Integer reservedPercentage;
        private String pools;
        @JsonProperty(value="vendor_name")
        private String vendorName;
        @JsonProperty(value="snapshot_support")
        private Boolean snapshotSupport;
        @JsonProperty(value="storage_protocol")
        private String storageProtocol;

        @Override
        public Boolean getQosSupport() {
            return this.qosSupport;
        }

        @Override
        public BackendStoragePool.ConsistencyGroupSupport getConsistencyGroupSupport() {
            return this.consistencyGroupSupport;
        }

        @Override
        public String getTimestamp() {
            return this.timestamp;
        }

        @Override
        public String getShareBackendName() {
            return this.shareBackendName;
        }

        @Override
        public Map<String, List<String>> getServerPoolsMapping() {
            return this.serverPoolsMapping;
        }

        @Override
        public Boolean getDriverHandlesShareServers() {
            return this.driverHandlesShareServers;
        }

        @Override
        public String getDriverVersion() {
            return this.driverVersion;
        }

        @Override
        public String getTotalCapacityGb() {
            return this.totalCapacityGb;
        }

        @Override
        public String getFreeCapacityGb() {
            return this.freeCapacityGb;
        }

        @Override
        public Integer getReservedPercentage() {
            return this.reservedPercentage;
        }

        @Override
        public String getPools() {
            return this.pools;
        }

        @Override
        public String getVendorName() {
            return this.vendorName;
        }

        @Override
        public Boolean getSnapshotSupport() {
            return this.snapshotSupport;
        }

        @Override
        public String getStorageProtocol() {
            return this.storageProtocol;
        }
    }
}

