/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractDBType;

/**
 * パスワード情報など、重要な情報のハッシュコード(SHA-512)を扱う為の、カラム属性を定義します。
 *
 * パスワード情報など、重要な情報のハッシュコードに、SHA-512 があります。このクラスは、
 * MessageDigestにより、SHA-512 でハッシュした文字を作成します。
 * 
 * MD5やSHA-1は脆弱性が報告されているため、可能であればSHA-512の利用が推奨されます。
 * 
 * 値としては、標準の X と同じ半角文字列「 c &lt; 0x20 || c &gt; 0x7e 以外」でのみ
 * 処理することが出来ます。
 *
 * タイプチェックとして、以下の条件を判定します。
 * ・文字列長は、Byte換算での文字数との比較
 * ・半角文字列チェック「 c &lt; 0x20 || c &gt; 0x7e 以外」エラー
 * ・文字パラメータの 正規表現チェック
 * ・クロスサイトスクリプティングチェック
 *
 * @og.group データ属性
 *
 * @version  4.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class DBType_SHA512 extends AbstractDBType {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.10.10.2 (2019/04/12)" ;

	/**
	 * String引数の文字列を＋１した文字列を返します。
	 * ※ このクラスでは実装されていません。
	 *
	 * @param	value	String引数の文字列
	 * @throws UnsupportedOperationException このクラスを実行すると、必ず発生します。
	 *
	 * @return  String引数の文字列を＋１した文字列
	 */
	@Override
	public String valueAdd( final String value ) {
		String errMsg = "このメソッドは、このクラスからは使用できません。";
		throw new UnsupportedOperationException( errMsg );
	}

	/**
	 * MessageDigestにより、SHA-512 でハッシュした文字を返します。
	 *
	 * マイナス時には符号を反転させて、１６進数で文字列に変換しています。
	 * よって、このメソッドで変換した文字でのみ突き合わせて正しいかどうかを
	 * 判断してください。
	 *
	 *
	 * @param	value	(一般に編集データとして登録されたデータ)
	 *
	 * @return  修正後の文字列(一般にデータベースに登録するデータ)
	 */
	@Override
	public String valueSet( final String value ) {
		return HybsCryptography.getSHA512( StringUtil.rTrim( value ) );
	}
}
