/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.json.internal;

import com.ibm.cloud.objectstorage.annotation.Immutable;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.AWSStaticCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.JsonCredentials;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.TokenManager;

@SdkInternalApi
@Immutable
public class JsonStaticCredentialsProvider
implements AWSCredentialsProvider {
    private final AWSCredentialsProvider credentialsProvider;
    private TokenManager tokenManager = null;

    public JsonStaticCredentialsProvider(JsonCredentials credentials) {
        if ((credentials.getAWSAccessKeyId() == null || credentials.getAWSSecretKey() == null) && credentials.getApiKey() != null && this.tokenManager == null) {
            this.tokenManager = new DefaultTokenManager(credentials.getApiKey());
        }
        credentials.setTokenManager(this.tokenManager);
        this.credentialsProvider = new AWSStaticCredentialsProvider(credentials);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }
}

