/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.partitions;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.partitions.PartitionRegionImpl;
import com.ibm.cloud.objectstorage.partitions.model.Partition;
import com.ibm.cloud.objectstorage.partitions.model.Region;
import com.ibm.cloud.objectstorage.regions.AbstractRegionMetadataProvider;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.ibm.cloud.objectstorage.regions.Region> regionCache = new ConcurrentHashMap<String, com.ibm.cloud.objectstorage.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<com.ibm.cloud.objectstorage.regions.Region> getRegions() {
        ArrayList<com.ibm.cloud.objectstorage.regions.Region> regions = new ArrayList<com.ibm.cloud.objectstorage.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.ibm.cloud.objectstorage.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.ibm.cloud.objectstorage.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.ibm.cloud.objectstorage.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.ibm.cloud.objectstorage.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        return null;
    }

    private com.ibm.cloud.objectstorage.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.ibm.cloud.objectstorage.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.ibm.cloud.objectstorage.regions.Region region = new com.ibm.cloud.objectstorage.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.ibm.cloud.objectstorage.regions.Region> getRegionsForService(String serviceName) {
        List<com.ibm.cloud.objectstorage.regions.Region> allRegions = this.getRegions();
        ArrayList<com.ibm.cloud.objectstorage.regions.Region> serviceSupportedRegions = new ArrayList<com.ibm.cloud.objectstorage.regions.Region>();
        for (com.ibm.cloud.objectstorage.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

