/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.EncryptedCloudStorage;
import oracle.cloud.storage.exception.AccessDeniedException;
import oracle.cloud.storage.exception.AuthenticationException;
import oracle.cloud.storage.exception.CloudException;
import oracle.cloud.storage.exception.ExceptionUtil;
import oracle.cloud.storage.exception.SystemException;
import oracle.cloud.storage.internal.CloudStorageImpl;
import oracle.cloud.storage.model.Key;
import oracle.cloud.storage.model.StorageInputStream;
import oracle.cloud.storage.nls.ClientMessage;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.ReAuthOnResponseStatus;
import oracle.cloudstorage.api.cipher.CryptoUtils;
import oracle.cloudstorage.api.cipher.ICipher;
import oracle.cloudstorage.api.cipher.RSAEnvelopeCipher;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.HttpProxyConfig;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.retry.DefaultRetry;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.session.SessionBuilder;

public final class EncryptedCloudStorageImpl
extends CloudStorageImpl
implements EncryptedCloudStorage {
    private static final int ENVELOPE_KEY1_UPPER_BOUND = 256;
    private static final int ENVELOPE_KEY2_UPPER_BOUND = 512;
    private static final int LLAPI_RETRY_MAXELAPSED_TIME = 180;
    private static final int LLAPI_RETRY_MAX_RETRY_COUNT = 5;
    private static final String LLAPI_ENVELOPE_KEY1 = "Envelopekey1";
    private ISession llapiSession;
    private final ICipher cipher = new RSAEnvelopeCipher();
    private static String encodedCredentails = null;
    private static String basicAuthHeader = null;

    public EncryptedCloudStorageImpl(CloudStorageConfig config) {
        super(config);
        if (config.getKeyPair() == null) {
            return;
        }
        IAuthReply authReply = null;
        try {
            String proxyHost = null;
            int proxyPort = 0;
            if (config.getHttpProxyUri() != null) {
                URI proxyUri = new URI(config.getHttpProxyUri());
                proxyHost = proxyUri.getHost();
                proxyPort = proxyUri.getPort();
            }
            HttpProxyConfig proxyConfig = new HttpProxyConfig(proxyHost, proxyPort);
            System.out.println("host:" + proxyHost + "port:" + proxyPort);
            this.llapiSession = new SessionBuilder().httpProxyConfig(proxyConfig).connect(config.getConnectTimeout(), TimeUnit.MILLISECONDS).read(config.getReadTimeout(), TimeUnit.MILLISECONDS).cipher(this.cipher).cipherKeys(config.getKeyPair()).session();
            String serviceName = config.getServiceName().substring(0, config.getServiceName().indexOf("-"));
            String domainId = config.getServiceName().substring(config.getServiceName().indexOf("-") + 1);
            encodedCredentails = DatatypeConverter.printBase64Binary((byte[])(config.getUsername() + ":" + new String(config.getPassword())).getBytes("UTF-8"));
            basicAuthHeader = "Basic " + encodedCredentails;
            authReply = this.llapiSession.auth().retry(new DefaultRetryStrategy()).keepAlive(new ReAuthOnResponseStatus(Status.UNAUTHORIZED, new Status[0])).url(config.getServiceUrl().toString()).user(serviceName, domainId, config.getUsername()).password(new String(config.getPassword())).send();
            if (!authReply.isSuccessful()) {
                throw new AuthenticationException(authReply.getMessage());
            }
        }
        catch (Exception e) {
            throw new SystemException("Failed to create a session.", e);
        }
    }

    @Override
    public KeyPair getKeyPair() {
        return this.config.getKeyPair();
    }

    @Override
    public void rotateEncryptionKey(String container, String key, PrivateKey decryptionKey) {
        try {
            KeyPair keyPair = this.config.getKeyPair();
            Key object = this.describeObject(container, key);
            StringBuffer oldKey = new StringBuffer();
            oldKey.append(object.getMetadataValue("EnvelopeKey1"));
            oldKey.append(object.getMetadataValue("EnvelopeKey2"));
            SecretKeySpec aes = new SecretKeySpec(CryptoUtils.decrypt(oldKey.toString(), decryptionKey), "AES");
            String envelopeKey = CryptoUtils.encrypt(aes.getEncoded(), keyPair.getPublic());
            this.updateObjectMetadata(container, key, "EnvelopeKey1", envelopeKey.substring(0, 256));
            this.updateObjectMetadata(container, key, "EnvelopeKey2", envelopeKey.substring(256, 512));
            oldKey = new StringBuffer();
            oldKey.append(object.getMetadataValue("DigestKey1"));
            oldKey.append(object.getMetadataValue("DigestKey2"));
            SecretKeySpec hmac = new SecretKeySpec(CryptoUtils.decrypt(oldKey.toString(), decryptionKey), "HMACSHA256");
            String digestKey = CryptoUtils.encrypt(hmac.getEncoded(), keyPair.getPublic());
            this.updateObjectMetadata(container, key, "DigestKey1", digestKey.substring(0, 256));
            this.updateObjectMetadata(container, key, "DigestKey2", digestKey.substring(256, 512));
        }
        catch (GeneralSecurityException e) {
            throw new SystemException(ClientMessage.systemError(), e);
        }
    }

    @Override
    protected CryptoUtils.DigestInputStream wrapInboundInputStream(InputStream in, Map<String, String> metadata) {
        KeyPair keyPair = this.config.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("No KeyPair found associated with this storage.");
        }
        try {
            SecretKey aes = CryptoUtils.createAESKey();
            String envelopeKey = CryptoUtils.encrypt(aes.getEncoded(), keyPair.getPublic());
            metadata.put("EnvelopeKey1", envelopeKey.substring(0, 256));
            metadata.put("EnvelopeKey2", envelopeKey.substring(256, 512));
            SecretKey hmac = CryptoUtils.createHMACKey();
            String hmacKey = CryptoUtils.encrypt(hmac.getEncoded(), keyPair.getPublic());
            metadata.put("DigestKey1", hmacKey.substring(0, 256));
            metadata.put("DigestKey2", hmacKey.substring(256, 512));
            return CryptoUtils.createEncryptionFilter(in, aes, hmac);
        }
        catch (GeneralSecurityException e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SystemException(ClientMessage.systemError(), e);
        }
    }

    @Override
    protected StorageInputStream wrapOutboundInputStream(StorageInputStream in, String container, String key) {
        KeyPair keyPair = this.config.getKeyPair();
        if (keyPair == null) {
            throw new IllegalStateException("No KeyPair found associated with this storage.");
        }
        try {
            Key object = this.describeObject(container, key);
            StringBuffer envelopeKey = new StringBuffer();
            envelopeKey.append(object.getMetadataValue("EnvelopeKey1"));
            envelopeKey.append(object.getMetadataValue("EnvelopeKey2"));
            SecretKeySpec aes = new SecretKeySpec(CryptoUtils.decrypt(envelopeKey.toString(), keyPair.getPrivate()), "AES");
            StringBuffer digestKey = new StringBuffer();
            digestKey.append(object.getMetadataValue("DigestKey1"));
            digestKey.append(object.getMetadataValue("DigestKey2"));
            SecretKeySpec hmac = new SecretKeySpec(CryptoUtils.decrypt(digestKey.toString(), keyPair.getPrivate()), "HMACSHA256");
            byte[] digest = null;
            if (object.getMetadataValue("Digest") != null) {
                digest = CryptoUtils.hexStringToByteArray(object.getMetadataValue("Digest"));
            }
            InputStream decryptionStream = CryptoUtils.createDecryptionFilter(in, aes, hmac, digest);
            in = new StorageInputStream(decryptionStream, in.getCustomMetadata());
        }
        catch (GeneralSecurityException e) {
            throw new SystemException(ClientMessage.systemError(), e);
        }
        return in;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.config.setKeyPair(keyPair);
    }

    @Override
    public Key storeObject(String container, String key, String contentType, Map<String, String> icustomMetadata, InputStream iin) {
        HashMap<String, String> customMetadata = icustomMetadata != null ? icustomMetadata : new HashMap<String, String>();
        Map<String, String> normCustomMetadata = this.normalizeInputObjectCustomMetadata(customMetadata);
        oracle.cloudstorage.api.header.Map headersMap = new oracle.cloudstorage.api.header.Map((Map<? extends String, ?>)normCustomMetadata);
        if (contentType != null && !contentType.isEmpty()) {
            headersMap.put(Header.provide("Content-Type", contentType));
        }
        headersMap.put(Header.basicAuthHeader.provide(basicAuthHeader));
        IPutObjectReply putObjectReply = null;
        Key k = null;
        try {
            putObjectReply = ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.Header)((IPutRequestBuilder.ConnectTimeout)this.llapiSession.put().retry(new DefaultRetryStrategy())).header(headersMap)).container(container)).object(key)).encrypt().data(iin).send();
            if (putObjectReply.isSuccessful() || putObjectReply.getStatus().equals((Object)Status.ACCEPTED)) {
                Date lastModified = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").parse(putObjectReply.getHeader(Header.lastModified));
                IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.Header)((IHeadRequestBuilder.ConnectTimeout)this.llapiSession.head().retry(new DefaultRetryStrategy())).header(Header.basicAuthHeader.provide(basicAuthHeader))).container(container)).object(key)).send();
                if (headObjectReply.isSuccessful()) {
                    k = Key.create(key, contentType, lastModified, 0L, headObjectReply.getHeader(Header.eTag), this.getMetaDataFromResponse(headObjectReply.getHeaders(), "X-Object-Meta-"));
                    return k;
                }
                if (headObjectReply.getStatus().equals((Object)Status.FORBIDDEN)) {
                    k = Key.create(key, contentType, lastModified, 0L, putObjectReply.getHeader(Header.eTag), this.getMetaDataFromResponse(headersMap, "X-Object-Meta-"));
                    return k;
                }
                throw this.convertLlapiResponseToException(headObjectReply);
            }
            throw this.convertLlapiResponseToException(putObjectReply);
        }
        catch (RetryException re) {
            throw this.convertLlapiRetryExceptionToSystemException(re);
        }
        catch (InterruptedException ie) {
            throw new SystemException(ClientMessage.systemError(), ie);
        }
        catch (ParseException pe) {
            throw new SystemException(ClientMessage.systemError(), pe);
        }
    }

    private Map<String, String> normalizeInputObjectCustomMetadata(Map<String, String> customMetadata) {
        if (customMetadata == null || customMetadata.isEmpty()) {
            return customMetadata;
        }
        HashMap<String, String> normCustomMetadata = new HashMap<String, String>();
        for (Map.Entry<String, String> pairs : customMetadata.entrySet()) {
            String header = pairs.getKey();
            header = header.replaceFirst("X-Object-Meta-", "");
            normCustomMetadata.put("X-Object-Meta-" + header, pairs.getValue());
        }
        return normCustomMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StorageInputStream retrieveObject(String container, String key) {
        StorageInputStream sis = null;
        Closeable getObjectReply = null;
        oracle.cloudstorage.api.header.Map headersMap = new oracle.cloudstorage.api.header.Map();
        if (this.config.isNewestCopyRetrievalEnabled()) {
            headersMap.put(Header.provide("X-Newest", "true"));
        }
        try {
            Map<String, String> normHeaders;
            getObjectReply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)((IGetRequestBuilder.Header)((IGetRequestBuilder.Header)((IGetRequestBuilder.ConnectTimeout)this.llapiSession.get().retry(new DefaultRetryStrategy())).header(headersMap)).header(Header.basicAuthHeader.provide(basicAuthHeader))).container(container)).object(key)).send();
            if (!getObjectReply.isSuccessful()) throw this.convertLlapiResponseToException((IReply)((Object)getObjectReply));
            oracle.cloudstorage.api.header.Map headers = getObjectReply.getHeaders();
            if (headers != null && (normHeaders = this.getMetaDataFromResponse(getObjectReply.getHeaders(), "X-Object-Meta-")).containsKey(LLAPI_ENVELOPE_KEY1)) {
                StorageInputStream storageInputStream = sis = new StorageInputStream(getObjectReply.getData(), normHeaders, getObjectReply);
                return storageInputStream;
            }
            try {
                throw new SystemException(ClientMessage.systemError("", "Object is not encrypted."));
            }
            catch (RetryException re) {
                throw new SystemException(ClientMessage.systemError(), re);
            }
            catch (InterruptedException ie) {
                throw new SystemException(ClientMessage.systemError(), ie);
            }
            catch (Exception e) {
                throw new SystemException(ClientMessage.systemError(), e);
            }
        }
        finally {
            if (sis == null) {
                try {
                    if (getObjectReply != null) {
                        getObjectReply.close();
                    }
                }
                catch (IOException e) {
                    throw new SystemException(ClientMessage.systemError(), e);
                }
            }
        }
    }

    protected Map<String, String> getMetaDataFromResponse(Map<String, String> headers, String metaPrefix) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (headers == null || headers.size() == 0) {
            return m;
        }
        for (Map.Entry<String, String> pairs : headers.entrySet()) {
            String normKey;
            String headerKey = pairs.getKey();
            String val = headers.get(headerKey);
            if (val == null) continue;
            if (headerKey.startsWith(metaPrefix)) {
                normKey = this.normalizeKey(headerKey, metaPrefix);
                m.put(normKey, val);
                continue;
            }
            if (!headerKey.startsWith(metaPrefix.toLowerCase(Locale.ENGLISH))) continue;
            normKey = this.normalizeKey(headerKey, metaPrefix.toLowerCase(Locale.ENGLISH));
            m.put(normKey, val);
        }
        return m;
    }

    protected CloudException convertLlapiResponseToException(IReply response) {
        String message = response.getMessage();
        CloudException e = null;
        e = response.getStatus() == Status.UNAUTHORIZED ? new AuthenticationException(message) : (response.getStatus() == Status.FORBIDDEN ? new AccessDeniedException(message) : new SystemException(ClientMessage.systemError(response.getStatus().toString(), message)));
        ExceptionUtil.trimStackTrace(e, "convertLlapiResponseToException");
        return e;
    }

    protected CloudException convertLlapiRetryExceptionToSystemException(RetryException retryException) {
        SystemException e = null;
        if (retryException.getCause() != null) {
            Throwable cause;
            for (cause = retryException.getCause(); cause != null && cause.getCause() != null; cause = cause.getCause()) {
            }
            if (cause != null && cause instanceof ProtocolException && cause.getMessage() != null && cause.getMessage().toLowerCase(Locale.ENGLISH).startsWith("server rejected operation")) {
                return new AccessDeniedException(cause.getMessage());
            }
        }
        e = new SystemException(ClientMessage.systemError(), retryException);
        ExceptionUtil.trimStackTrace(e, "convertLlapiResponseToException");
        return e;
    }

    private class DefaultRetryStrategy
    extends DefaultRetry {
        public DefaultRetryStrategy() {
            this.retryOn(Status.UNAUTHORIZED, Status.GATEWAY_TIMEOUT, Status.INTERNAL_SERVER_ERROR, Status.REQUEST_TIMEOUT, Status.SERVICE_UNAVAILABLE, Status.TOO_MANY_REQUESTS);
            this.setMaxElapsedTime(180L, TimeUnit.SECONDS);
            this.setMaxAttempts(5);
            this.retryOn(UnknownHostException.class, SocketTimeoutException.class);
        }
    }
}

