/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.head;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.head.IHeadAccountReply;
import oracle.cloudstorage.api.head.IHeadContainerReply;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public class HeadRequestBuilder
extends AbstractRequestBuilder<IHeadRequestBuilder, IHeadRequestProcessor>
implements IHeadRequestBuilder {
    public HeadRequestBuilder(IRequestBuilder that) {
        super(that, Method.head);
    }

    @Override
    public RetryStrategy root(ISession session, IHeadRequestProcessor processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    private class Object
    implements IHeadRequestBuilder.Object {
        private Object() {
        }

        @Override
        public IHeadObjectReply send() throws RetryException {
            IHeadObjectReply reply = ((IHeadRequestProcessor)HeadRequestBuilder.this.getProcessor()).object();
            return reply;
        }
    }

    private class Container
    implements IHeadRequestBuilder.Container {
        private Container() {
        }

        @Override
        public IHeadRequestBuilder.Object object(String objectId) {
            HeadRequestBuilder.this.setObjectId(objectId);
            return new Object();
        }

        @Override
        public IHeadContainerReply send() throws RetryException {
            IHeadContainerReply reply = ((IHeadRequestProcessor)HeadRequestBuilder.this.getProcessor()).container();
            return reply;
        }
    }

    private class Account
    implements IHeadRequestBuilder.Account {
        private Account() {
        }

        @Override
        public IHeadAccountReply send() throws RetryException {
            IHeadAccountReply reply = ((IHeadRequestProcessor)HeadRequestBuilder.this.getProcessor()).account();
            return reply;
        }

        @Override
        public Container container(String containerId) {
            HeadRequestBuilder.this.setContainerId(containerId);
            return new Container();
        }
    }

    private class QueryParam
    extends Account
    implements IHeadRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> paramProvider) {
            HeadRequestBuilder.this.getQueryParams().put(paramProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            HeadRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements IHeadRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            HeadRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class ReadTimeout
    extends Header
    implements IHeadRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IHeadRequestBuilder.Header read(long timeout, TimeUnit units) {
            HeadRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Header();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IHeadRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IHeadRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            HeadRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements IHeadRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            HeadRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

