/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.cipher.CryptoUtils;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.put.ExtractArchiveReply;
import oracle.cloudstorage.api.put.IExtractArchiveReply;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutDataReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.PutContainerReply;
import oracle.cloudstorage.api.put.PutObjectReply;
import oracle.cloudstorage.api.put.PutRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.request.processor.Sendable;
import oracle.cloudstorage.api.request.processor.SimpleXMLResponseParser;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutSendableProcessor
extends PutRequestProcessor {
    private static final int MAX_POST_DIGEST_RETRY_COUNT = 5;
    private static final int POST_DIGEST_RETRY_DELAY_IN_MSECS = 2000;
    private static final Logger logger = LoggerFactory.getLogger(PutSendableProcessor.class);
    private static final String NUMBER_FILES_CREATED = "<number_files_created>";
    private static final String EXTRACT_ARCHIVE_RESPONSE_BODY = "<response_body>";
    private static final String EXTRACT_ARCHIVE_RESPONSE_STATUS = "<response_status>";

    public PutSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    public IPutContainerReply container() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IPutContainerReply> processor = new ScopedRequestProcessor<IRequestBuilder, IPutContainerReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IPutContainerReply buildReply(IResponse response, IReply.Context context) {
                java.util.Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                PutContainerReply reply = new PutContainerReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IPutContainerReply reply = (IPutContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IExtractArchiveReply archive() throws RetryException {
        ((IPutRequestBuilder)this.getBuilder()).getSendable().getHeaders().setHeader(Header.accept.provide("text/xml"));
        BodyProcessor<IExtractArchiveReply> processor = new BodyProcessor<IExtractArchiveReply>((IRequestProcessor)this){

            @Override
            protected IExtractArchiveReply buildReply(IResponse response, IReply.Context context) {
                return PutSendableProcessor.this.buildExtractArchiveReply(response, context);
            }
        };
        IExtractArchiveReply reply = (IExtractArchiveReply)processor.execute(this.getBuilder());
        return reply;
    }

    private IPutObjectReply buildObjectReply(IResponse response, long numberOfBytesRead, final IDeleteObjectReply deleteObjectReply, IReply.Context context, java.util.concurrent.Future<String> futureMd5) {
        java.util.Map<String, List<Object>> headers = response.getHeaders();
        int statusCode = response.getStatus();
        String message = response.getErrorContent();
        PutObjectReply reply = new PutObjectReply(headers, statusCode, message, numberOfBytesRead, futureMd5, context){

            @Override
            public IDeleteObjectReply getDeleteObjectReply() {
                return deleteObjectReply;
            }
        };
        return reply;
    }

    private IExtractArchiveReply buildExtractArchiveReply(IResponse response, IReply.Context context) {
        String containerId;
        String responseStatus;
        java.util.Map<String, List<Object>> headers = response.getHeaders();
        int statusCode = response.getStatus();
        String message = response.getErrorContent();
        String body = response.readContent();
        SimpleXMLResponseParser parser = new SimpleXMLResponseParser(body);
        int created = parser.getInt(NUMBER_FILES_CREATED);
        java.util.concurrent.Future<String> futureMd5 = response.getFutureMd5();
        parser = new SimpleXMLResponseParser(body);
        String responseBody = parser.get(EXTRACT_ARCHIVE_RESPONSE_BODY);
        if (responseBody != null && !responseBody.isEmpty()) {
            message = responseBody;
        }
        if ((responseStatus = (parser = new SimpleXMLResponseParser(body)).get(EXTRACT_ARCHIVE_RESPONSE_STATUS)) != null) {
            statusCode = Integer.parseInt(responseStatus.replaceFirst("\\s+.*", ""));
        }
        ExtractArchiveReply reply = new ExtractArchiveReply(headers, statusCode, message, futureMd5, context, created);
        parser = new SimpleXMLResponseParser(body);
        String string = containerId = context != null ? context.getContainerId() : null;
        if (containerId != null && containerId.indexOf(47) > 0) {
            containerId = containerId.substring(0, containerId.indexOf(47));
        }
        parser.parseErrors(reply, containerId);
        return reply;
    }

    @Override
    protected IPutObjectReply atomicObject(final IContent content, final IDeleteObjectReply deleteObjectReply) throws RetryException {
        BodyProcessor<IPutObjectReply> processor = new BodyProcessor<IPutObjectReply>((IRequestProcessor)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IPutObjectReply buildReply(IResponse response, IReply.Context context) {
                IResponse finalResponse = response;
                long numberOfBytesRead = content == null ? 0L : content.getNumberOfBytesRead();
                Future<String> futureMd5 = content == null ? null : content.getFutureMd5();
                List<Object> responseEtag = response.getHeaders().get(Header.eTag.key);
                String digest = null;
                if ((response.getStatus() == Status.ACCEPTED.getStatusCode() || response.getStatus() == Status.CREATED.getStatusCode()) && content != null && content.getDigestInputStream() != null && (digest = CryptoUtils.byteArrayToHexString(content.getDigestInputStream().getDigest())) != null) {
                    java.util.Map<String, List<Object>> headers = response.getHeaders();
                    ArrayList<String> digestValues = new ArrayList<String>();
                    digestValues.add(digest);
                    headers.put(Header.digest.key, digestValues);
                    String lastModifiedPut = null;
                    List<Object> lastModified = headers.get(Header.xLastModifiedTimestamp.key.toLowerCase());
                    if (lastModified != null) {
                        lastModifiedPut = (String)lastModified.get(0);
                    }
                    IResponse postDigestResponse = null;
                    IResponse deleteResponse = null;
                    try {
                        Map customHeadersMap = this.getSendable().getHeaders();
                        customHeadersMap.put(Header.digest.key, digest);
                        for (int i = 0; i < 5; ++i) {
                            logger.debug(Marker.put.and(Marker.jaxrs), "Set the x-object-meta-digest to {} URL:{} retry#{}", digest, this.getUrl(), i);
                            if (postDigestResponse != null) {
                                postDigestResponse.close();
                            }
                            Sendable sendable = new Sendable((IRequestBuilder)PutSendableProcessor.this.getBuilder(), customHeadersMap, Method.post, Scope.object, this.getSendable().getUrl(), null, -3);
                            postDigestResponse = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
                            if (postDigestResponse.getStatus() != Status.OK.getStatusCode() && postDigestResponse.getStatus() != Status.ACCEPTED.getStatusCode()) {
                                finalResponse = postDigestResponse;
                                if (postDigestResponse.getStatus() == Status.NOT_FOUND.getStatusCode() && i < 4) {
                                    try {
                                        Thread.sleep(2000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        logger.error(Marker.put.and(Marker.jaxrs), "InterruptedException caught while setting the x-object-meta-digest.");
                                    }
                                } else {
                                    logger.error("Failed to set the x-object-meta-digest for " + context.getContainerId() + "/" + context.getObjectId());
                                    sendable = new Sendable((IRequestBuilder)PutSendableProcessor.this.getBuilder(), new Map(), Method.delete, Scope.object, this.getSendable().getUrl(), null, -3);
                                    deleteResponse = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
                                    if (deleteResponse.getStatus() != Status.NO_CONTENT.getStatusCode()) {
                                        logger.error("Failed to delete the object " + context.getContainerId() + "/" + context.getObjectId());
                                    }
                                    finalResponse = postDigestResponse;
                                }
                                break;
                            }
                            if (lastModified == null) {
                                postDigestResponse.close();
                                finalResponse = response;
                                break;
                            }
                            lastModified = postDigestResponse.getHeaders().get(Header.xLastModifiedTimestamp.key.toLowerCase());
                            String lastModifiedPost = (String)lastModified.get(0);
                            if (lastModifiedPost.compareTo(lastModifiedPut) > 0) {
                                postDigestResponse.getHeaders().put(Header.eTag.key, responseEtag);
                                postDigestResponse.close();
                                finalResponse = response;
                                break;
                            }
                            logger.error(" POST last-modified-timestamp is not greater than PUT last-modified-timestamp. POST timestamp:" + lastModifiedPost + ", PUT timestamp:" + lastModifiedPut);
                            logger.error("Retrying POST to set digest again. Retry count " + (i + 1));
                            try {
                                Thread.sleep(2000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                logger.error(Marker.put.and(Marker.jaxrs), "InterruptedException caught while setting the x-object-meta-digest.");
                                break;
                            }
                        }
                    }
                    finally {
                        if (deleteResponse != null) {
                            deleteResponse.close();
                        }
                    }
                }
                return PutSendableProcessor.this.buildObjectReply(finalResponse, numberOfBytesRead, deleteObjectReply, context, futureMd5);
            }
        };
        IPutObjectReply reply = (IPutObjectReply)processor.execute(this.getBuilder());
        return reply;
    }

    abstract class BodyProcessor<P extends IPutDataReply>
    extends ScopedRequestProcessor<IPutRequestBuilder, P> {
        private final IContent content;
        private boolean reset;

        BodyProcessor(IRequestProcessor<?, ?> outer) {
            super(outer);
            this.reset = false;
            this.content = this.getSendable().getContent();
        }

        @Override
        protected boolean canRetry() {
            if (!this.content.hasBeenRead()) {
                return true;
            }
            this.reset = this.content.reset();
            return this.reset;
        }

        @Override
        public void releaseRequest() throws IOException {
            this.content.close();
        }

        @Override
        protected IResponse executeRequest(IPutRequestBuilder request) {
            ISendable sendable = this.getSendable();
            Map headers = sendable.getHeaders();
            String contentType = PutSendableProcessor.this.getContentType("*/*");
            headers.put(Header.contentType.provide(contentType));
            if (request.isExpect100ContinueEnabled()) {
                headers.put(Header.expect.provide());
            }
            IResponse response = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onResponseClosed(IResponse response) {
            if (this.content.hasBeenRead() || this.reset) {
                this.reset = false;
                return;
            }
            IResponse cleanupResponse = null;
            try {
                try {
                    Sendable sendable = new Sendable((IRequestBuilder)PutSendableProcessor.this.getBuilder(), this.getSendable().getHeaders(), Method.head, Scope.account, PutSendableProcessor.this.getAccountUrl(), null, -3);
                    cleanupResponse = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
                    logger.debug(Marker.put.and(Marker.jaxrs), "Server reset by invoking HEAD on {}.", (Object)this.getUrl());
                }
                finally {
                    if (cleanupResponse != null) {
                        cleanupResponse.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error(Marker.put.and(Marker.jaxrs), "Exception thrown resetting server for {} with response {}.", this, response, e);
            }
        }
    }
}

