/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet.multipart;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opengion.fukurou.system.Closer;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.io.StorageAPI;
import org.opengion.hayabusa.io.StorageAPIFactory;
import org.opengion.hayabusa.servlet.multipart.Part;
import org.opengion.hayabusa.servlet.multipart.PartInputStream;

public class FilePart
extends Part {
    private String filename;
    private final String filePath;
    private final String contentType;
    private final PartInputStream partInput;

    FilePart(String string, ServletInputStream servletInputStream, String string2, String string3, String string4, String string5) throws IOException {
        super(string);
        this.filename = string4;
        this.filePath = string5;
        this.contentType = string3;
        this.partInput = new PartInputStream(servletInputStream, string2);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    public void writeToCloud(String string, String string2, HttpSession httpSession) {
        StorageAPI storageAPI = StorageAPIFactory.newStorageAPI(string, HybsSystem.sys("CLOUD_STORAGE_CONTAINER"), httpSession);
        storageAPI.add(this.partInput, string2, this.filename, httpSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File file) throws IOException {
        long l = 0L;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            if (this.filename != null) {
                File file2 = file.isDirectory() ? new File(file, this.filename) : file;
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                l = this.write(bufferedOutputStream);
            }
        }
        finally {
            Closer.ioClose(bufferedOutputStream);
        }
        return l;
    }

    private long write(OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[8192];
        while ((n = this.partInput.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

