/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import jakarta.servlet.jsp.tagext.Tag;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.OptionAncestorIF;

public class FileOptionTag
extends CommonTagSupport {
    private static final String VERSION = "7.2.6.0 (2020/06/30)";
    private static final long serialVersionUID = 726020200630L;
    private String orderBy;
    private boolean nameOnly;
    private boolean groupDir;
    private boolean desc;
    private String from = HybsSystem.sys("FILE_URL");
    private String selValue;
    private transient FileFilter filter;
    private static final Set<String> ORDER_BY_SET = new ArraySet((Object[])new String[]{"NAME", "LASTMODIFIED", "FILE_LENGTH", "LENGTH"});

    @Override
    public int doStartTag() {
        return this.useTag() ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            OptionAncestorIF optionAncestorIF = (OptionAncestorIF)FileOptionTag.findAncestorWithClass((Tag)this, OptionAncestorIF.class);
            if (optionAncestorIF == null) {
                String string = "<b>" + this.getTagName() + "\u30bf\u30b0\u306f\u3001SelectTag \u307e\u305f\u306f\u3001DatalistTag \u306eBODY \u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
                throw new HybsSystemException(string);
            }
            Comparator<File> comparator = this.makeComparator(this.orderBy, this.desc);
            this.makeLabel(new File(this.from), optionAncestorIF, comparator, this.groupDir);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.orderBy = null;
        this.nameOnly = false;
        this.groupDir = false;
        this.desc = false;
        this.from = HybsSystem.sys("FILE_URL");
        this.filter = null;
        this.selValue = null;
    }

    private Comparator<File> makeComparator(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Serializable serializable = null;
        if ("NAME".equalsIgnoreCase(string)) {
            serializable = new NameComparator(bl);
        } else if ("LASTMODIFIED".equalsIgnoreCase(string)) {
            serializable = new ModifiedComparator(bl);
        } else if ("FILE_LENGTH".equalsIgnoreCase(string) || "LENGTH".equalsIgnoreCase(string)) {
            serializable = new LengthComparator(bl);
        }
        return serializable;
    }

    private boolean makeLabel(File file, OptionAncestorIF optionAncestorIF, Comparator<File> comparator, boolean bl) {
        File[] fileArray = file.listFiles(this.filter);
        boolean bl2 = optionAncestorIF.isMultipleAll();
        if (fileArray != null) {
            Arrays.sort(fileArray, comparator);
            boolean bl3 = false;
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                String string = fileArray[i].getName();
                if (bl && fileArray[i].isDirectory()) {
                    optionAncestorIF.addOption("<optgroup label=\"" + string + "\">");
                    if (this.makeLabel(fileArray[i], optionAncestorIF, comparator, false)) {
                        optionAncestorIF.addOption("</optgroup>");
                        bl3 = true;
                        continue;
                    }
                    optionAncestorIF.removeLast();
                    continue;
                }
                if (this.nameOnly && (n = string.lastIndexOf(46)) >= 0) {
                    string = string.substring(0, n);
                }
                String string2 = this.selValue != null && this.selValue.equalsIgnoreCase(string) || bl2 ? "selected" : null;
                optionAncestorIF.addOption(XHTMLTag.option((Attributes)new Attributes().set("value", string).set("selected", string2).set("body", string)));
            }
            return bl3;
        }
        return false;
    }

    public void setValue(String string) {
        this.selValue = StringUtil.nval((String)this.getRequestParameter(string), (String)this.selValue);
    }

    public void setUseDir(String string) {
    }

    public void setNameOnly(String string) {
        this.nameOnly = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.nameOnly);
    }

    public void setGroupDir(String string) {
        this.groupDir = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.groupDir);
    }

    public void setFrom(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        this.from = HybsSystem.url2dir(this.from, string2, ".");
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
        if (this.orderBy != null && !this.check(this.orderBy, ORDER_BY_SET)) {
            String string2 = "orderBy \u5c5e\u6027\u306b\u3001\u4e0b\u8a18\u306e\u5c5e\u6027\u540d\u4ee5\u5916\u306e\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002" + CR + "orderBy=[" + this.orderBy + "] " + CR + "orderBy List=" + String.join((CharSequence)", ", ORDER_BY_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setDesc(String string) {
        this.desc = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.desc);
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("orderBy", (Object)this.orderBy).println("desc", (Object)this.desc).println("from", (Object)this.from).println("selValue", (Object)this.selValue).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    private static final class LengthComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 400020050131L;
        private final boolean desc;

        public LengthComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return (int)(file3.length() - file4.length());
        }
    }

    private static final class ModifiedComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 400020050131L;
        private final boolean desc;

        public ModifiedComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return (int)(file3.lastModified() - file4.lastModified());
        }
    }

    private static final class NameComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 400020050131L;
        private final boolean desc;

        public NameComparator(boolean bl) {
            this.desc = bl;
        }

        @Override
        public int compare(File file, File file2) {
            File file3 = this.desc ? file2 : file;
            File file4 = this.desc ? file : file2;
            return file3.getName().compareTo(file4.getName());
        }
    }
}

