<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0040"
	title	= "履歴ﾃｰﾌﾞﾙ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<og:value command="SET" key="YMDFROM" value='{@NVL.DYFROM "@DATE.YMD M-1"}' />	<!-- １ヶ月前 -->
<og:value command="SET" key="YMDTO"   value='{@NVL.DYTO    @DATE.YMD     }' />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	select	-- case when D.CDJISI='5' then '0' else '1' end as WRITABLE
		--	,D.CDJISI
		 	A.DY_HATU,A.SET_KEY,A.SET_GRP,A.TOKEN
			,COALESCE(C.TKN_NM,B.TKN_NM) AS TKN_NM
			,A.VAL,A.TANI,B.DATA_TYPE
			,A.JUDG,A.RIYU,A.UPCNT,C.TAB_NM
			,C.ROWNO,C.COLNO,C.E_MIN,C.W_MIN,C.W_MAX,C.E_MAX,C.OPT_ATTR
			,A.UNIQ,A.FGJ,A.USRSET,A.DYSET,A.USRUPD,A.DYUPD
	from GG10 A inner join GG01 B
			on A.TOKEN = B.TOKEN
				inner join GG02 C
				on  A.SET_GRP = C.SET_GRP
				and A.TOKEN   = C.TOKEN
		--			left outer join GG11 D
		--			on  A.DY_HATU = D.DY_HATU
		--			and A.SET_KEY = D.SET_KEY
		--			and A.SET_GRP = D.SET_GRP
	<og:where>
		<og:and value = "A.DY_HATU	&gt;= '{@YMDFROM}'"		/>
		<og:and value = "A.DY_HATU	&lt;= '{@YMDTO}'"		/>
		<og:and value = "A.JUDG		=    '{@JUDG}'"			/>
		<og:and value = "A.SET_GRP	=    '{@SET_GRP}'"		/>
		<og:and value = "A.SET_KEY	like '{@SET_KEY}'"		/>
		<og:and value = "A.VAL		like '{@VAL}'"			/>
		<og:and value = "A.TOKEN	like '{@TOKEN}'"		/>
		<og:and value = "C.TKN_NM	like '{@TKN_NM}'"		/>
		<og:and value = "C.TKN_GRP	=    '{@TKN_GRP}'"		/>
		<og:and value = "A.RIYU		like '{@RIYU}'"			/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DY_HATU DESC,A.SET_KEY,A.SET_GRP,C.ROWNO,C.COLNO,A.UPCNT DESC" />
</og:query>

<!-- 同一 TOKEN で、更新ｶｳﾝﾀ(UPCNT) が一番大きいレコードのみ表示します。(order by で先に現れる) -->
<og:tableMerge
	action		= "GROUP"
	masterKeys	= "DY_HATU,SET_KEY,SET_GRP,TOKEN"
	caseKey		= "{@FG_NEW}"
	caseVal		= "1"
/>

<og:columnEditor columns="DY_HATU,TOKEN"	must="true" />
<og:columnEditor column="SET_GRP"			must="true"	/>
<og:columnEditor column="SET_KEY" 			must="true" eventColumn="SET_GRP" />

<og:viewLink command="{@command}">
	<og:link column="DY_HATU" gamenId="GG0100" href="index.jsp" target="CONTENTS"
		keys="command,DY_HATU,SET_KEY,SET_GRP"
		vals="NEW,[DY_HATU],[SET_KEY],[SET_GRP]" />
</og:viewLink>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="JUDG" >
		<div class="judg[!JUDG]">[JUDG]</div>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="COPY"    noWritable="null"		roles="admin" />
		<og:submit  action="MODIFY"  columnWritable="VAL,JUDG,RIYU"  />
		<og:submit  action="DELETE"  columnWritable="null"	roles="admin" />
	</og:writeCheck>

<!-- 判定結果 の凡例と、CSS -->
<pre>　　　　　</pre>
<jsp:directive.include file="/jsp/customGG/colorCSS.jsp" />

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
