<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="query" >
	<!-- link の引数を置換する -->
	<script type="text/javascript" src="{@SYS.JSP}/customGG/linkChange.js?v={@SYS.BUILD_ID}" ><!-- --></script>

	<!-- SET_KEY の datalist は、SET_GRP 変更時にクリアしないと前の値が残るが、
		 画面遷移で引数指定された時も、チェンジイベントが起こりクリアされるので、その時は変更しない -->
	<script type="text/javascript">
		var dummy = <og:text>"{@SET_KEY}"</og:text> ;		// ﾘｸｴｽﾄ引数の初期値を設定

		function setKeyClear() {
			if( dummy ) {					// 何か書かれている場合
				dummy = "";					// 初期化する。(次回以降は、通らない)
			}
			else {							// なにも書かれていない場合
				var key = document.getElementById("SET_KEY");
				key.value="";				// SET_KEYの値をクリアする。
			}
		}
	</script>
</og:head>

<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<!-- <jsp:directive.include file="/jsp/custom/customTAB.jsp" />	-->
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0100"
	title	= "ﾃﾞｰﾀ登録"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<form method="GET" action="forward.jsp" target="RESULT"  onSubmit="timeSet();">
	<!-- 変更はここから -->
	<table summary="layout" >
		<tr>
			<og:column name="DY_HATU"  must="true"	defaultVal="{@DATE.YMD}" />
			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='1' で、SET_GRP をキーに登録している選択肢 -->
			<og:column name="SET_GRP"	must="true"	onChange="setKeyClear()" useLblBody="true">
				<og:link gamenId="GG0030" href="index.jsp" target="CONTENTS" lbl="{@LBL.SET_GRP} (※)"
					keys="SEL_TYPE,SEL_KEY,command" vals="1,SET_GRP,NEW" />
			</og:column>

			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='2' に登録している選択肢 -->
			<og:column name="SET_KEY"	must="true" eventColumn="SET_GRP" useLblBody="true" >
				<!-- SET_GRP.value を選択されている SET_GRP の値を置換する。 -->
				<og:link gamenId="GG0030" href="index.jsp" target="CONTENTS" lbl="{@LBL.SET_KEY} (※)" onClick="linkChange(this);"
					keys="SEL_TYPE,SEL_KEY,command" vals="2,SET_GRP.value,NEW" />
			</og:column>
			<td><span onclick="setKeyClear()" ><og:text>({@LBL.CLEAR})</og:text></span></td>

			<!-- GG02 の ﾀﾌﾞ名称は、group by でまとめる。順番は、一番若い、ROWNO,COLNO順 -->
			<og:column name="TAB_NM"	eventColumn="SET_GRP" editor="DBMENU"
				param="select TAB_NM from GG02 where SET_GRP='{@SET_GRP}' group by TAB_NM order by min(ROWNO),min(COLNO)"
			/>
		</tr>
	</table>

	<og:queryButton />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
