/****************************************************************************/
/* GEA11 ( 画面定義 )                                                       */
/*                                                                          */
/* Created : 2021/07/01 16:05:56                                            */
/****************************************************************************/

CREATE TABLE GEA11 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID   */
 , SEQNO            NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  20 表示順   */
 , GUIKEY           VARCHAR2 (   30 )                   NOT NULL            /*  30 画面ID   */
 , GUILVL           VARCHAR2 (    1 )       DEFAULT '3' NOT NULL            /*  40 画面Lv   */
 , LABEL_CLM        VARCHAR2 (   50 )                                       /*  50 ﾗﾍﾞﾙｶﾗﾑ  */
 , GROUPS           VARCHAR2 (  500 )                                       /*  60 ｸﾞﾙｰﾌﾟｽ  */
 , NAME_JA          VARCHAR2 (  200 )                                       /*  70 名称     */
 , ADDRESS          VARCHAR2 (  256 )                                       /*  80 ｱﾄﾞﾚｽ    */
 , ROLES            VARCHAR2 ( 2000 )                                       /*  90 ﾛｰﾙｽﾞ    */
 , RWMODE           VARCHAR2 (    3 )                                       /* 100 ﾓｰﾄﾞ     */
 , TARGET           VARCHAR2 (   10 )                                       /* 110 ﾀｰｹﾞｯﾄ   */
 , PARAM            VARCHAR2 (  500 )                                       /* 120 設定値   */
 , KBLINK           VARCHAR2 (   10 )                                       /* 130 ﾘﾝｸ区分  */
 , COMMENTS         VARCHAR2 (  500 )                                       /* 140 ｺﾒﾝﾄ     */
 , CDKH             VARCHAR2 (    1 )                                       /* 150 改廃ｺｰﾄﾞ */
 , KBSAKU           VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 160 作成区分 */
 , SUBSYS           VARCHAR2 (  200 )                                       /* 170 ｻﾌﾞｼｽﾃﾑ  */
 , RELEASE_NOTES    VARCHAR2 (  120 )                                       /* 180 ﾘﾘｰｽﾉｰﾄ  */
 , RDC_CODE         VARCHAR2 (   20 )                                       /* 190 設変番号 */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ   */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 作成日時 */
 , PGSET            VARCHAR2 (   10 )                                       /* 830 作成PG   */
 , PGPSET           VARCHAR2 (   10 )                                       /* 840 作成親PG */
 , USRSET           VARCHAR2 (   10 )                                       /* 850 作成者   */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時 */
 , PGUPD            VARCHAR2 (   10 )                                       /* 870 更新PG   */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 880 更新親PG */
 , USRUPD           VARCHAR2 (   10 )                                       /* 890 更新者   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GEA11S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA11T00 
  BEFORE INSERT ON GEA11
  FOR EACH ROW 
  BEGIN 
    SELECT GEA11S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
