/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package gf;

import org.opengion.fukurou.business.BizLogic_TABLE;

/**
 * 一覧登録:標準(Java) (GF9440) の 業務ロジックです。
 *
 * 画面で入力された情報を元にGF41に登録を行います。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 *
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class GF9440A extends BizLogic_TABLE {

	/**
	 * メインカーソルの各行(変更区分の各処理の前)で呼ばれるチェックロジックを定義します。
	 *
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean befchk( final int row ) {
		String cnt = "select count(*) CNT from GF41 where clm=[CLM]";
		sql( cnt );

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるチェックロジックを定義します。
	 *
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean allchk( final int row ) {
		if( vari( "CNT" ) == 0 ) {
			error( NG, "ERR0015", "[CLM]", "{#GF41}" );
		}
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 *
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	protected boolean allrow( final int row ) {
		// 8.0.0.0 (2021/07/31) Avoid unnecessary if..then..else statements when returning booleans
		// パラメーターを与えて、サブルーチンを呼び出します。
		return call( "gf.GF0001", "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU", "[SYSTEM_ID],[LANG],[CLM],[NAME_JA],[LABEL_NAME],[KBSAKU]" );

//		// パラメーターを与えて、サブルーチンを呼び出します。
//		boolean rtn = call( "gf.GF0001", "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU", "[SYSTEM_ID],[LANG],[CLM],[NAME_JA],[LABEL_NAME],[KBSAKU]" );
//		if( !rtn ) { return false; }
//
//		return true;
	}
}
