package gf;

import java.util.ArrayList;
import java.util.List;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.penguin.math.statistics.HybsCorrelation;

/**
 * 指定したDB項目の相関係数ﾋｰﾄﾏｯﾌﾟを出力します。
 * penguinパッケージを利用して、相関係数を計算します。
 *
 * @version 5.0
 * @author T.OTA
 * @author JDK1.7
 *
 */
public class GFX028A extends BizLogic_TABLE {
	String[]		columns;

	List<double[]>	dataList	= new ArrayList<double[]>();

	/**
	 * 初期処理を行います
	 */
	@Override
	protected void init() {
		columns = var( "COLUMN_NAME_LIST" ).split( "," );
	}

	/**
	 * メインカーソルの各行で呼ばれるロジックを定義します
	 *
	 * @pram row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean befall( int row ) {

		double[] lineData = new double[columns.length];
		for( int i = 0; i < columns.length; i++ ) {
			if( isEmpty( line(columns[i]) ) ) {
				lineData[i] = 0;
			}
			else {
				lineData[i] = lined( columns[i] );
			}
		}
		dataList.add( lineData );
		return true;
	}

	/**
	 * 空ﾁｪｯｸ
	 * @param str
	 * @return true:空 false:空でない
	 */
	private boolean isEmpty(String str){
		return "".equals( str ) || str == null ; 	// 8.0.0.0 (2021/07/31) Avoid unnecessary if..then..else statements when returning booleans
//		if("".equals( str ) || str == null){
//			return true;
//		}
//		return false;
	}

	/**
	 * 最後の行の終わりで呼び出し
	 *
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		StringBuilder sb = new StringBuilder();

		String[] labels = var( "COLUMN_LABEL_LIST" ).split( "," );

		// 相関係数を計算
		HybsCorrelation rtn = new HybsCorrelation( columns, (double[][]) dataList.toArray( new double[dataList.size()][columns.length] ) );

		sb.append( "<table border='1'>" );
		// x軸ﾀｲﾄﾙ行出力
		sb.append( "<tr><td></td>" );
		for( int i = 0; i < labels.length; i++ ) {
			sb.append( "<td class='row_h'>" ).append( labels[i] ).append( "</td>" );
		}
		sb.append( "</tr>" );
		for( int i = 0; i < rtn.getCorrMatrix().length; i++ ) {
			double[] rowData = rtn.getCorrMatrix()[i];
			// y軸ﾀｲﾄﾙ列出力
			sb.append( "<tr>" ).append( "<td class='row_h'>" ).append( labels[i] ).append( "</td>" );
			// 相関ﾃﾞｰﾀ出力
			for( int k = 0; k < rowData.length; k++ ) {
				double data = rowData[k];
				// 係数により背景色を設定
				int rgb;
				if(Double.isNaN( data )){
					rgb = 255;
				}else{
					rgb = (int)(255*(1.0-Math.abs(data)));
				}
				if(data >= 0){
					sb.append( "<td id='" + columns[i] + "__" + columns[k]+"' style='background-color:rgb("+rgb+","+rgb+",255);");
					if(data > 0.5){
						sb.append( "color:white;'>" );
					}else{
						sb.append( "'>");
					}
				}else{
					sb.append( "<td id='" + columns[i] + "__" + columns[k]+"' style='background-color:rgb(255,"+rgb+","+rgb+");");
					if(data < -0.5){
						sb.append( "color:white;'>" );
					}else{
						sb.append( "'>");
					}
				}

				sb.append( String.format( "%.4f", data ) ).append( "</td>" );
			}
			sb.append( "</tr>" );
		}

		sb.append( "</tr></table>" );

		rtn( sb.toString() );

		return true;
	}
}
