/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.queue;

/**
 * キュー送信クラス用インタフェース
 * キュー送信クラス実装用のインタフェースです。
 *
 * @og.rev 5.10.14.0 (2019/08/01) 新規作成
 *
 */
public interface QueueSend {
//	/**
//	 * 接続処理
//	 * メッセージキューサーバに接続します。
//	 *
//	 * @param jmsServer jmsServer接続先
//	 */
//	void connect(final String jmsServer);

	/**
	 * 接続処理
	 * キー情報を利用してメッセージキューサーバに接続します。
	 * SQSサーバの利用で、アクセスキーを利用した接続を行う場合用です。
	 * MQサーバの場合は、キーは利用されず、connect(final String jmsServer)と同様の動作になります。
	 *
	 * @og.rev 5.10.15.0 (2019/08/30) 引数追加
	 *
	 * @param jmsServer JMSサーバ接続先
	 * @param sqsAccessKey アクセスキー
	 * @param sqsSecretKey シークレットキー
	 */
	void connect(final String jmsServer, final String sqsAccessKey, final String sqsSecretKey);

	/**
	 * メッセージ送信処理
	 * キューサーバにメッセージを送信します。
	 *
	 * @param queueInfo 送信キュー情報
	 */
	void sendMessage(final QueueInfo queueInfo);

	/**
	 * クローズ処理
	 * キューサーバの接続をクローズします。
	 *
	 */
	void close();

	/**
	 * バッチ処理判定
	 * バッチ処理判定を設定します。
	 *
	 * @param batchFlg バッチ処理判定
	 */
	void setBatchFlg(final Boolean batchFlg);
}
