<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0050"
	title	= "予定実績ﾃｰﾌﾞﾙ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<og:dataCheck command="{@command}" sqlType="{@sqlType}">
	select count(*) from GG11
	where DY_YOTE=[DY_YOTE] AND SET_KEY=[SET_KEY] AND SET_GRP=[SET_GRP]
</og:dataCheck>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:transaction>
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType= "{@sqlType}"
			table  = "GG11"
			where  = "DY_YOTE=[DY_YOTE] AND SET_KEY=[SET_KEY] AND SET_GRP=[SET_GRP]"
			omitNames = "UNIQ"
		/>
	</og:tableUpdate>
</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
