<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC23"
	title	= "ｿｰｽGrep検索"
	date	= "2015/07/03"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command		= "{@command}"
	nullCheck	= "CHBOX"
/>

<style type="text/css">
	.MARK { background-color:#ccff00 ;}
	td { white-space:pre; tab-size: 4; }
</style>

<og:equals val1="{@CHBOX}" val2="JSP|ALLCHECK" matches="true" >
	<og:file action="exists" fileURL="{@JSP_PATH}\{@JSP_DIR}">
		<!-- MSG0087:フォルダが存在していません。 -->
		<og:text>{@LBL.PATH}={@JSP_PATH}\{@JSP_DIR}</og:text>　<og:message lbl="MSG0087" /><br />
		<!-- MSG0088:アクセス可能か確認してください。 -->
		　<og:message lbl="MSG0088" /><br />
	</og:file>

	<pre>
		<og:mainProcess useJspLog="true" useDisplay="true" caseNN="{@jspWord}">
			<og:process processID="FileSearch">
				<og:param key="start"			value="{@JSP_PATH}/{@JSP_DIR}"		/>
				<og:param key="encode"			value="UTF-8"			/>
				<og:param key="unpreDir"		value="backup"			/>
				<og:param key="unFileEquals"	value="{@OMIT_PG}"		/>
				<og:param key="suffix"			value=".jsp|.js"		/>
				<og:param key="maxLevel"		value="{@maxLevel}"		/>
				<og:param key="ignoreCase"		value="true"			/>
				<og:param key="errAbend"		value="false"			/>
				<og:param key="display"			value="false"			/>
			</og:process>
			<og:process processID="Grep">
				<og:param key="keyword"			value="{@jspWord}"		/>
				<og:param key="ignoreCase"		value="true"			/>
				<og:param key="useAllFind"		value="true"			/>
				<og:param key="useOmitCmnt"		value="true"			/>
				<og:param key="errAbend"		value="false"			/>
				<og:param key="inEncode"		value="UTF-8"			/>
				<og:param key="display"			value="false"			/>
			</og:process>
		</og:mainProcess>
	</pre>
</og:equals>

<og:equals val1="{@CHBOX}" val2="SQL|ALLCHECK" matches="true" >
	<og:file action="exists" fileURL="{@SQL_PATH}\{@SQL_DIR}">
		<!-- MSG0087:フォルダが存在していません。 -->
		<og:text>{@LBL.PATH}={@SQL_PATH}\{@SQL_DIR}</og:text>　<og:message lbl="MSG0087" /><br />
		<!-- MSG0088:アクセス可能か確認してください。 -->
		　<og:message lbl="MSG0088" /><br />
	</og:file>

	<pre>
		<og:mainProcess useJspLog="true" useDisplay="true">
			<og:process processID="FileSearch">
				<og:param key="start"			value="{@SQL_PATH}/{@SQL_DIR}"		/>
				<og:param key="encode"			value="Windows-31J"		/>
				<og:param key="maxLevel"		value="{@maxLevel}"		/>
				<og:param key="unpreDir"		value="backup|BK|TABLE"	/>
				<og:param key="unFileEquals"	value="{@OMIT_PG}"		/>
				<og:param key="ignoreCase"		value="true"			/>
				<og:param key="suffix"			value=".sql"			/>
				<og:param key="errAbend"		value="false"			/>
				<og:param key="display"			value="false"			/>
			</og:process>
			<!-- {@keyword}を含み、かつ、CON_NMRTN,LOCAL_MSG_RTN,BASP0062 を含まない文字列の表現 -->
			<og:process processID="Grep">
				<og:param key="keyword"		value="^(?=.*{@sqlWord}){@OMIT_WORD}.+$"		/>
				<og:param key="ignoreCase"	value="false"			/>
				<og:param key="useAllFind"	value="true"			/>
				<og:param key="useOmitCmnt"	value="true"			/>
				<og:param key="errAbend"	value="false"			/>
				<og:param key="inEncode"	value="Windows-31J"		/>
				<og:param key="display"		value="false"			/>
			</og:process>
		</og:mainProcess>
	</pre>

	<og:equals val1="{@WORK_DIR}" val2="{@WORK_DIR}" >
		<og:value command="SET" key="XKEY"    value="X{@DATE.YMDHMS}" />
		<og:value command="SET" key="PROGRAM" value="{@CALL_BAT2}" />
		<jsp:directive.include file="shell.jsp" />
	</og:equals>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
