/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.queue;

import java.util.Locale;

// import org.opengion.fukurou.util.StringUtil;

/**
 * キュータイプ別の受信クラス生成
 * 指定されたキュータイプの受信クラスを生成します。
 *
 * 下記のキュータイプを指定可能です。
 * MQ：Active MQ or Amazon MQ
 * SQS：Amazon SQS。
 *
 * @og.group メッセージ連携
 *
 * @og.rev 5.10.15.2 (2019/09/20) 新規作成
 * @og.rev 7.2.9.4 (2020/11/20) コーディングのみ修正
 *
 * @version 5
 * @author oota
 * @since JDK7
 *
 */
final public class QueueReceiveFactory {
//	private static final int BUFFER_MIDDLE = 200;

	private static final String QUEUE_CLS = "org.opengion.fukurou.queue.QueueReceive_" ;

	/**
	 * デフォルトコンストラクター
	 * static用クラスのため、クラス生成は不可にします。
	 */
	private QueueReceiveFactory() {
	}

	/**
	 * キュー受信クラス生成
	 *
	 * 引数のキュータイプのキュー受信クラスを生成します。
	 * MQ：Apache ActiveMq、amazonMQの場合に設定します。
	 * SQS：Amazon SQSの場合に設定します。
	 *
	 * @param queueType キュータイプ
	 * @return キュータイプのキュー受信クラス
	 */
	public static QueueReceive newQueueReceive(final String queueType) {
		try {
			// 1. 前処理 大文字変換。queueType が null なら、当然エラーになる。
			// 2. 生成クラスの文字列生成
			final String cls = QUEUE_CLS + queueType.toUpperCase(Locale.JAPAN);

			// 3. 対象クラスの生成
			return (QueueReceive) Class.forName( cls ).getDeclaredConstructor().newInstance();

		} catch (final Throwable th) {
			final String errMsg = "キュー受信クラス生成に失敗しました。"
							+ " queueType =" + queueType ;
			throw new RuntimeException( errMsg ,th );
		}

//		QueueReceive queueReceive = null;
//		String setQueueType = null;
//
//		final StringBuilder path = new StringBuilder(BUFFER_MIDDLE);
//
//		// 1. 前処理
//		// 大文字変換
//		if (!StringUtil.isNull(queueType)) {
//			setQueueType = queueType.toUpperCase(Locale.JAPAN);
//		}
//
//		// 2. 生成クラスの文字列生成
//		path.append("org.opengion.fukurou.queue.")
//			.append("QueueReceive_")
//			.append(setQueueType);
//
//		try {
//			// 3. 対象クラスの生成
//			queueReceive = (QueueReceive) Class.forName(path.toString()).newInstance();
//		} catch (final Throwable th) {
//			// キャッチしたエラー情報をスロー
//			throw new RuntimeException(th);
//		}
//
//		return queueReceive;
	}
}
