/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.util.Arrays;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;

public class LineModel
implements DataModel<Object> {
    private static final char TAB = '\t';
    private String[] names;
    private Object[] data;
    private int dtSize;
    private int rowNo = -1;

    public void init(int n) {
        if (n <= 0) {
            String string = "\u5185\u90e8\u914d\u5217\u306e\u6570\u91cf\u304c 0\u304b\u3001\u8ca0\u3067\u3059\u3002count=[" + n + "]";
            throw new OgRuntimeException(string);
        }
        this.dtSize = n;
        this.names = new String[this.dtSize];
        this.data = new Object[this.dtSize];
    }

    public void init(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new OgRuntimeException("\u30ab\u30e9\u30e0\u540d\u914d\u5217\u304c\u3001\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.dtSize = stringArray.length;
        this.names = new String[this.dtSize];
        System.arraycopy(stringArray, 0, this.names, 0, this.dtSize);
        this.data = new Object[this.dtSize];
    }

    public void setName(int n, String string) {
        if (n >= 0) {
            this.names[n] = string;
        }
    }

    public String getName(int n) {
        return n >= 0 ? this.names[n] : null;
    }

    @Override
    public String[] getNames() {
        return (String[])this.names.clone();
    }

    public void setValue(int n, Object object) {
        if (n >= 0) {
            this.data[n] = object;
        }
    }

    public Object getValue(int n) {
        return n >= 0 ? this.data[n] : null;
    }

    @Override
    public Object getValue(int n, int n2) {
        return this.getValue(n2);
    }

    @Override
    public void setValues(Object[] objectArray, int n) {
        if (objectArray == null) {
            String string = "\u5024\u914d\u5217\u304c\u3001 null \u3067\u3059\u3002row=[" + n + "]";
            throw new OgRuntimeException(string);
        }
        if (this.names.length != objectArray.length) {
            String string = "\u30ab\u30e9\u30e0\u540d\u914d\u5217\u3068\u7570\u306a\u308b\u8981\u7d20\u306e\u5c5e\u6027\u5024\u914d\u5217\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002" + HybsConst.CR + " names.length=[" + this.names.length + "], values.length[" + objectArray.length + "], row=[" + n + "]" + HybsConst.CR + " names=" + StringUtil.array2csv(this.names) + " values=" + Arrays.toString(objectArray);
            throw new OgRuntimeException(string);
        }
        this.rowNo = n;
        System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
    }

    public Object[] getValues() {
        return (Object[])this.data.clone();
    }

    @Override
    public Object[] getValues(int n) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public void setRowNo(int n) {
        this.rowNo = n;
    }

    public int getRowNo() {
        return this.rowNo;
    }

    @Override
    public int getColumnNo(String string) {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this.dtSize; ++i) {
                if (!string.equalsIgnoreCase(this.names[i])) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public int size() {
        return this.dtSize;
    }

    public String nameLine() {
        String string = "No Data";
        if (this.dtSize > 0) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("#Name");
            for (int i = 0; i < this.dtSize; ++i) {
                stringBuilder.append('\t');
                stringBuilder.append(this.names[i]);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public String dataLine() {
        String string = "No Data";
        if (this.dtSize > 0) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.rowNo);
            for (int i = 0; i < this.dtSize; ++i) {
                stringBuilder.append('\t');
                stringBuilder.append(this.data[i]);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public String toString() {
        return this.nameLine() + HybsConst.CR + this.dataLine();
    }

    @Override
    public NativeType getNativeType(int n) {
        return NativeType.getType(this.data[n].toString());
    }
}

