connect 'jdbc:derby://localhost:1527/C:/euromap/dbs/javadb;user=EU63;password=EU63';



/********************************************************************************************/
/* javaDBに対して、関数を拡張します。														*/
/*																							*/
/* 【概要】 																				*/
/*	 javaDB に、特殊系の関数を登録します。													*/
/*	 これは、JavaDBが、数値⇔文字列の自動変換が出来ないための対応が、主です。				*/
/*																							*/
/* 【方法】 																				*/
/*	 １．Java関数のソースは、org.opengion.fukurou.db.Functions に定義します。				*/
/*	 ２．apps/endorsedX.0 フォルダに、ogJavaFunction.jar ファイルをコピーします。			*/
/*	 ３．JavaDB から、上記クラスが見えるようにします。										*/
/*		 具体的には、apps\jdk9u01\db\bin\startNetworkServer.bat (JavaDB 起動スクリプト)に	*/
/*		 set CLASSPATH=%OG_CLASSPATH%; を追記します。										*/
/*		 OG_CLASSPATH は、Tomcat起動用に、uap\bin\const.bat に定義済みです。				*/
/*		 これで、apps/endorsedX.0 フォルダが見える環境になります。							*/
/*	 ４．JavaDBに対して、FUNCTION を定義します。											*/
/********************************************************************************************/

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* ただし、元の数字に端数がない場合は、".0" 部分をカットします。							*/
/* 6.9.8.0 (2018/05/28)																		*/
/********************************************************************************************/
DROP FUNCTION TO_CHAR;

CREATE FUNCTION TO_CHAR ( VAL DOUBLE )
RETURNS VARCHAR(20)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.toChar' ;

/********************************************************************************************/
/* 文字列を数値に変換します。																*/
/* ORACLEとなんとなく互換を持たせるため、TO_NUMBER 関数を作成します。						*/
/********************************************************************************************/
DROP FUNCTION TO_NUMBER;

CREATE FUNCTION TO_NUMBER ( VAL VARCHAR(20) )
RETURNS DOUBLE
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'java.lang.Double.parseDouble' ;


/********************************************************************************************/
/* 文字列を置換します。																		*/
/* 第１引数の文字列から、第２引数の部分文字列を、第２引数の文字列を置き換えます。			*/
/* 6.9.8.0 (2018/05/28)																		*/
/********************************************************************************************/
DROP FUNCTION REPLACE;

CREATE FUNCTION REPLACE ( VARCHAR(2000) , VARCHAR(2000) , VARCHAR(2000) )
RETURNS VARCHAR(4000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.replace' ;


/********************************************************************************************/
/* 文字列を連結します。																		*/
/* 第１引数の数字と、第２、第３、第４の文字列をスペースで連結した文字列を返します。			*/
/* 6.8.5.1 (2018/01/15)																		*/
/********************************************************************************************/
DROP FUNCTION JOIN2;

CREATE FUNCTION JOIN2 ( INTEGER , VARCHAR(2000) , VARCHAR(2000) , VARCHAR(2000) )
RETURNS VARCHAR(4000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.join2' ;


/********************************************************************************************/
/* 指定の日付文字列を指定の形式の文字列に変換します。										*/
/* 第１引数の日付文字列と、第２引数の yyyyMMddHHmmss 形式フォーマットで変換します。			*/
/* 7.0.1.2 (2018/11/04)																		*/
/********************************************************************************************/
DROP FUNCTION TO_YMD;

CREATE FUNCTION TO_YMD ( VARCHAR(100) , VARCHAR(100) )
RETURNS VARCHAR(100)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.util.HybsDateUtil.toYmd' ;


/********************************************************************************************/
/* 部分文字列の出現位置を検索します。														*/
/* 第１引数の検索元の文字列と、第２引数の部分文字列を指定します。							*/
/* 戻り値は、Javaの indexOf とは異なり、＋１ された値が返ります。							*/
/* 7.3.0.0 (2021/01/06)																		*/
/********************************************************************************************/
DROP FUNCTION INSTR;

CREATE FUNCTION INSTR ( VARCHAR(1000) , VARCHAR(100) )
RETURNS INTEGER
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.instr' ;


/********************************************************************************************/
/* 文字列を連結します。 																	*/
/*																							*/
/* 文字列が、NULL の場合は、ゼロ文字列として扱います。										*/
/* 引数がどちらも NULL の場合は、ゼロ文字列が戻されます。									*/
/* これは、ORACLEとの互換性を考慮した関数です。 											*/
/* ORACLE は、NULLとゼロ文字列を同等にNULLとして扱うため、									*/
/* COALESCE( VAL1,'' ) で、VAL1がNULLか、ゼロ文字列の場合は、NULLが返されます。 			*/
/* NULLを含むWHERE条件で、WHERE COALESCE( VAL1,'' ) = COALESCE( VAL2,'' )					*/
/* としても、一致しないため、WHERE COALESCE( VAL1,'x' ) = COALESCE( VAL2,'x' )				*/
/* とする必要がありますが、VAL1が、実際の 'x' で、VAL2がNULLの場合もマッチします。			*/
/* 一方、Derbyでは、NULLとゼロ文字列を区別するため、COALESCE( VAL1,'x' ) の 				*/
/* VAL1の値が、NULLとゼロ文字列で、結果が変わってしまいます。								*/
/* また、|| による文字列連結も、ORACLEとDerbyでは結果が変わるため、 						*/
/* CONCAT関数を作成して、ORACLEと同じSQL文での比較ができるようにしておきます。				*/
/* 7.3.0.0 (2021/01/06)																		*/
/********************************************************************************************/
DROP FUNCTION CONCAT;

CREATE FUNCTION CONCAT ( VARCHAR(1000) , VARCHAR(1000) )
RETURNS VARCHAR(2000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.concat' ;

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* ただし、元の数字に端数がない場合は、".0" 部分をカットします。							*/
/* … 廃止 																					*/
/********************************************************************************************/
-- DROP FUNCTION LPAD0;
--
-- CREATE FUNCTION LPAD0 ( INTEGER , INTEGER )
-- RETURNS VARCHAR(100)
-- DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
-- PARAMETER STYLE JAVA	-- 戻り値のタイプ
-- NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
-- EXTERNAL NAME 'org.opengion.fukurou.db.Functions.lpad0' ;


/********************************************************************************************/
/* NULL文字列の判定変換を行います。															*/
/*																							*/
/* 文字列が、NULL(または空文字列)は、文字列2を、NULLでない場合は、文字列1を返します。		*/
/* Derbyでは、NULLと空文字列が区別されますが、ORACLE等では、区別されないため、				*/
/* この関数でも区別しません。																*/
/* 空文字列の場合は、NULLと同じになります。													*/
/*																							*/
/* 7.3.1.3 (2021/03/09)																		*/
/********************************************************************************************/
DROP FUNCTION NVL2;

CREATE FUNCTION NVL2 ( VARCHAR(1000) , VARCHAR(1000) , VARCHAR(1000) )
RETURNS VARCHAR(1000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.nvl2' ;

