/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP19150A ( PACKAGE BODY )                                               */
/* Created : 2021/06/23 16:36:21                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP19150A AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP19150A
*	処理名			:	一覧検索一覧登録
*	作成日			:	2007/09/01
*	作成者			:	XXXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF19150A(
	 PO_KEKKA		OUT	NUMBER													-- 処理結果(0:正常 1:警告 2:異常)
	,PO_ERRMSGS		OUT	ERR_MSG_ARRAY											-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PI_NAMES		IN	VARCHAR2												-- 項目名
	,PI_SYSARGS		IN	SYSARG_ARRAY											-- ｼｽﾃﾑﾃﾞｰﾀ
	,PI_GF9150ARG	IN	GF9150ARG_ARRAY											-- 登録ﾃﾞｰﾀ配列
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	--定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)	:= 'GFP19150A';					-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)	:= PI_SYSARGS(1).PGID;			-- 画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)	:= PI_SYSARGS(1).CDATE;			-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(10)	:= PI_SYSARGS(1).USERID;		-- ﾛｸﾞｲﾝﾕｰｻﾞｰ

	--変数定義
	G_I				NUMBER;														-- 行番号
	G_RTN			BOOLEAN;													-- ﾘﾀｰﾝ値
	G_ERRSTP		VARCHAR2(1000)	:= NULL;									-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
	G_DISP_KEY		VARCHAR2(1000)	:= NULL;									-- ｷｰ項目

	--EXCEPTION定義
	UNMATCH_CDKH	EXCEPTION;

	--ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERROR_CHECK	RETURN BOOLEAN;
	FUNCTION	INSERT_RTN	RETURN BOOLEAN;
	FUNCTION	UPDATE_RTN	RETURN BOOLEAN;
	FUNCTION	DELETE_RTN	RETURN BOOLEAN;
/*******************************************************************************
*	ERROR_CHECK 入力ｴﾗｰﾁｪｯｸ
*******************************************************************************/
FUNCTION ERROR_CHECK
RETURN BOOLEAN
IS
	L_COUNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='ERR_CHARCK';

	IF PI_SYSARGS(G_I).CDKH = 'A' THEN
		G_ERRSTP:='ERR_CHARCK_EXIST_A';
		--存在ﾁｪｯｸ
		SELECT	COUNT(*)
		INTO	L_COUNT
		FROM	GF41
		WHERE	SYSTEM_ID	=	PI_GF9150ARG(G_I).SYSTEM_ID						-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
		AND		LANG		=	PI_GF9150ARG(G_I).LANG							-- 言語   ＝ 画面》言語
		AND		CLM			=	PI_GF9150ARG(G_I).CLM							-- 項目   ＝ 画面》項目
		AND		FGJ			IN	('0','1');										-- 状態F  IN ('0','1')

		IF NVL(L_COUNT,0) > 0 THEN
			--「既にﾃﾞｰﾀが存在します。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,2													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0002'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
		END IF;
	ELSE
		G_ERRSTP:='ERR_CHARCK_EXIST_UD';
		--存在ﾁｪｯｸ
		SELECT	COUNT(*)
		INTO	L_COUNT
		FROM	GF41
		WHERE	SYSTEM_ID	=	PI_GF9150ARG(G_I).SYSTEM_ID						-- ｼｽﾃﾑID ＝ 画面》ｼｽﾃﾑID
		AND		LANG		=	PI_GF9150ARG(G_I).LANG							-- 言語   ＝ 画面》言語
		AND		CLM			=	PI_GF9150ARG(G_I).CLM							-- 項目   ＝ 画面》項目
		AND		FGJ			IN	('0','1');										-- 状態F  IN ('0','1')

		IF NVL(L_COUNT,0) <= 0 THEN
			--「ﾃﾞｰﾀが存在しません。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(G_I).NO									-- 行番号
							,2													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0003'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
		END IF;
	END IF;

	RETURN TRUE;
END ERROR_CHECK;
/*******************************************************************************
*	INSERT_RTN 追加
*******************************************************************************/
FUNCTION INSERT_RTN
RETURN BOOLEAN
IS
	L_STATUS	NUMBER(1) := 0;
BEGIN
	G_ERRSTP:='INSERT_RTN';

/*
	G_ERRSTP		:= 'GF41_INSERT_RTN_INS';
	INSERT INTO GF41 (
		 SYSTEM_ID																-- ｼｽﾃﾑID
		,LANG																	-- 言語
		,CLM																	-- 項目
		,NAME_JA																-- 名称（漢字）
		,LABEL_NAME																-- 表示名称
		,KBSAKU																	-- 作成区分
		,CDTAN																	-- 担当者
		,FGJ																	-- 状態F
		,DYSET																	-- 作成日時
		,PGSET																	-- 作成PG
		,PGPSET																	-- 作成呼出PG
		,USRSET																	-- 作成ﾕｰｻﾞｰ
		,DYUPD																	-- 更新日時
		,PGUPD																	-- 更新PG
		,PGPUPD																	-- 更新呼出PG
		,USRUPD																	-- 更新ﾕｰｻﾞｰ
	)
	VALUES (
		 PI_GF9150ARG(G_I).SYSTEM_ID											-- ｼｽﾃﾑID
		,PI_GF9150ARG(G_I).LANG													-- 言語
		,PI_GF9150ARG(G_I).CLM													-- 項目
		,PI_GF9150ARG(G_I).NAME_JA												-- 名称（漢字）
		,PI_GF9150ARG(G_I).LABEL_NAME											-- 表示名称
		,PI_GF9150ARG(G_I).KBSAKU												-- 作成区分
		,PI_GF9150ARG(G_I).CDTAN												-- 担当者
		,'1'																	-- 状態F
		,CON_SYSDATE															-- 作成日時
		,CON_PGID																-- 作成PG
		,CON_PGPID																-- 作成呼出PG
		,CON_USER																-- 作成ﾕｰｻﾞｰ
		,CON_SYSDATE															-- 更新日時
		,CON_PGID																-- 更新PG
		,CON_PGPID																-- 更新呼出PG
		,CON_USER																-- 更新ﾕｰｻﾞｰ
	);
*/
	G_ERRSTP		:= 'GF41_INSERT_RTN_GFP00001';
	--共通SPｻﾝﾌﾟﾙ(GFP00001)
	GFP00001.GF00001(
					 L_STATUS													-- ｽﾃｰﾀｽ
					,PO_ERRMSGS													-- ｴﾗｰﾒｯｾｰｼﾞ配列
					,CON_PGPID													-- 画面ID
					,PI_SYSARGS(G_I).NO											-- 行番号
					,PI_GF9150ARG(G_I).SYSTEM_ID								-- ｼｽﾃﾑID
					,PI_GF9150ARG(G_I).LANG										-- 言語
					,PI_GF9150ARG(G_I).CLM										-- 項目
					,PI_GF9150ARG(G_I).NAME_JA									-- 名称（漢字）
					,PI_GF9150ARG(G_I).LABEL_NAME								-- 表示名称
					,PI_GF9150ARG(G_I).KBSAKU									-- 作成区分
					,PI_GF9150ARG(G_I).CDTAN									-- 担当者
					,CON_USER													-- ﾛｸﾞｲﾝﾕｰｻﾞｰ
					);

	--ｽﾃｰﾀｽが9（ｵﾗｸﾙｴﾗｰ発生）が返ってきた場合は必ずHYBS.COMMONSP_ERRORをRAISEします。
	IF	L_STATUS = 9 THEN
		RAISE HYBS.COMMONSP_ERROR;
	--ｽﾃｰﾀｽが1（異常）の場合の処理は任意です
	ELSIF	L_STATUS = 1 THEN
	--行いたい処理（例えばRETURN FALSE）に書き換えて下さい。
		NULL;
	END IF;

	RETURN TRUE;
END INSERT_RTN;
/*******************************************************************************
*	UPDATE_RTN 更新
*******************************************************************************/
FUNCTION UPDATE_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP:='UPDATE_RTN';

	UPDATE	GF41	SET
			 NAME_JA		=	PI_GF9150ARG(G_I).NAME_JA						-- 名称（漢字）
			,LABEL_NAME		=	PI_GF9150ARG(G_I).LABEL_NAME					-- 表示名称
			,KBSAKU			=	PI_GF9150ARG(G_I).KBSAKU						-- 作成区分
			,CDTAN			=	PI_GF9150ARG(G_I).CDTAN							-- 担当者
			,DYUPD			=	CON_SYSDATE										-- 更新日時
			,PGUPD			=	CON_PGID										-- 更新PG
			,PGPUPD			=	CON_PGPID										-- 更新呼出PG
			,USRUPD			=	CON_USER										-- 更新ﾕｰｻﾞｰ
	WHERE	UNIQ			=	PI_GF9150ARG(G_I).UNIQ;							-- ﾕﾆｰｸ ＝ 画面》ﾕﾆｰｸ

	RETURN TRUE;
END UPDATE_RTN;
/*******************************************************************************
*	DELETE_RTN 削除
*******************************************************************************/
FUNCTION DELETE_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP:='DELETE_RTN';

	UPDATE	GF41	SET
			 FGJ			=	'9'												-- 状態F
			,DYUPD			=	CON_SYSDATE										-- 更新日時
			,PGUPD			=	CON_PGID										-- 更新PG
			,PGPUPD			=	CON_PGPID										-- 更新呼出PG
			,USRUPD			=	CON_USER										-- 更新ﾕｰｻﾞｰ
	WHERE	UNIQ			=	PI_GF9150ARG(G_I).UNIQ;							-- ﾕﾆｰｸ ＝ 画面》ﾕﾆｰｸ

--	DELETE	GF41
--	WHERE	UNIQ			=	PI_GF9150ARG(G_I).UNIQ;							-- ﾕﾆｰｸ ＝ 画面》ﾕﾆｰｸ

	RETURN TRUE;
END DELETE_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='MAIN_S';
	--処理結果(2:異常)
	PO_KEKKA := 2;

/*			--「ﾃﾞｰﾀが存在しません。{0} {1}」
			HYBS.SET_ERRMSGS(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
							,PI_SYSARGS(1).NO									-- 行番号
							,2													-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
							,'GFE0003'											-- ｴﾗｰﾒｯｾｰｼﾞID
							,'{#GF41}'											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
							,G_DISP_KEY											-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{1}
							);
	PO_KEKKA := 2;
	RETURN;
*/
	G_ERRSTP:='MAIN_ERR_LOOP';
	-- 登録ﾃﾞｰﾀﾁｪｯｸ処理ﾙｰﾌﾟ
	FOR I IN 1..PI_SYSARGS.COUNT LOOP
		G_I	:=	I;
		G_DISP_KEY := ' SYSTEM_ID='|| PI_GF9150ARG(G_I).SYSTEM_ID||
					  ' LANG='|| PI_GF9150ARG(G_I).LANG||
					  ' CLM='|| PI_GF9150ARG(G_I).CLM||
					  ' UNIQ='|| PI_GF9150ARG(G_I).UNIQ;
		--ｴﾗｰﾁｪｯｸ
		G_RTN := ERROR_CHECK;
	END LOOP;
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

	-- 処理結果判定
	IF PO_KEKKA < 2 THEN
		G_ERRSTP:='MAIN_LOOP';
		-- ﾃﾞｰﾀ登録処理ﾙｰﾌﾟ
		FOR I IN 1..PI_SYSARGS.COUNT LOOP
			G_I	:=	I;
			--ｷｰ項目ｾｯﾄ
			G_DISP_KEY := ' SYSTEM_ID='|| PI_GF9150ARG(G_I).SYSTEM_ID||
						  ' LANG='|| PI_GF9150ARG(G_I).LANG||
						  ' CLM='|| PI_GF9150ARG(G_I).CLM||
						  ' UNIQ='|| PI_GF9150ARG(G_I).UNIQ;



			-- 改廃ｺｰﾄﾞ判定(追加／複写)
			IF PI_SYSARGS(G_I).CDKH = 'A' THEN
				-- 追加／複写処理
				G_RTN := INSERT_RTN;
			-- 改廃ｺｰﾄﾞ判定(変更)
			ELSIF PI_SYSARGS(G_I).CDKH = 'C' THEN



				-- 変更処理
				G_RTN := UPDATE_RTN;
			-- 改廃ｺｰﾄﾞ判定(削除)
			ELSIF PI_SYSARGS(G_I).CDKH = 'D' THEN
				-- 削除処理
				G_RTN := DELETE_RTN;
			ELSE
				-- 改廃ｺｰﾄﾞｴﾗｰ
				RAISE UNMATCH_CDKH;
			END IF;
		END LOOP;
	END IF;

	G_ERRSTP:='MAIN_E';
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS);

/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- 「改廃ｺｰﾄﾞｴﾗｰ 改廃ｺｰﾄﾞ:{0}」
	WHEN UNMATCH_CDKH THEN
		HYBS.SET_ERRMSGS(PO_ERRMSGS												-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,'GFE0004'												-- ｴﾗｰﾒｯｾｰｼﾞID
						,PI_SYSARGS(G_I).CDKH									-- ﾒｯｾｰｼﾞﾊﾟﾗﾒｰﾀ{0}
						);
		PO_KEKKA := 2;

	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,'GFE0005'												-- 共通SPｴﾗｰ発生
						,G_DISP_KEY												-- ｷｰ項目
						);
		PO_KEKKA := 2;

	--	ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_SYSARGS(G_I).NO										-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		PO_KEKKA := 2;

END GF19150A;
END GFP19150A;
;
