/****************************************************************************/
/* GF64 ( ﾀｽｸﾂﾘｰ )                                                          */
/*                                                                          */
/* Created : 2021/06/29 14:03:35                                            */
/****************************************************************************/

CREATE TABLE GF64 (
   PRJCODE      VARCHAR2 (   30 )                                       /*  1 PRJｺｰﾄﾞ       */
 , TASK_ID      NUMBER   (    5 )                                       /*  2 ﾀｽｸID         */
 , SEQ          NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  3 順            */
 , TASK_LEVEL   NUMBER   (    2 )                                       /*  4 ﾚﾍﾞﾙ          */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  5 名称          */
 , MEETING      VARCHAR2 (    1 )       DEFAULT '0'                     /*  6 ﾏｲﾙｽﾄｰﾝ       */
 , DYSTART      VARCHAR2 (   14 )                                       /*  7 開始日        */
 , DURATION     NUMBER   (  4,1 )                                       /*  8 期間          */
 , COMPLETE     NUMBER   (    3 )                                       /*  9 進捗率        */
 , PRIORITY     VARCHAR2 (    1 )                                       /* 10 優先度        */
 , NOTES        VARCHAR2 ( 4000 )                                       /* 11 ﾉｰﾄ           */
 , COLOR        VARCHAR2 (   50 )                                       /* 12 色記号        */
 , SHAPE        VARCHAR2 (   16 )                                       /* 13 模様          */
 , DEPEND_ID1   NUMBER   (    5 )                                       /* 14 先行ﾀｽｸID1    */
 , DEPEND_TYPE1 VARCHAR2 (    1 )                                       /* 15 先行ﾀｽｸﾀｲﾌﾟ1  */
 , DEPEND_ID2   NUMBER   (    5 )                                       /* 16 先行ﾀｽｸID2    */
 , DEPEND_TYPE2 VARCHAR2 (    1 )                                       /* 17 先行ﾀｽｸﾀｲﾌﾟ2  */
 , DEPEND_ID3   NUMBER   (    5 )                                       /* 18 先行ﾀｽｸID3    */
 , DEPEND_TYPE3 VARCHAR2 (    1 )                                       /* 19 先行ﾀｽｸﾀｲﾌﾟ3  */
 , DEPEND_ID4   NUMBER   (    5 )                                       /* 20 先行ﾀｽｸID4    */
 , DEPEND_TYPE4 VARCHAR2 (    1 )                                       /* 21 先行ﾀｽｸﾀｲﾌﾟ4  */
 , DEPEND_ID5   NUMBER   (    5 )                                       /* 22 先行ﾀｽｸID5    */
 , DEPEND_TYPE5 VARCHAR2 (    1 )                                       /* 23 先行ﾀｽｸﾀｲﾌﾟ5  */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 24 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 25 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                       /* 26 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                       /* 27 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                       /* 28 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                       /* 29 作成社員      */
 , DYUPD        VARCHAR2 (   14 )                                       /* 30 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                       /* 31 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 32 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                       /* 33 更新者        */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 64K );


CREATE SEQUENCE GF64S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF64T00 
  BEFORE INSERT ON GF64
  FOR EACH ROW 
  BEGIN 
    SELECT GF64S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
