package gf;

import java.util.ArrayList;
import java.util.List;

import org.opengion.fukurou.business.BizLogic_TABLE;
// import org.opengion.penguin.math.statistics.HybsSingleRegression;
import org.opengion.penguin.math.statistics.HybsRegression;
import org.opengion.penguin.math.statistics.HybsSimpleRegression;
import org.opengion.penguin.math.statistics.HybsSquadraticRegression;

/**
 * 指定したDB項目の単回帰係数を出力します。
 * penguinパッケージを利用して、相関係数を計算します。
 *
 * @version 5.0
 * @author T.OTA
 * @author JDK1.7
 *
 */
public class GFX029B extends BizLogic_TABLE{
	List<double[]> dataList	= new ArrayList<double[]>();

	/**
	 * メインカーソルの各行で呼ばれるロジックを定義します
	 *
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean befall( int row ) {
		double[] lineData = new double[2];
		String clm1 = var("COLUMN_NAME1");
		String clm2 = var("COLUMN_NAME2");
		if(isEmpty( line(clm1) )){
			lineData[0] = 0;
		}else{
			lineData[0] = lined(clm1);
		}
		if(isEmpty( line(clm2))){
			lineData[1] = 0;
		}else{
			lineData[1] = lined(clm2);
		}
		dataList.add( lineData );
		return true;
	}

	/**
	 * 空ﾁｪｯｸ
	 * @param str
	 * @return true:空 false:空でない
	 */
	private boolean isEmpty(String str){
		return "".equals( str ) || str == null ;	// 8.0.0.0 (2021/07/31) Avoid unnecessary if..then..else statements when returning booleans
//		if("".equals( str ) || str == null){
//			return true;
//		}
//		return false;
	}

	/**
	 * 最後の行の終わりで呼び出し
	 *
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		StringBuilder sb = new StringBuilder();

//		HybsSingleRegression hsr;
		HybsRegression hsr;

		String methodCalc = var("METHOD_CALC");
		String columnName1 = var("COLUMN_NAME1");

		if("1".equals(methodCalc)){
			hsr = new HybsSimpleRegression((double[][])dataList.toArray(new double[dataList.size()][2]));
		}else{
			hsr = new HybsSquadraticRegression((double[][])dataList.toArray(new double[dataList.size()][2]));
		}

		double[] coefficients = hsr.getCoefficient();

		if("1".equals(methodCalc)){
//			sb.append( columnName1 ).append(" * ").append( checkNan(coefficients[0]) ).append(" + ").append( checkNan(coefficients[1]));
			sb.append( columnName1 ).append(" * ").append( checkNan(coefficients[1]) ).append(" + ").append( checkNan(coefficients[0]));
		}else{
//			sb.append( columnName1  ).append( " * " ).append( columnName1 ).append( " * " ).append( checkNan(coefficients[0]) )
//			.append( " + " ).append( columnName1 ).append( " * " ).append( checkNan(coefficients[1]) )
//			.append( " + " ).append( checkNan(coefficients[2]) );
			sb.append( columnName1  ).append( " * " ).append( columnName1 ).append( " * " ).append( checkNan(coefficients[2]) )
			.append( " + " ).append( columnName1 ).append( " * " ).append( checkNan(coefficients[1]) )
			.append( " + " ).append( checkNan(coefficients[0]) );
		}

		rtn(sb.toString());

		return true;
	}

	/**
	 * doubleがNanの場合は0を返す。
	 *
	 * @param val
	 * @return 値
	 */
	private double checkNan(double val){
		if(Double.isNaN( val )){
			val = 0;
		}
		return val;
	}
}
