/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

/**
 * ファイル操作のインタフェース
 *
 * ローカルサーバ、クラウドストレージ(AWS,AZURE,BLUEMIX,ORACLE)のファイル操作用です。
 * FileOperationFactoryを通して、インスタンスを生成可能です。
 * Fileクラスを継承しているため、通常のFileとしても扱えます。
 *
 * @og.group ファイル操作
 *
 * @og.rev 5.10.8.0 (2019/02/01) 新規作成
 * @og.rev 5.10.9.0 (2019/03/01) 変更対応
 * @author oota
 * @since	JDK7.0
 */
public class FileOperation extends File{
	//* このプログラムのVERSION文字列を設定します。{@VALUE} */
	private static final String VERSION = "8.0.0.1 (2021/10/08)" ;
	private static final long serialVersionUID = 800120211008L ;

//	private final String myplugin;		// プラグイン
//	private final String mybucket;		// バケット

	/**
	 * コンストラクタ
	 *
	 * 初期化処理。
	 *
	 * @param path ﾌｧｲﾙﾊﾟｽ
	 */
	public FileOperation(final String path) {
		super(path);
	}

//	/**
//	 * コンストラクタ
//	 *
//	 * FileOperationクラスでは、buketは使用しません。
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @param bucket バケット名
//	 * @param path ファイルパス
//	 */
//	public FileOperation(final String bucket, final String path) {
//		this(path);
//		mybucket = bucket;
//	}

	/**
	 * 書き込み処理
	 *
	 * InputStreamのデータを書き込みます。
	 *
	 * @param is 書き込みデータのInputStream
	 * @throws IOException ファイル関連エラー情報
	 */
	public void write(final InputStream is) throws IOException {
		// InpustStreamを対象パスに出力
		Files.copy(is, Paths.get(this.getPath()), StandardCopyOption.REPLACE_EXISTING);
	}

	/**
	 * 読み込み処理
	 *
	 * データを読み込み、InputStreamとして、返します。
	 *
	 * @return 読み込みデータのInputStream
	 * @throws FileNotFoundException ファイル非存在エラー情報
	 */
	public InputStream read() throws FileNotFoundException {
		return new FileInputStream(this.getPath());
	}

	/**
	 * コピー処理
	 *
	 * ファイルを指定先にコピーします。
	 *
	 * @param afPath コピー先
	 * @return 成否フラグ
	 */
	public boolean copy(final String afPath) {
		boolean flgRtn = false;

		try {
			// 指定パスのファイルを、指定先にコピー from;jdk7
			Files.copy(Paths.get(this.getPath()), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			flgRtn = true;
		} catch (IOException ie) {
			System.err.println( ie.getMessage() );	// 8.0.0.0 (2021/07/31)
//			;	// スルーしてfalseを返す
		}

		return flgRtn;
	}

	/**
	 * ファイル移動
	 *
	 * ファイルを指定先に移動します。
	 *
	 * @param afPath 移動先
	 * @return 成否フラグ
	 */
	public boolean move(final String afPath) {
		boolean flgRtn = false;

		try {
			// 指定パスのファイルを、指定先に移動 from:jdk7
			Files.move(Paths.get(this.getPath()), Paths.get(afPath), StandardCopyOption.REPLACE_EXISTING);
			flgRtn = true;
		} catch (IOException ie) {
			System.err.println( ie.getMessage() );	// 8.0.0.0 (2021/07/31)
//			;	// スルーしてfalseを返す
		}
		return flgRtn;
	}

//	/**
//	 * 保存先のローカル判定。
//	 *
//	 * 判定結果を返します。
//	 * trueの場合は、ローカル保存。
//	 * falseの場合は、クラウドストレージに保存です。
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @return ローカルフラグ
//	 */
//	public boolean isLocal() {
//		return true;
//	}

	/**
	 * 保存先のクラウド判定。
	 *
	 * 判定結果を返します。
	 * trueの場合は、クラウドストレージ保存。
	 * falseの場合は、ローカルに保存です。
	 *
	 * @og.rev 8.0.0.1 (2021/10/08) ｸﾗｳﾄﾞ修正
	 *
	 * @return クラウドならtrue
	 */
	public boolean isCloud() {
		return false;
	}

	/**
	 * カノニカルファイル取得。
	 *
	 * カノニカルファイル情報を取得します。
	 *
	 * @throws IOException ファイル関連エラー情報
	 * @return カノニカルファイル情報
	 */
	@Override
	public FileOperation getCanonicalFile() throws IOException {
		final String canonPath = getCanonicalPath();
		return new FileOperation(canonPath);
	}

	/**
	 * バケット名取得。
	 *
	 * バケット名を取得します。
	 * 生のFileOperationは、null を返します。
	 * 継承先で実際の値を設定してください。
	 *
	 * @return バケット名
	 */
	public String getBucket() {
//		return mybucket;
		return null;
	}

	/**
	 * プラグイン名取得。
	 *
	 * プラグイン名を取得します。
	 * 生のFileOperationは、null を返します。
	 * 継承先で実際の値を設定してください。
	 *
	 * @return プラグイン名
	 */
	public String getPlugin() {
//		return this.myplugin;
		return null;
	}

//	/**
//	 * プラグイン名のセット。
//	 *
//	 * プラグイン名をセットします。
//	 *
//	 * @og.rev 8.0.0.1 (2021/10/08) 削除
//	 *
//	 * @param plugin プラグイン名
//	 */
//	protected void setPlugin( final String plugin ) {
//		myplugin = plugin;
//	}
}
