<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0020"
	title	= "雛形設定ﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	A.SET_GRP,A.TOKEN
				,COALESCE(A.TKN_NM,B.TKN_NM) AS TKN_NM
				,B.VIEW_LEN,B.TANI,B.DATA_TYPE
				,A.TKN_GRP,A.DEF_VAL,A.GRP_POS
				,A.ROWNO,A.COLNO,A.COLSPAN,A.ROWSPAN
				,A.CDREC,A.CDDISP,A.TAB_NM
				,A.E_MIN,A.W_MIN,A.W_MAX,A.E_MAX,A.OPT_ATTR
				,A.UNIQ,A.FGJ,A.USRSET,A.DYSET,A.USRUPD,A.DYUPD
		from GG02 A left outer join GG01 B
				on A.TOKEN = B.TOKEN
	<og:where>
		<og:and value = "A.SET_GRP	= '{@SET_GRP}'"			/>
		<og:and value = "A.TOKEN	like '{@TOKEN}'"		/>
		<og:and value = "( A.TKN_NM like '{@TKN_NM}' or B.TKN_NM like '{@TKN_NM}' )" />
		<og:and value = "A.TAB_NM	like '{@TAB_NM}'"		/>
		<og:and value = "A.TKN_GRP	= '{@TKN_GRP}'"			/>
		<og:and value = "B.DATA_TYPE= '{@DATA_TYPE}'"		/>
		<og:and value = "A.CDREC	= '{@CDREC}'"			/>
		<og:and value = "A.CDDISP	= '{@CDDISP}'"			/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SET_GRP,A.ROWNO,A.COLNO" />
</og:query>

<og:columnEditor columns="SET_GRP,TOKEN,UNIQ"	must="true" />

<!-- ﾃﾞｰﾀ型が、TP_MENU の場合は、項目を作成できるように ﾘﾝｸを張っておきます -->
<og:viewLink command="{@command}">
	<og:link column="DATA_TYPE" gamenId="GG0030" href="index.jsp" target="CONTENTS" onLink="[DATA_TYPE]" markList="TP_MENU|TP_RADIO"
		keys="SEL_TYPE,SEL_KEY,command" vals="3,[TOKEN],NEW" ><div style="background-color:#ccff00">[DATA_TYPE]</div></og:link>
</og:viewLink>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="VIEW_LEN,TANI,DATA_TYPE" />
		<og:submit  action="MODIFY"  noWritable="FGJ,SET_GRP,TOKEN,VIEW_LEN,TANI,DATA_TYPE"  />
		<og:submit  action="DELETE"  columnWritable="null" />

		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="{@LBL.GG02}" /></strong></legend>
			<!-- GG03 の 選択ﾀｲﾌﾟ(SEL_TYPE)='1' で、SET_GRP をキーに登録している選択肢 -->
			<og:column name="SET_GRP"	useRequestValue="false" td="no" />
			<og:submit action="COPY" noWritable="null" lbl="{@LBL.INSERT}" value="gg02insert"  />
		</fieldset>
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
