<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0040"
	title	= "履歴ﾃｰﾌﾞﾙ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<og:value command="SET" key="YMDFROM" value='{@NVL.DYFROM "@DATE.YMD M-1"}' />	<!-- １ヶ月前 -->
<og:value command="SET" key="YMDTO"   value='{@NVL.DYTO    @DATE.YMD     }' />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	select	A.DY_HATU,A.SET_KEY,A.SET_GRP,A.TOKEN
			,COALESCE(C.TKN_NM,B.TKN_NM) AS TKN_NM
			,A.VAL,A.TANI,B.DATA_TYPE
			,A.JUDG,A.RIYU,A.UPCNT
			,C.TAB_NM,C.ROWNO,C.COLNO,C.E_MIN,C.W_MIN,C.W_MAX,C.E_MAX,C.OPT_ATTR
			,A.UNIQ,A.FGJ,A.USRSET,A.DYSET,A.USRUPD,A.DYUPD
	from GG10 A inner join GG01 B
			on A.TOKEN = B.TOKEN
				inner join GG02 C
				on  A.SET_GRP = C.SET_GRP
				and A.TOKEN   = C.TOKEN
	<og:where>
		<og:and value = "A.DY_HATU	&gt;= '{@YMDFROM}'"		/>
		<og:and value = "A.DY_HATU	&lt;= '{@YMDTO}'"		/>
		<og:and value = "A.JUDG		=    '{@JUDG}'"			/>
		<og:and value = "A.SET_GRP	=    '{@SET_GRP}'"		/>
		<og:and value = "A.SET_KEY	like '{@SET_KEY}'"		/>
		<og:and value = "A.VAL		like '{@VAL}'"			/>
		<og:and value = "A.TOKEN	like '{@TOKEN}'"		/>
		<og:and value = "C.TKN_NM	like '{@TKN_NM}'"		/>
		<og:and value = "C.TKN_GRP	=    '{@TKN_GRP}'"		/>
		<og:and value = "A.RIYU		like '{@RIYU}'"			/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.DY_HATU DESC,A.SET_KEY,A.SET_GRP,C.ROWNO,C.COLNO,A.UPCNT DESC" />
</og:query>

<!-- 同一 TOKEN で、更新ｶｳﾝﾀ(UPCNT) が一番大きいレコードのみ表示します。(order by で先に現れる) -->
<og:tableMerge
	action		= "GROUP"
	masterKeys	= "DY_HATU,SET_KEY,SET_GRP,TOKEN"
	caseKey		= "{@FG_NEW}"
	caseVal		= "1"
	display		= "{@debug}"
/>

<!-- og:columnEditor column="VAL" renderer="KVMENU" param="0:未 1:OK 2:NG"  / -->
<og:columnEditor column="VAL" renderer="MENU" codeName="TP_ON" dbType="S9" />

<jsp:directive.include file="/jsp/customGG/colorCSS.jsp" />

<style>
	.TP_ON  , .TP_CHECK { text-align: center; }
	.TP_INT , .TP_REAL  { text-align: right;  }
</style>

<!-- 回転処理を実行する場合は、ここで終了 -->
<og:equals val1="{@FG_RTT}" val2="1" useStop="true">
	<og:viewMarker command="{@command}" >
		<!-- FG_OMT:単位除外 が '0’は、単位を表示する -->
		<og:columnMarker column="VAL" caseKey="{@FG_OMT}" caseVal="0">
			<div class="judg[!JUDG] [!DATA_TYPE]">[VAL] [TANI]</div>
		</og:columnMarker>
		<!-- FG_OMT:単位除外 が '1’は、単位を表示しない -->
		<og:columnMarker column="VAL" caseKey="{@FG_OMT}" caseVal="1">
			<div class="judg[!JUDG] [!DATA_TYPE]">[VAL]</div>
		</og:columnMarker>
	</og:viewMarker>

	<og:tableFilter classId="ROTATE" selectedAll="true" >
	{
		KEY_CLM			: DY_HATU,SET_KEY,SET_GRP ;
		ROTATE_CLM		: TOKEN ;
		ROTATE_LBL		: TKN_NM ;
		VALUE_CLM		: VAL ;
		USE_RENDERER	: true	;
		USE_MARKER		: true	;
	}
	</og:tableFilter>

	<!-- 単位除外の場合、数字項目は、数値ｾﾙとして出力したい -->
	<og:equals val1="{@FG_OMT}" val2="1" >
		<!-- 'TP_INT','TP_REAL' のﾄｰｸﾝ をﾋﾟｯｸｱｯﾌﾟする -->
		<og:value command="SQL" action="ROW_APPEND">
			select B.TOKEN from GG01 B inner join GG02 C
				on  B.TOKEN = C.TOKEN
				and B.DATA_TYPE in ('TP_INT','TP_REAL')
			where C.SET_GRP = '{@SET_GRP}'
			<og:where startKey="and">
				<og:and value = "C.TKN_NM	like '{@TKN_NM}'"	/>
				<og:and value = "C.TKN_GRP	=    '{@TKN_GRP}'"	/>
			</og:where>
		</og:value>

		<!-- DBTYPEを数値に設定。 column="*" でも、行けた -->
		<og:columnEditor columns="{@TOKEN}" dbType="S9" />
	</og:equals>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		writable	= "false"
		loadMarker	= "false"
		command		= "{@command}"
		checked		= "{@checked}"
		startNo		= "{@startNo}"
		pageSize	= "{@pageSize}"
	/>

	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</og:equals>

<!-- 以下は、回転しない場合の処理 -->
<og:columnEditor columns="DY_HATU,TOKEN"	must="true" />
<og:columnEditor column="SET_GRP"			must="true"	/>
<og:columnEditor column="SET_KEY" 			must="true" eventColumn="SET_GRP" />

<og:viewLink command="{@command}">
	<og:link column="DY_HATU" gamenId="GG0100" href="index.jsp" target="CONTENTS"
		keys="command,DY_HATU,SET_KEY,SET_GRP"
		vals="NEW,[DY_HATU],[SET_KEY],[SET_GRP]" />
</og:viewLink>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="JUDG" >
		<div class="judg[!JUDG]">[JUDG]</div>
	</og:columnMarker>
	<og:columnMarker column="VAL" >
		<div class="[!DATA_TYPE]">[VAL]</div>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="COPY"    noWritable="null"		roles="admin" />
		<og:submit  action="MODIFY"  columnWritable="VAL,JUDG,RIYU"  />
		<og:submit  action="DELETE"  columnWritable="null"	roles="admin" />
	</og:writeCheck>

<!-- 判定結果 の凡例と、CSS -->
<pre>　　　　　</pre>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command		= "{@command}"
		noDisplay	= "UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked		= "{@checked}"
		startNo		= "{@startNo}"
		pageSize	= "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
