/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTrees;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import org.opengion.fukurou.taglet.AbstractDocTree;
import org.opengion.fukurou.taglet.DocTreeWriter;

public class DocTreePlugin
extends AbstractDocTree {
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final Map<String, AttKeySet> ATT_KEY_MAP = new HashMap<String, AttKeySet>();
    private String version;
    private String outfile;

    @Override
    public boolean run(DocletEnvironment docletEnvironment) {
        try (DocTreeWriter docTreeWriter = new DocTreeWriter(this.outfile, "UTF-8");){
            docTreeWriter.printTag("<?xml version=\"1.0\" encoding=\"", "UTF-8", "\" ?>");
            docTreeWriter.printTag("<javadoc>");
            docTreeWriter.printTag("  <version>", this.version, "</version>");
            docTreeWriter.printTag("  <description></description>");
            this.writeContents(docletEnvironment, docTreeWriter);
            docTreeWriter.printTag("</javadoc>");
        }
        catch (Throwable throwable) {
            this.reporter.print(Diagnostic.Kind.ERROR, throwable.getMessage());
        }
        return true;
    }

    private void writeContents(DocletEnvironment docletEnvironment, DocTreeWriter docTreeWriter) {
        DocTrees docTrees = docletEnvironment.getDocTrees();
        Elements elements = docletEnvironment.getElementUtils();
        for (TypeElement typeElement : ElementFilter.typesIn(docletEnvironment.getIncludedElements())) {
            Object object;
            if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            String string = String.valueOf(typeElement.getQualifiedName());
            docTreeWriter.setClassName(string);
            AttKeySet attKeySet = DocTreePlugin.getAttGroupName(typeElement, elements);
            if (attKeySet == null) continue;
            int n = string.lastIndexOf(46);
            String string2 = null;
            if (n > 0) {
                object = string.substring(n + 1);
                string2 = attKeySet.getAttKey((String)object);
            }
            if (string2 == null) continue;
            object = docTrees.getDocCommentTree(typeElement);
            List<? extends DocTree> list = object == null ? EMPTY_LIST : object.getFirstSentence();
            List<? extends DocTree> list2 = object == null ? EMPTY_LIST : object.getFullBody();
            Map<String, List<String>> map = this.blockTagsMap((DocCommentTree)object);
            String string3 = this.getBlockTag(OG_FOR_SMPL, map, "");
            docTreeWriter.printTag("<classDoc>");
            docTreeWriter.printTag("  <attClass>", string, "</attClass>");
            docTreeWriter.printTag("  <seq>", attKeySet.getSeq(), "</seq>");
            docTreeWriter.printTag("  <attKey>", string2, "</attKey>");
            docTreeWriter.printTag("  <valueName>", attKeySet.getValueName(), "</valueName>");
            docTreeWriter.printTag("  <description>", list, "</description>");
            docTreeWriter.printTag("  <contents>", list2, "</contents>");
            docTreeWriter.printTag("  <formSample>", string3, "</formSample>");
            docTreeWriter.printTag("</classDoc>");
        }
    }

    private static AttKeySet getAttGroupName(TypeElement typeElement, Elements elements) {
        if (typeElement == null) {
            return null;
        }
        String string = String.valueOf(typeElement);
        AttKeySet attKeySet = ATT_KEY_MAP.get(string);
        if (attKeySet == null) {
            String string2;
            for (TypeElement object2 : elements.getAllTypeElements(string)) {
                if (typeElement.equals(object2) || (attKeySet = DocTreePlugin.getAttGroupName(object2, elements)) == null) continue;
                return attKeySet;
            }
            TypeMirror typeMirror = typeElement.getSuperclass();
            if (typeMirror != null && (attKeySet = ATT_KEY_MAP.get(string2 = String.valueOf(typeMirror))) == null) {
                for (TypeElement typeElement2 : elements.getAllTypeElements(string2)) {
                    if (typeElement.equals(typeElement2) || (attKeySet = DocTreePlugin.getAttGroupName(typeElement2, elements)) == null) continue;
                    return attKeySet;
                }
            }
            if (attKeySet == null) {
                for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
                    String string3 = String.valueOf(typeMirror2);
                    attKeySet = ATT_KEY_MAP.get(string3);
                    if (attKeySet != null) {
                        return attKeySet;
                    }
                    for (TypeElement typeElement3 : elements.getAllTypeElements(string3)) {
                        if (typeElement.equals(typeElement3) || (attKeySet = DocTreePlugin.getAttGroupName(typeElement3, elements)) == null) continue;
                        return attKeySet;
                    }
                }
            }
        }
        return attKeySet;
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] optionArray = new Doclet.Option[]{new AbstractDocTree.AbstractOption(new String[]{"-outfile", "-version"}){

            @Override
            public boolean process(String string, List<String> list) {
                if ("-outfile".equalsIgnoreCase(string)) {
                    DocTreePlugin.this.outfile = list.get(0);
                } else if ("-version".equalsIgnoreCase(string)) {
                    DocTreePlugin.this.version = list.get(0);
                }
                return true;
            }
        }};
        return new HashSet<Doclet.Option>(Arrays.asList(optionArray));
    }

    static {
        int n = 0;
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.Query", new AttKeySet("Query", n++, "queryType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.CellRenderer", new AttKeySet("Renderer", n++, "renderer"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.CellEditor", new AttKeySet("Editor", n++, "editor"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.DBType", new AttKeySet("DBType", n++, "dbType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.TableFilter", new AttKeySet("TableFilter", n++, "tableFilter"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.Selection", new AttKeySet("Selection", n++, "selection"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.DBConstValue", new AttKeySet("DBConstValue", n++, "cnstVal"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.html.ViewForm", new AttKeySet("ViewForm", n++, "viewFormType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.io.TableWriter", new AttKeySet("TableWriter", n++, "writerClass"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.io.TableReader", new AttKeySet("TableReader", n++, "readerClass"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.resource.CalendarQuery", new AttKeySet("CalendarQuery", n++, "calDB"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.resource.CalendarData", new AttKeySet("CalendarData", n++, "calData"));
        ATT_KEY_MAP.put("org.opengion.fukurou.process.HybsProcess", new AttKeySet("Process", n++, "process"));
        ATT_KEY_MAP.put("org.opengion.fukurou.util.HybsTimerTask", new AttKeySet("Daemon", n++, "daemon"));
        ATT_KEY_MAP.put("org.opengion.fukurou.util.ConnectIF\t", new AttKeySet("ConnectIF", n++, "connIF"));
        ATT_KEY_MAP.put("org.opengion.fukurou.xml.JspParserFilter", new AttKeySet("JspCreate", n++, "jspParser"));
    }

    private static final class AttKeySet {
        private final String searchKey;
        private final int len;
        private final String seq;
        private final String valueName;

        AttKeySet(String string, int n, String string2) {
            this.searchKey = string;
            this.seq = String.valueOf(n);
            this.valueName = string2;
            this.len = string.length();
        }

        String getSeq() {
            return this.seq;
        }

        String getValueName() {
            return this.valueName;
        }

        String getAttKey(String string) {
            Object object = null;
            if (string.equals(this.searchKey)) {
                object = "(Interface)" + string;
            } else if (string.indexOf(this.searchKey) == 0 && ((String)(object = string.substring(this.len))).charAt(0) == '_') {
                object = ((String)object).substring(1);
            }
            return object;
        }
    }
}

