/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.plugin.cloud.CloudFileOperation;

public class FileOperationInfo
extends CloudFileOperation {
    private static final String VERSION = "8.0.0.0 (2021/07/31)";
    private static final long serialVersionUID = 800020210731L;
    private final String plugin;
    private long size;
    private long lastTime;
    private boolean isFil;
    private boolean isDir;
    private FileOperation file;

    public FileOperationInfo(String string, String string2, String string3) {
        super(string2, string3);
        this.plugin = string;
        this.size = 0L;
        this.lastTime = 0L;
        this.isFil = false;
        this.isDir = false;
        this.file = null;
    }

    private void setFileOperation() {
        if (this.file == null) {
            this.file = FileOperationFactory.newStorageOperation((String)this.plugin, (String)this.conBucket, (String)this.conPath);
        }
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        this.setFileOperation();
        this.file.write(inputStream);
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        this.setFileOperation();
        return this.file.read();
    }

    @Override
    public boolean delete() {
        this.setFileOperation();
        return this.file.delete();
    }

    @Override
    public boolean copy(String string) {
        this.setFileOperation();
        return this.file.copy(string);
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        this.setFileOperation();
        return this.file.listFiles(fileFilter);
    }

    @Override
    public long length() {
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    @Override
    public long lastModified() {
        return this.lastTime;
    }

    protected void setLastModifiedValue(long l) {
        this.lastTime = l;
    }

    @Override
    public boolean isFile() {
        return this.isFil;
    }

    protected void setFile(boolean bl) {
        this.isFil = bl;
    }

    @Override
    public boolean isDirectory() {
        return this.isDir;
    }

    protected void setDirectory(boolean bl) {
        this.isDir = bl;
    }

    @Override
    public File getParentFile() {
        return FileOperationFactory.copyFile((File)this.file, (String)this.getParent());
    }
}

