/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class FileUpdateTag
extends CommonTagSupport {
    private static final String VERSION = "7.2.9.4 (2020/11/20)";
    private static final long serialVersionUID = 729420201120L;
    public static final String CMD_ENTRY = "ENTRY";
    private static final Set<String> COMMAND_SET = new ArraySet((Object[])new String[]{"ENTRY"});
    private static final String ERR_MSG_ID = "h_errMsg";
    public static final String ACT_COPY = "COPY";
    public static final String ACT_MOVE = "MOVE";
    public static final String ACT_MODIFY = "MODIFY";
    public static final String ACT_DELETE = "DELETE";
    public static final String ACT_MKDIRS = "MKDIRS";
    private static final Set<String> ACTION_SET = new ArraySet((Object[])new String[]{"COPY", "MOVE", "MODIFY", "DELETE", "MKDIRS"});
    private String action;
    private String targetDir;
    private boolean createDir = true;
    private String inPath;
    private String parentClm = "PARENT";
    private String nameClm = "NAME";
    private String toParentClm = "TO_PARENT";
    private String toNameClm = "TO_NAME";
    private String tableId = "h_tblmdl";
    private String command = "ENTRY";
    private String displayMsg = "MSG0040";
    private String actErrMsg = "ERR0050";
    private boolean selectedAll;
    private boolean keepTimeStamp;
    private transient DBTableModel table;
    private transient ErrorMessage errMessage;
    private int executeCount = -1;
    private int errCode = 0;
    private boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    private boolean useSLabel;
    private boolean useStop = true;

    @Override
    public int doEndTag() {
        Object object;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        long l = System.currentTimeMillis();
        this.table = (DBTableModel)this.getObject(this.tableId);
        if (this.table != null && this.table.getRowCount() > 0 && this.check(this.command, COMMAND_SET)) {
            this.startQueryTransaction(this.tableId);
            this.execute();
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            if (!this.commitTableObject(this.tableId, this.table)) {
                if (this.errMessage == null) {
                    this.errMessage = new ErrorMessage("FileUpdateTag Query Error!");
                }
                this.errMessage.addMessage(0, 2, "ERR0041", new String[0]);
                this.errCode = 2;
            }
            if ((object = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource(), this.useSLabel)) != null && ((String)object).length() > 0) {
                this.jspPrint((String)object);
                this.setSessionAttribute(ERR_MSG_ID, this.errMessage);
            }
            if (this.useStop && this.errCode >= 2) {
                return 5;
            }
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            object = this.executeCount + this.getResource().getLabel(this.displayMsg, new String[0]);
            this.jspPrint((String)object + BR);
        }
        if (this.useTimeView) {
            long l2 = System.currentTimeMillis() - l;
            this.jspPrint("<div id=\"queryTime\" value=\"" + l2 + "\"></div>");
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.command = CMD_ENTRY;
        this.action = null;
        this.targetDir = null;
        this.createDir = true;
        this.parentClm = "PARENT";
        this.nameClm = "NAME";
        this.toParentClm = "TO_PARENT";
        this.toNameClm = "TO_NAME";
        this.displayMsg = "MSG0040";
        this.actErrMsg = "ERR0050";
        this.selectedAll = false;
        this.keepTimeStamp = false;
        this.table = null;
        this.errMessage = null;
        this.executeCount = -1;
        this.errCode = 0;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
        this.inPath = null;
        this.useSLabel = false;
        this.useStop = true;
    }

    private void execute() {
        int[] nArray = this.getParameterRows();
        if (nArray.length > 0) {
            String[] stringArray = new String[]{this.parentClm, this.nameClm, this.toParentClm, this.toNameClm};
            FromToFiles fromToFiles = new FromToFiles(this.table, this.targetDir, this.createDir, this.inPath, stringArray);
            if (ACT_COPY.equalsIgnoreCase(this.action)) {
                this.actionCOPY(nArray, fromToFiles);
            } else if (ACT_MOVE.equalsIgnoreCase(this.action) || ACT_MODIFY.equalsIgnoreCase(this.action)) {
                this.actionMOVE(nArray, fromToFiles);
            } else if (ACT_DELETE.equalsIgnoreCase(this.action)) {
                this.actionDELETE(nArray, fromToFiles);
            } else if (ACT_MKDIRS.equalsIgnoreCase(this.action)) {
                this.actionMKDIRS(nArray, fromToFiles);
            }
        }
    }

    private void actionCOPY(int[] nArray, FromToFiles fromToFiles) {
        File file = null;
        File file2 = null;
        this.executeCount = 0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            File[] fileArray = fromToFiles.makeFromToFile(nArray[i]);
            file = fileArray[0];
            file2 = fileArray[1];
            if (file.isFile() && !FileUtil.copy((File)file, (File)file2, (boolean)this.keepTimeStamp)) {
                if (this.errMessage == null) {
                    this.errMessage = new ErrorMessage("FileUpdateTag Error");
                }
                this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, file.toString(), file2.toString()});
                this.errCode = 2;
            }
            ++this.executeCount;
        }
    }

    private void actionMOVE(int[] nArray, FromToFiles fromToFiles) {
        File file = null;
        File file2 = null;
        this.executeCount = 0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            File[] fileArray = fromToFiles.makeFromToFile(nArray[i]);
            file = fileArray[0];
            file2 = fileArray[1];
            if (fromToFiles.lastParentEquals()) {
                if (!file.renameTo(file2)) {
                    if (this.errMessage == null) {
                        this.errMessage = new ErrorMessage("FileUpdateTag Error");
                    }
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, file.toString(), file2.toString()});
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{"\u540c\u4e00\u89aa\u30d5\u30a9\u30eb\u30c0\u306e\u305f\u3081\u3001RENAME\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059\u3002"});
                    this.errCode = 2;
                }
            } else if (file.isFile()) {
                if (!FileUtil.copy((File)file, (File)file2, (boolean)this.keepTimeStamp)) {
                    if (this.errMessage == null) {
                        this.errMessage = new ErrorMessage("FileUpdateTag Error");
                    }
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, file.toString(), file2.toString()});
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{"\u79fb\u52d5\u524d\u306eCOPY\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3057\u305f\u3002"});
                    this.errCode = 2;
                }
                if (!file.delete()) {
                    if (this.errMessage == null) {
                        this.errMessage = new ErrorMessage("FileUpdateTag Error");
                    }
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, file.toString(), file2.toString()});
                    this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{"\u79fb\u52d5\u5f8c\u306e\u30aa\u30ea\u30b8\u30ca\u30eb\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3057\u305f\u3002"});
                    this.errCode = 2;
                    if (!file2.delete()) {
                        this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{"toFile \u3082\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"});
                    }
                }
            }
            ++this.executeCount;
        }
    }

    private void actionDELETE(int[] nArray, FromToFiles fromToFiles) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            File file = fromToFiles.makeFromOnly(nArray[i]);
            try {
                FileUpdateTag.delete(file);
                ++this.executeCount;
                continue;
            }
            catch (Throwable throwable) {
                if (this.errMessage == null) {
                    this.errMessage = new ErrorMessage("FileUpdateTag Error");
                }
                this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, file.toString(), ""});
                this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{throwable.getMessage()});
                this.errCode = 2;
            }
        }
    }

    private static void delete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    FileUpdateTag.delete(file2);
                    continue;
                }
                if (file2.delete()) continue;
                System.err.println("file Delete Error! " + file2);
            }
        }
        if (!file.delete()) {
            System.err.println("inFile Delete Error! " + file);
        }
    }

    private void actionMKDIRS(int[] nArray, FromToFiles fromToFiles) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                fromToFiles.makeToParent(nArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                if (this.errMessage == null) {
                    this.errMessage = new ErrorMessage("FileUpdateTag Error");
                }
                this.errMessage.addMessage(nArray[i] + 1, 2, this.actErrMsg, new String[]{this.action, "", fromToFiles.getLastDir()});
                this.errMessage.addMessage(nArray[i] + 1, 2, this.action, new String[]{throwable.getMessage()});
                this.errCode = 2;
            }
        }
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    public void setAction(String string) {
        this.action = StringUtil.nval((String)this.getRequestParameter(string), (String)this.action);
        if (this.action != null && !this.check(this.action, ACTION_SET)) {
            String string2 = "\u6307\u5b9a\u306e\u30a2\u30af\u30b7\u30e7\u30f3\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\u30a2\u30af\u30b7\u30e7\u30f3\u30a8\u30e9\u30fc" + CR + "action=[" + this.action + "] " + CR + "actionList=" + String.join((CharSequence)", ", ACTION_SET);
            throw new HybsSystemException(string2);
        }
    }

    public void setTargetDir(String string) {
        this.targetDir = StringUtil.nval((String)this.getRequestParameter(string), (String)this.targetDir);
    }

    public void setCreateDir(String string) {
        this.createDir = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.createDir);
    }

    public void setParentClm(String string) {
        this.parentClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.parentClm);
    }

    public void setNameClm(String string) {
        this.nameClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nameClm);
    }

    public void setToParentClm(String string) {
        this.toParentClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.toParentClm);
    }

    public void setToNameClm(String string) {
        this.toNameClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.toNameClm);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setActErrMsg(String string) {
        this.actErrMsg = StringUtil.nval((String)this.getRequestParameter(string), (String)this.actErrMsg);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setKeepTimeStamp(String string) {
        this.keepTimeStamp = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.keepTimeStamp);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    public void setInPath(String string) {
        this.inPath = StringUtil.nval((String)this.getRequestParameter(string), (String)this.inPath);
        if (this.inPath != null) {
            try {
                this.inPath = new File(this.inPath).getCanonicalPath();
            }
            catch (IOException iOException) {
                String string2 = "inPath\u306e\u6b63\u5f0f\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.inPath + "]" + CR + iOException.getMessage();
                throw new HybsSystemException(string2, iOException);
            }
        }
    }

    public void setUseSLabel(String string) {
        this.useSLabel = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSLabel);
    }

    public void setUseStop(String string) {
        this.useStop = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useStop);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("action", (Object)this.action).println("command", (Object)this.command).println("targetDir", (Object)this.targetDir).println("createDir", (Object)this.createDir).println("tableId", (Object)this.tableId).println("displayMsg", (Object)this.displayMsg).println("selectedAll", (Object)this.selectedAll).println("keepTimeStamp", (Object)this.keepTimeStamp).fixForm().toString();
    }

    private static final class FromToFiles {
        private final String fileURL = HybsSystem.sys("FILE_URL");
        private final DBTableModel table;
        private final int PARENT;
        private final int NAME;
        private final int TO_PARENT;
        private final int TO_NAME;
        private final File toDir;
        private final boolean createDir;
        private final int inPathCnt;
        private boolean equalParent;
        private String lastDir;

        public FromToFiles(DBTableModel dBTableModel, String string, boolean bl, String string2, String[] stringArray) {
            this.table = dBTableModel;
            this.createDir = bl;
            this.toDir = this.mkDirs(string, bl);
            this.inPathCnt = string2 == null ? 0 : string2.length();
            this.PARENT = dBTableModel.getColumnNo(stringArray[0], false);
            this.NAME = dBTableModel.getColumnNo(stringArray[1], false);
            this.TO_PARENT = dBTableModel.getColumnNo(stringArray[2], false);
            this.TO_NAME = dBTableModel.getColumnNo(stringArray[3], false);
        }

        public File makeFromOnly(int n) {
            String[] stringArray = (String[])this.table.getValues(n);
            File file = this.mkDirs(stringArray[this.PARENT], this.createDir);
            return HybsFileOperationFactory.create(file, stringArray[this.NAME]);
        }

        public File makeToParent(int n) {
            File file;
            if (this.TO_PARENT >= 0) {
                String[] stringArray = (String[])this.table.getValues(n);
                file = this.mkDirs(stringArray[this.TO_PARENT], true);
            } else {
                file = null;
            }
            return file;
        }

        public File[] makeFromToFile(int n) {
            Object object;
            String[] stringArray = (String[])this.table.getValues(n);
            File file = this.mkDirs(stringArray[this.PARENT], this.createDir);
            FileOperation fileOperation = HybsFileOperationFactory.create(file, stringArray[this.NAME]);
            File file2 = this.toDir;
            this.equalParent = false;
            if (file2 == null) {
                if (this.TO_PARENT >= 0 && StringUtil.nval((String)stringArray[this.TO_PARENT], null) != null) {
                    file2 = this.mkDirs(stringArray[this.TO_PARENT], this.createDir);
                } else {
                    file2 = file;
                    this.equalParent = true;
                }
            } else if (this.inPathCnt > 0) {
                if (this.TO_PARENT >= 0 && StringUtil.nval((String)stringArray[this.TO_PARENT], null) != null) {
                    if (stringArray[this.TO_PARENT].length() > this.inPathCnt) {
                        object = this.toDir.getAbsolutePath() + stringArray[this.TO_PARENT].substring(this.inPathCnt);
                        file2 = this.mkDirs((String)object, this.createDir);
                    }
                } else if (stringArray[this.PARENT].length() > this.inPathCnt) {
                    object = this.toDir.getAbsolutePath() + stringArray[this.PARENT].substring(this.inPathCnt);
                    file2 = this.mkDirs((String)object, this.createDir);
                }
            }
            object = null;
            object = this.TO_NAME >= 0 && StringUtil.nval((String)stringArray[this.TO_NAME], null) != null ? HybsFileOperationFactory.create(file2, stringArray[this.TO_NAME]) : HybsFileOperationFactory.create(file2, stringArray[this.TO_NAME]);
            return new File[]{fileOperation, object};
        }

        public boolean lastParentEquals() {
            return this.equalParent;
        }

        public String getLastDir() {
            return this.lastDir;
        }

        private File mkDirs(String string, boolean bl) {
            this.lastDir = string;
            File file = null;
            if (string != null) {
                try {
                    String string2 = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string});
                    file = new File(HybsSystem.url2dir(string2)).getCanonicalFile();
                    file = HybsFileOperationFactory.create(file.getPath());
                    if (file.exists()) {
                        if (file.isFile()) {
                            String string3 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u306b\u3001\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + CommonTagSupport.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string2 + "]" + CommonTagSupport.CR;
                            throw new HybsSystemException(string3);
                        }
                    } else {
                        if (!bl) {
                            String string4 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002 " + CommonTagSupport.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string2 + "]" + CommonTagSupport.CR;
                            throw new HybsSystemException(string4);
                        }
                        if (!file.mkdirs()) {
                            String string5 = "\u30bf\u30fc\u30b2\u30c3\u30c8\u3092\u81ea\u52d5\u4f5c\u6210\u4f7f\u7528\u3068\u3057\u307e\u3057\u305f\u304c\u3001\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CommonTagSupport.CR + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string2 + "]" + CommonTagSupport.CR;
                            throw new HybsSystemException(string5);
                        }
                    }
                }
                catch (IOException iOException) {
                    String string6 = "File#getCanonicalFile() \u3067\u3001\u6b63\u5f0f\u30d1\u30b9\u540d\u3092\u6c42\u3081\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CommonTagSupport.CR + iOException.getMessage() + "\u30bf\u30fc\u30b2\u30c3\u30c8=[" + string + "]" + CommonTagSupport.CR;
                    throw new HybsSystemException(string6, iOException);
                }
            }
            return file;
        }
    }
}

