/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;

public class HttpConnect {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_LANG = "ja-JP";
    public static final String DEFAULT_AGENT = "openGion with Apache HttpClient";
    public static final int MAX_GET_LENGTH = 2000;
    private final String urlStr;
    private final String user;
    private final String pass;
    private final Map<String, String> jsonMap = new HashMap<String, String>();
    private int rpsCode = -1;
    private String rpsMessage;
    private String charset = "UTF-8";
    private String upldFile;
    private String dwldFile;
    private int timeout = -1;
    private boolean isPost;
    private boolean postRedirect;
    private boolean isDebug;
    private String authJson;
    private String authURL;
    private String reqJson;
    private HttpHost proxy;
    private static final List<Header> INIT_HEADER = Arrays.asList(new BasicHeader("Accept-Charset", (Object)"UTF-8"), new BasicHeader("Accept-Language", (Object)"ja-JP"), new BasicHeader("User-Agent", (Object)"openGion with Apache HttpClient"));
    private final List<NameValuePair> reqParamList = new ArrayList<NameValuePair>();
    private final List<Header> headers = new ArrayList<Header>(INIT_HEADER);
    private final StringBuilder reqParamBuf = new StringBuilder(200);

    public HttpConnect(String string, String string2) {
        this.urlStr = StringUtil.urlEncode2(string);
        if (StringUtil.isNull(string2)) {
            this.user = null;
            this.pass = null;
        } else {
            String[] stringArray = StringUtil.csv2Array(string2, ':', 2);
            this.user = stringArray[0];
            this.pass = stringArray[1];
        }
    }

    private String formLogin(CloseableHttpClient closeableHttpClient, URI uRI) {
        String string = null;
        try {
            URI uRI2 = uRI.resolve("j_security_check");
            if (this.isDebug) {
                System.out.println("security URI=" + uRI2);
            }
            ClassicHttpRequest classicHttpRequest = ClassicRequestBuilder.post().setUri(uRI2).addParameter("j_username", this.user).addParameter("j_password", this.pass).addParameter("j_security_check", "login").build();
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(classicHttpRequest);){
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                this.rpsCode = closeableHttpResponse.getCode();
                this.rpsMessage = HttpConnect.code2Message(this.rpsCode).trim();
                if (!StringUtil.isNull(this.dwldFile) && this.rpsCode >= 200 && this.rpsCode < 300) {
                    Files.write(Paths.get(this.dwldFile, new String[0]), EntityUtils.toByteArray((HttpEntity)httpEntity), new OpenOption[0]);
                    string = this.dwldFile;
                } else {
                    string = EntityUtils.toString((HttpEntity)httpEntity, (String)this.charset);
                }
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        catch (IOException | ParseException throwable) {
            throw new OgRuntimeException(throwable);
        }
        return string;
    }

    private String jsonLogin(CloseableHttpClient closeableHttpClient) {
        String string = null;
        try {
            HttpPost httpPost = new HttpPost(this.authURL);
            httpPost.setHeader("Content-type", (Object)"application/json");
            StringEntity stringEntity = new StringEntity(this.authJson, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpPost);){
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                this.rpsCode = closeableHttpResponse.getCode();
                this.rpsMessage = HttpConnect.code2Message(this.rpsCode).trim();
                if (this.isDebug) {
                    System.out.println("jsonLogin=" + this.rpsCode);
                }
                string = EntityUtils.toString((HttpEntity)httpEntity, (String)this.charset);
                if (this.isDebug) {
                    System.out.println("Login=" + string);
                }
                if (!this.jsonMap.isEmpty()) {
                    for (String string2 : this.jsonMap.keySet()) {
                        int n = string.indexOf(string2);
                        if (n < 0) continue;
                        int n2 = string.indexOf(44, n + string2.length());
                        StringBuilder stringBuilder = new StringBuilder();
                        if (n2 > 0) {
                            for (int i = n + string2.length(); i < n2; ++i) {
                                char c = string.charAt(i);
                                if (c == '\"' || c == ':' || c == ' ') continue;
                                stringBuilder.append(c);
                            }
                        }
                        this.jsonMap.put(string2, stringBuilder.toString());
                        if (!this.isDebug) continue;
                        System.out.println("Map=" + string2 + ":" + stringBuilder.toString());
                    }
                }
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        catch (IOException | ParseException throwable) {
            throw new OgRuntimeException(throwable);
        }
        return string;
    }

    private String jsonDataget(CloseableHttpClient closeableHttpClient, URI uRI) {
        String string = null;
        try {
            Object object;
            Object object2;
            HttpGet httpGet;
            if (this.reqJson == null) {
                httpGet = new HttpGet(uRI);
            } else {
                httpGet = new HttpPost(uRI);
                httpGet.setHeader("Content-type", (Object)"application/json");
                object2 = this.reqJson;
                if (!this.jsonMap.isEmpty()) {
                    for (Map.Entry entry : this.jsonMap.entrySet()) {
                        object2 = ((String)object2).replace("$" + (String)entry.getKey() + "$", (CharSequence)entry.getValue());
                    }
                }
                if (this.isDebug) {
                    System.out.println("reqJson=" + (String)object2);
                }
                object = new StringEntity((String)object2, ContentType.APPLICATION_JSON);
                httpGet.setEntity((HttpEntity)object);
            }
            object2 = closeableHttpClient.execute((ClassicHttpRequest)httpGet);
            try {
                object = object2.getEntity();
                this.rpsCode = object2.getCode();
                this.rpsMessage = HttpConnect.code2Message(this.rpsCode).trim();
                if (this.isDebug) {
                    System.out.println("jsonDataget=" + this.rpsCode);
                }
                string = EntityUtils.toString((HttpEntity)object, (String)this.charset);
                EntityUtils.consume((HttpEntity)object);
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        catch (IOException | ParseException throwable) {
            throw new OgRuntimeException(throwable);
        }
        return string;
    }

    public String readData() throws IOException, MalformedURLException {
        Object object;
        Object object2;
        HttpPost httpPost;
        if (this.isPost) {
            if (this.isDebug) {
                System.out.println("POST URL=" + this.urlStr);
            }
            httpPost = new HttpPost(this.urlStr);
            if (!this.reqParamList.isEmpty()) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.reqParamList));
                if (this.isDebug) {
                    this.reqParamList.forEach(nameValuePair -> System.out.println("PARAM KEY=" + nameValuePair.getName() + " , VAL=" + nameValuePair.getValue()));
                }
            }
            if (!StringUtil.isNull(this.upldFile)) {
                object2 = new File(this.upldFile);
                if (this.isDebug) {
                    System.out.println("  MULTI FILE=" + (File)object2);
                }
                object = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).addBinaryBody("upload", (File)object2, ContentType.DEFAULT_BINARY, ((File)object2).getName()).build();
                httpPost.setEntity((HttpEntity)object);
            }
        } else {
            Object object3 = object2 = this.reqParamBuf.length() == 0 ? this.urlStr : this.reqParamBuf.toString();
            if (this.isDebug) {
                System.out.println("GET URL=" + (String)object2);
            }
            httpPost = new HttpGet((String)object2);
        }
        object2 = HttpClientContext.create();
        object = null;
        try (CloseableHttpClient closeableHttpClient = this.getClient();
             CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((ClassicHttpRequest)httpPost, (HttpContext)object2);){
            this.rpsCode = closeableHttpResponse.getCode();
            if (this.isDebug) {
                System.out.println("readData=" + this.rpsCode);
            }
            this.rpsMessage = HttpConnect.code2Message(this.rpsCode).trim();
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity == null) {
                object = this.rpsMessage;
            } else {
                URI uRI = httpPost.getUri();
                if (!StringUtil.isNull(this.dwldFile) && this.rpsCode >= 200 && this.rpsCode < 300) {
                    byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
                    String string = new String(byArray, this.charset);
                    if (string.contains("j_security_check")) {
                        object = this.formLogin(closeableHttpClient, uRI);
                    } else {
                        Files.write(Paths.get(this.dwldFile, new String[0]), byArray, new OpenOption[0]);
                        object = this.dwldFile;
                    }
                } else {
                    object = EntityUtils.toString((HttpEntity)httpEntity, (String)this.charset);
                    if (((String)object).contains("j_security_check")) {
                        object = this.formLogin(closeableHttpClient, uRI);
                    } else if (this.authJson != null) {
                        object = this.jsonLogin(closeableHttpClient);
                        object = this.jsonDataget(closeableHttpClient, uRI);
                    }
                }
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (URISyntaxException | ParseException throwable) {
            throw new OgRuntimeException(throwable);
        }
        return object;
    }

    private CloseableHttpClient getClient() throws MalformedURLException {
        Object object;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        BasicCookieStore basicCookieStore = new BasicCookieStore();
        httpClientBuilder.setDefaultCookieStore((CookieStore)basicCookieStore);
        if (this.timeout >= 0) {
            object = RequestConfig.custom();
            object.setConnectTimeout((long)this.timeout, TimeUnit.SECONDS);
            httpClientBuilder.setDefaultRequestConfig(object.build());
        }
        if (!this.headers.isEmpty()) {
            httpClientBuilder.setDefaultHeaders(this.headers);
        }
        if (this.proxy != null) {
            httpClientBuilder.setProxy(this.proxy);
        }
        if (!StringUtil.isNull(this.user)) {
            object = new URL(this.urlStr);
            AuthScope authScope = new AuthScope(((URL)object).getHost(), ((URL)object).getPort());
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.user, this.pass.toCharArray());
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        return httpClientBuilder.build();
    }

    public void addRequestProperty(String string, String string2) {
        if (!StringUtil.isNull(string)) {
            this.reqParamList.add((NameValuePair)new BasicNameValuePair(string, string2));
            if (!this.isPost) {
                if (this.reqParamBuf.length() == 0) {
                    this.reqParamBuf.append(this.urlStr).append(this.urlStr.indexOf(63) > 0 ? (char)'&' : '?').append(StringUtil.urlEncode2(string)).append('=').append(StringUtil.urlEncode2(string2));
                } else if (this.reqParamBuf.length() > 2000) {
                    if (this.isDebug) {
                        System.out.println("GET \u2192 POST\u5909\u66f4\uff1a URL\u306e\u9577\u3055\u5236\u9650\uff1c" + this.reqParamBuf.length());
                    }
                    this.isPost = true;
                } else {
                    this.reqParamBuf.append('&').append(StringUtil.urlEncode2(string)).append('=').append(StringUtil.urlEncode2(string2));
                }
            }
        }
    }

    public void setRequestProperty(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = StringUtil.csv2Array(string);
            if (stringArray2.length == (stringArray = StringUtil.csv2Array(string2)).length && stringArray2.length > 0) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.addRequestProperty(stringArray2[i], stringArray[i]);
                }
            } else {
                String string3 = "\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30ad\u30fc\u3068\u3001\u5024\u306e\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002" + HybsConst.CR + " key=[" + string + "]" + HybsConst.CR + " val=[" + string2 + "]";
                throw new IllegalArgumentException(string3);
            }
        }
    }

    public void setProxy(String string, int n) {
        if (!StringUtil.isNull(string)) {
            this.proxy = new HttpHost(string, n);
        }
    }

    public void addHeaderProperty(String string, String string2) {
        if (!StringUtil.isNull(string) && !StringUtil.isNull(string2)) {
            this.headers.add((Header)new BasicHeader(string, (Object)string2));
        }
    }

    public void setDownloadFile(String string) throws IOException {
        this.dwldFile = string;
    }

    public void setUploadFile(String string) throws IOException {
        if (string != null) {
            this.upldFile = string;
            this.isPost = true;
        }
    }

    public void setCharset(String string) {
        if (!StringUtil.isNull(string)) {
            this.charset = string;
        }
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void usePost(boolean bl) {
        this.isPost = bl;
    }

    public void setAuthJson(String string, String string2) {
        if (string != null && string2 != null) {
            this.authJson = string;
            this.authURL = string2;
        }
    }

    public void setReqJson(String string) {
        if (string == null) {
            return;
        }
        this.reqJson = string;
        int n = this.reqJson.indexOf(36);
        while (n >= 0) {
            int n2 = this.reqJson.indexOf(36, n + 1);
            if (n2 > 0) {
                this.jsonMap.put(this.reqJson.substring(n + 1, n2), "");
            }
            n = this.reqJson.indexOf(36, n2 + 1);
        }
    }

    public void setPostRedirect(boolean bl) {
        this.postRedirect = bl;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    public int getCode() {
        return this.rpsCode;
    }

    public String getMessage() {
        return this.rpsMessage;
    }

    public static String code2Message(int n) {
        return switch (n) {
            case 100 -> "100: \u8981\u6c42\u306f\u7d9a\u884c\u53ef\u80fd\u3067\u3059\u3002";
            case 101 -> "101: \u30d7\u30ed\u30c8\u30b3\u30eb\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
            case 200 -> "200: OK \u3067\u3059\u3002";
            case 201 -> "201: \u4f5c\u6210\u3055\u308c\u307e\u3057\u305f\u3002";
            case 202 -> "202: \u53d7\u3051\u5165\u308c\u3089\u308c\u307e\u3057\u305f\u3002";
            case 203 -> "203: \u4fe1\u983c\u3067\u304d\u306a\u3044\u60c5\u5831\u3067\u3059\u3002";
            case 204 -> "204: \u30b3\u30f3\u30c6\u30f3\u30c4\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
            case 205 -> "205: \u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30ea\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002";
            case 206 -> "206: \u90e8\u5206\u7684\u306a\u30b3\u30f3\u30c6\u30f3\u30c4\u3067\u3059\u3002";
            case 300 -> "300: \u8907\u6570\u306e\u9078\u629e\u80a2\u304c\u3042\u308a\u307e\u3059\u3002";
            case 301 -> "301: \u6c38\u7d9a\u7684\u306b\u79fb\u52d5\u3055\u308c\u307e\u3057\u305f\u3002";
            case 302 -> "302: \u4e00\u6642\u7684\u306a\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u3002";
            case 303 -> "303: \u307b\u304b\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            case 304 -> "304: \u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            case 305 -> "305: \u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002";
            case 306 -> "306: \u4ed5\u69d8\u306e\u62e1\u5f35\u6848\u3067\u3059\u3002";
            case 307 -> "307: \u4e00\u6642\u7684\u306a\u30ea\u30c0\u30a4\u30ec\u30af\u30c8\u3067\u3059\u3002";
            case 400 -> "400: \u4e0d\u5f53\u306a\u8981\u6c42\u3067\u3059\u3002";
            case 401 -> "401: \u8a8d\u8a3c\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            case 402 -> "402: \u652f\u6255\u3044\u304c\u5fc5\u8981\u3067\u3059\u3002";
            case 403 -> "403: \u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            case 404 -> "404: \u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            case 405 -> "405: \u30e1\u30bd\u30c3\u30c9\u306f\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002";
            case 406 -> "406: \u53d7\u3051\u5165\u308c\u3089\u308c\u307e\u305b\u3093\u3002";
            case 407 -> "407: \u30d7\u30ed\u30ad\u30b7\u306e\u8a8d\u8a3c\u304c\u5fc5\u8981\u3067\u3059\u3002";
            case 408 -> "408: \u8981\u6c42\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002";
            case 409 -> "409: \u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002";
            case 410 -> "410: \u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
            case 411 -> "411: \u9577\u3055\u304c\u5fc5\u8981\u3067\u3059\u3002";
            case 412 -> "412: \u524d\u63d0\u6761\u4ef6\u304c\u6e80\u305f\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            case 413 -> "413: \u8981\u6c42\u306e\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002";
            case 414 -> "414: \u8981\u6c42\u306eURI\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002";
            case 415 -> "415: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7\u3067\u3059\u3002";
            case 416 -> "416: \u8981\u6c42\u3055\u308c\u305f\u7bc4\u56f2\u306f\u4e0d\u5341\u5206\u3067\u3059\u3002";
            case 417 -> "417: \u8981\u6c42\u3069\u304a\u308a\u306e\u51e6\u7406\u304c\u4e0d\u53ef\u80fd\u3067\u3059\u3002";
            case 500 -> "500: \u5185\u90e8\u30b5\u30fc\u30d0\u30a8\u30e9\u30fc\u3067\u3059\u3002";
            case 501 -> "501: \u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            case 502 -> "502: \u8aa4\u3063\u305f\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u3067\u3059\u3002";
            case 503 -> "503: \u30b5\u30fc\u30d3\u30b9\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
            case 504 -> "504: \u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002";
            case 505 -> "505: \u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044HTTP\u30d0\u30fc\u30b8\u30e7\u30f3\u3067\u3059\u3002";
            default -> n + ": \u672a\u5b9a\u7fa9";
        };
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        if (stringArray.length < 2) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.HttpConnect [-data/-binary] \u2026 url");
            LogWriter.log("   args[A] : url                     URL\u3092\u6307\u5b9a\u3057\u307e\u3059\uff61GET\u306e\u5834\u5408\uff64\uff8a\uff9f\uff97\uff92\uff70\uff80\u306f ?KEY=VAL\u3067\u3059");
            LogWriter.log("   args[*] : [-param=key:value]      POST/GET\u6642\u306e\uff8a\uff9f\uff97\uff92\uff70\uff80\u306e\uff77\uff70\u3068\u5024\u3092:\u3067\u533a\u5207\u3063\u3066\u6307\u5b9a\u3057\u307e\u3059\uff61(\u8907\u6570\u56de\u6307\u5b9a\u53ef)");
            LogWriter.log("   args[*] : [-header=key:value]     \uff8d\uff6f\uff80\uff9e\uff70\u306b\u8a2d\u5b9a\u3059\u308b\uff8a\uff9f\uff97\uff92\uff70\uff80\u306e\uff77\uff70\u3068\u5024\u3092:\u3067\u533a\u5207\u3063\u3066\u6307\u5b9a\u3057\u307e\u3059\uff61(\u8907\u6570\u56de\u6307\u5b9a\u53ef)");
            LogWriter.log("   args[*] : [-auth=user:pass]       BASIC\u8a8d\u8a3c/FORM\u8a8d\u8a3c\u306e\uff74\uff98\uff71\u3078\u306e\uff71\uff78\uff7e\uff7d\u6642\u306e\uff95\uff70\uff7b\uff9e\uff70\u3068\uff8a\uff9f\uff7d\uff9c\uff70\uff84\uff9e\u3092\u6307\u5b9a\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-proxy=host:port]      proxy \u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u306e\uff8e\uff7d\uff84\u3068\uff8e\uff9f\uff70\uff84\u3092\u6307\u5b9a\u3057\u307e\u3059\uff61");
            LogWriter.log("   args[*] : [-timeout=3]            \u63a5\u7d9a\uff80\uff72\uff91\uff71\uff73\uff84\u6642\u9593\u3092(\u79d2)\u3067\u6307\u5b9a\u3057\u307e\u3059(\u521d\u671f\u5024:\u7121\u6307\u5b9a)");
            LogWriter.log("   args[*] : [-encode=UTF-8]         \uff74\uff9d\uff7a\uff70\uff84\uff9e\u3092\u6307\u5b9a\u3057\u307e\u3059\uff61(\u521d\u671f\u5024\u306f UTF-8)");
            LogWriter.log("   args[*] : [-out=\uff8c\uff67\uff72\uff99\u540d]           \u7d50\u679c\u3092\uff8c\uff67\uff72\uff99\u306b\u51fa\u529b\u3057\u307e\u3059\uff61\u521d\u671f\u5024\u306f\u6a19\u6e96\u51fa\u529b\u3067\u3059");
            LogWriter.log("   args[*] : [-download=\uff8c\uff67\uff72\uff99\u540d]      \uff8c\uff67\uff72\uff99\u540d\u3092\u6307\u5b9a\u3057\u3066\uff64\uff80\uff9e\uff73\uff9d\uff9b\uff70\uff84\uff9e\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-upload=\uff8c\uff67\uff72\uff99\u540d]        \uff8c\uff67\uff72\uff99\u540d\u3092\u6307\u5b9a\u3057\u3066\uff64multipart/form-data\u3067\uff8c\uff67\uff72\uff99\uff71\uff6f\uff8c\uff9f\uff9b\uff70\uff84\uff9e\u3057\u307e\u3059");
            LogWriter.log("   args[*] : [-postRedirect=true]    POST\u6642\u306b\u5f37\u5236\u7684\u306b\uff98\uff80\uff9e\uff72\uff9a\uff78\uff84\u3092\u884c\u3044\u307e\u3059(GET\u6642\u306f\u81ea\u52d5\u3067\uff98\uff80\uff9e\uff72\uff9a\uff78\uff84\u3057\u307e\u3059)(\u521d\u671f\u5024:false)");
            LogWriter.log("   args[*] : [-usePost=true]         POST\u3092\u5f37\u5236\u7684\u306b\u4f7f\u7528\u3059\u308b\u5834\u5408\u306b\uff7e\uff6f\uff84\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
            LogWriter.log("   args[*] : [-errEx=true/false]     true\u306e\u5834\u5408\uff64\uff9a\uff7d\uff8e\uff9f\uff9d\uff7d\uff7a\uff70\uff84\uff9e\u304c\uff644XX,5XX \u306e\u6642\u306b RuntimeException \u3092\u6295\u3052\u307e\u3059(\u521d\u671f\u5024:false)");
            LogWriter.log("   args[*] : [-authJson=JSON\u30b3\u30fc\u30c9]  JSON\u30b3\u30fc\u30c9\u3067\u8a8d\u8a3c\u3059\u308b\u5834\u5408\u306b\u4f7f\u7528\u3057\u307e\u3059\u30028.0.0.0 (2021/08/31)");
            LogWriter.log("   args[*] : [-authURL=\u8a8d\u8a3c\u7528URL]    JSON\u30b3\u30fc\u30c9\u3067\u8a8d\u8a3c\u3059\u308bURL\u3092\u6307\u5b9a\u3057\u307e\u3059\u30028.0.0.0 (2021/08/31)");
            LogWriter.log("   args[*] : [#\uff65\uff65\uff65\uff65]                 \uff7a\uff92\uff9d\uff84\u5f15\u6570\uff61(BAT\uff8c\uff67\uff72\uff99\u4e0a\u306b\u6b8b\u3057\u3066\u304a\u304d\u305f\u3044\u304c\uff64\u4f7f\u7528\u3057\u305f\u304f\u306a\u3044\u5834\u5408\u306a\u3069)");
            LogWriter.log("   args[*] : [-debug=true/false]     true\u306e\u5834\u5408\uff64\u9069\u5ea6\u306b\uff83\uff9e\uff8a\uff9e\uff6f\uff78\uff9e\u7528\u306e\uff92\uff6f\uff7e\uff70\uff7c\uff9e\u3092\u51fa\u529b\u3057\u307e\u3059(\u521d\u671f\u5024:false)");
            return;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        int n = -1;
        String string4 = DEFAULT_CHARSET;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        for (String string11 : stringArray) {
            if (string11.startsWith("-param=")) {
                object = StringUtil.csv2Array(string11.substring("-param=".length()), '=', 2);
                arrayList.add(object[0]);
                arrayList2.add(object[1]);
                continue;
            }
            if (string11.startsWith("-header=")) {
                object = StringUtil.csv2Array(string11.substring("-header=".length()), '=', 2);
                arrayList3.add(object[0]);
                arrayList4.add(object[1]);
                continue;
            }
            if (string11.startsWith("-auth=")) {
                string2 = string11.substring("-auth=".length());
                if (!StringUtil.isNull(string2)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-proxy=")) {
                string3 = string11.substring("-proxy=".length());
                if (!StringUtil.isNull(string3)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-timeout=")) {
                n = Integer.parseInt(string11.substring("-timeout=".length()));
                continue;
            }
            if (string11.startsWith("-encode=")) {
                string4 = string11.substring("-encode=".length());
                if (!StringUtil.isNull(string4)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-out=")) {
                string5 = string11.substring("-out=".length());
                if (StringUtil.isNull(string5)) {
                    System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    continue;
                }
                if (!"null".equalsIgnoreCase(string5) && !"none".equalsIgnoreCase(string5)) continue;
                string5 = null;
                bl4 = true;
                continue;
            }
            if (string11.startsWith("-download=")) {
                string6 = string11.substring("-download=".length());
                if (!StringUtil.isNull(string6)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-upload=")) {
                string7 = string11.substring("-upload=".length());
                if (!StringUtil.isNull(string7)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-errEx=")) {
                bl = "true".equalsIgnoreCase(string11.substring("-errEx=".length()));
                continue;
            }
            if (string11.startsWith("-postRedirect=")) {
                bl3 = "true".equalsIgnoreCase(string11.substring("-postRedirect=".length()));
                continue;
            }
            if (string11.startsWith("-debug=")) {
                bl2 = "true".equalsIgnoreCase(string11.substring("-debug=".length()));
                continue;
            }
            if (string11.startsWith("-usePost=")) {
                bl5 = "true".equalsIgnoreCase(string11.substring("-usePost=".length()));
                continue;
            }
            if (string11.startsWith("-authJson=")) {
                string8 = string11.substring("-authJson=".length());
                if (!StringUtil.isNull(string8)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-authURL=")) {
                string9 = string11.substring("-authURL=".length());
                if (!StringUtil.isNull(string9)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (string11.startsWith("-reqJson=")) {
                string10 = string11.substring("-reqJson=".length());
                if (!StringUtil.isNull(string10)) continue;
                System.err.println(string11 + "\u6307\u5b9a\u3057\u305f\u5834\u5408\u306f\u3001\u5f15\u6570\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                continue;
            }
            if (StringUtil.startsChar(string11, '-')) {
                System.err.println("Error Argment:" + string11);
                continue;
            }
            if (StringUtil.startsChar(string11, '#')) continue;
            string = string11;
        }
        try {
            int n2;
            HttpConnect httpConnect = new HttpConnect(string, string2);
            httpConnect.usePost(bl5);
            httpConnect.setDebug(bl2);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                httpConnect.addRequestProperty((String)arrayList.get(n2), (String)arrayList2.get(n2));
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                httpConnect.addHeaderProperty((String)arrayList3.get(n2), (String)arrayList4.get(n2));
            }
            if (!StringUtil.isNull(string3)) {
                String[] stringArray2 = StringUtil.csv2Array(string3, ':', 2);
                String string12 = stringArray2[0];
                int n3 = Integer.parseInt(stringArray2[1]);
                httpConnect.setProxy(string12, n3);
            }
            httpConnect.setCharset(string4);
            httpConnect.setTimeout(n);
            httpConnect.setUploadFile(string7);
            httpConnect.setDownloadFile(string6);
            httpConnect.setPostRedirect(bl3);
            httpConnect.setAuthJson(string8, string9);
            httpConnect.setReqJson(string10);
            String string13 = httpConnect.readData();
            try (PrintWriter printWriter = StringUtil.isNull(string5) ? FileUtil.getLogWriter("System.out") : FileUtil.getPrintWriter(new File(string5), string4);){
                int n4;
                if (!bl4) {
                    printWriter.println(string13);
                }
                if ((n4 = httpConnect.getCode()) >= 400) {
                    object = httpConnect.getMessage();
                    printWriter.println((String)object);
                    if (bl) {
                        throw new OgRuntimeException((String)object);
                    }
                    System.exit(n4);
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
        }
    }
}

