<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0016"
	title	= "ユーザー永続化情報"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command	= "{@command}"
	columns	= "SYSTEM_ID,USERID,ROLES,PARAM_ID,PARAM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select '1' as WRITABLE,USERID,PARAM_ID,PARAM,KBSET,
				ROLES,'' as POP1,SYSTEM_ID,FGJ,UNIQ
		from GE20
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "USERID		like '{@USERID}'"	/>
		<og:and value = "ROLES		like '{@ROLES}'"	/>
		<og:and value = "PARAM_ID	like '{@PARAM_ID}'"	/>
		<og:and value = "PARAM		like '{@PARAM}'"	/>
		<og:and value = "KBSET		=	'{@KBSET}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,USERID,ROLES,PARAM_ID" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,USERID,ROLES,PARAM_ID" must="true" />
<og:columnEditor columns="POP1"		label="" />	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->

<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
<og:value command="SET" key="param1" >
select ROLES,NMROLE from GEA05 where SYSTEM_ID=\'{@SYSTEM_ID}\' and FGJ=\'1\'
</og:value>

<og:viewMarker isRenderer="false"  command="NEW">
	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
	<og:columnMarker column="ROLES" />
	<og:popup column="POP1" href="{@SYS.JSP}/custom/multiChoose.jsp" rtnKeys="ROLES"
			keys="name,SYSTEM_ID,editor,toVals,param"
			vals='ROLES,{@SYSTEM_ID},DBMENU,"[ROLES].value","{@param1}"'
			height="250px" width="520px" src="{@SYS.JSP_IMG}/multiChoose.gif" />
</og:viewMarker>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2" />
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,USERID,ROLES,PARAM_ID" />
	<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
	<og:submit  action="DELETE"  columnWritable="null" lbl="DELETE_PH" roles="DEL"/>

	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GE20" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:column  name="USERID" useRequestValue="false" td="no" />
			<og:submit  action="COPY" lbl="SYS{@LBL.COPY}" keys="sysins" vals="true" />
		</fieldset>
	</og:equals>
	<br />
</og:writeCheck>

<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "UNIQ"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
