<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "REP03"
	title	= "レイアウトテーブル"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。 -->
<og:columnCheck command="{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 帳票ID全項目検索チェック有り -->
<og:value command="SQL" action="ROW_APPEND" caseIf="{@CHLST}" separator="','" >
	SELECT	DISTINCT LISTID AS LISTALL
	FROM	GE52 A LEFT OUTER JOIN GEA03 B
				ON		B.SYSTEM_ID	=	A.SYSTEM_ID
				AND		A.CLM		=	B.CLM
				AND		B.FGJ		=	'1'
	<og:where>
		<og:and value = "A.SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
		<og:and value = "A.LISTID		LIKE '{@LISTID}'"	/>
		<og:and value = "A.KBTEXT		= '{@KBTEXT}'"		/>
		<og:and value = "A.CLM			LIKE '{@CLM}'"		/>
		<og:and value = "A.FGUSE		= '{@FGUSE}'"		/>
		<og:and value = "B.NAME_JA		LIKE '{@NAME_JA}'"	/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
</og:value>
<!-- 対象データがないときの退避 -->
<og:value key="LISTALL" value=" " caseIf="{@CHLST}" caseNull="{@LISTALL}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" quotCheck="false" >
	SELECT	A.LISTID,A.KBTEXT,A.CLM,B.NAME_JA,A.SEQ,A.START_POS,A.USE_LENGTH,A.FGUSE,A.SYSTEM_ID,
			A.RDC_CODE,A.RELEASE_NOTES,A.FGJ,A.DYSET,A.DYUPD,A.USRSET,A.USRUPD,A.PGUPD,
			B.SYSTEM_ID AS SYSID
	FROM	GE52 A LEFT OUTER JOIN GEA03 B
				ON		B.SYSTEM_ID	=	A.SYSTEM_ID
				AND		A.CLM		=	B.CLM
				AND		B.FGJ		=	'1'
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "A.SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
		<og:and value = "A.LISTID		LIKE '{@LISTID}'"	/>
		<og:and value = "A.LISTID		IN ( '{@LISTALL}' )" quotCheck="false"	/>
		<og:and value = "A.KBTEXT		= '{@KBTEXT}'"		/>
		<!-- 帳票ID全項目検索チェック無し -->
		<og:equals val1="{@CHLST}" nullCheck="true" >
			<!-- 順を振り直すブレイクキーではない項目 -->
			<og:and value = "A.CLM			LIKE '{@CLM}'"		/>
			<og:and value = "A.FGUSE		= '{@FGUSE}'"		/>
			<og:and value = "B.NAME_JA		LIKE '{@NAME_JA}'"	/>
			<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
		</og:equals>
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="A.SYSTEM_ID,A.LISTID,A.KBTEXT,A.SEQ" />
</og:query>

<!-- tableFilter でラベル設定します。設定先が未設定の場合のみセットされます。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,LANG,CLM,LRAW" vals="{@SYSTEM_ID},ja,CLM,NAME_JA" />

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor columns="SYSTEM_ID,LISTID,KBTEXT,CLM" must="true" />

<form method="POST" action="forward.jsp" target="RESULT">
	<!-- 追加、複写、変更、削除ボタンを作成します。 -->
	<og:writeCheck>
		<og:submit action="COPY"   columnWritable="SYSTEM_ID,LISTID,KBTEXT,CLM,SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES" />
		<og:submit action="MODIFY" columnWritable="SEQ,USE_LENGTH,FGUSE,RELEASE_NOTES" />
		<og:submit action="DELETE" columnWritable="null" />
		<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		noDisplay		= "SYSID"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
	/>
</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
