/****************************************************************************/
/* GF66 ( ﾀｽｸﾘｿｰｽ定義 )                                                     */
/*                                                                          */
/* Created : 2021/06/29 14:03:35                                            */
/****************************************************************************/

CREATE TABLE GF66 (
   PRJCODE      VARCHAR2 ( 30 )                                     /*  1 PRJｺｰﾄﾞ   */
 , TASK_ID      NUMBER   (  5 )                                     /*  2 ﾀｽｸID     */
 , RESOURCE_ID  NUMBER   (  9 )                                     /*  3 ﾘｿｰｽID    */
 , SEQ          NUMBER   (  7 )     DEFAULT 0   NOT NULL            /*  4 順        */
 , SU_LOAD      NUMBER   (  5 )                                     /*  5 負荷      */
 , UNIQ         NUMBER   (  9 )     DEFAULT 0   NOT NULL            /*  6 ﾕﾆｰｸｷｰ    */
 , FGJ          VARCHAR2 (  1 )     DEFAULT '1' NOT NULL            /*  7 状態ﾌﾗｸﾞ  */
 , DYSET        VARCHAR2 ( 14 )                                     /*  8 登録日時  */
 , PGSET        VARCHAR2 ( 10 )                                     /*  9 作成PG    */
 , PGPSET       VARCHAR2 ( 10 )                                     /* 10 作成親PG  */
 , USRSET       VARCHAR2 ( 10 )                                     /* 11 作成社員  */
 , DYUPD        VARCHAR2 ( 14 )                                     /* 12 更新日時  */
 , PGUPD        VARCHAR2 ( 10 )                                     /* 13 更新PG    */
 , PGPUPD       VARCHAR2 ( 10 )                                     /* 14 更新親PG  */
 , USRUPD       VARCHAR2 ( 10 )                                     /* 15 更新者    */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 64K );


CREATE SEQUENCE GF66S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF66T00 
  BEFORE INSERT ON GF66
  FOR EACH ROW 
  BEGIN 
    SELECT GF66S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
