package gf;

import java.util.ArrayList;
import java.util.List;

import org.opengion.fukurou.business.BizLogic_TABLE;
// import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.penguin.math.statistics.HybsMahalanobis;

/**
 * マハラノビス距離の計算を行います。
 * penguinパッケージを利用します。
 *
 * @version 5.0
 * @author T.OTA
 * @since JDK1.7
 * @author opengion
 *
 */
public class GFX030B extends BizLogic_TABLE {
	List<double[]>	dataList	= new ArrayList<double[]>();

	/**
	 * メインカーソルの各行で呼ばれるロジックを定義します
	 *
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean befall( int row ) {
		double[] lineData = new double[2];

		// 検査ﾃﾞｰﾀを全て格納する
		String clm1 = var( "COLUMN_NAME1" );
		String clm2 = var( "COLUMN_NAME2" );

		if( isEmpty( line( clm1 ) ) ) {
			lineData[0] = 0;
		}
		else {
			lineData[0] = lined( clm1 );
		}

		if( isEmpty( line( clm2 ) ) ) {
			lineData[1] = 0;
		}
		else {
			lineData[1] = lined( clm2 );
		}

		dataList.add( lineData );
		return true;
	}

	/**
	 * 空ﾁｪｯｸ
	 * @param str
	 * @return true:空 false:空でない
	 */
	private boolean isEmpty( String str ) {
		return "".equals( str ) || str == null ;	// 8.0.0.0 (2021/07/31) Avoid unnecessary if..then..else statements when returning booleans
//		if( "".equals( str ) || str == null ) { return true; }
//		return false;
	}

	/**
	 * 最後の行の終わりで呼び出し
	 *
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {

		// ﾏﾊﾗﾉﾋﾞｽ計算の初期化処理
		HybsMahalanobis rtn = new HybsMahalanobis( (double[][]) dataList.toArray( new double[dataList.size()][2] ) );

		double[] checkData = new double[2];
		checkData[0] = vard( "JUDGE_COLUMN_NAME1" );
		checkData[1] = vard( "JUDGE_COLUMN_NAME2" );

		// 入力値の検査結果を返却
		rtn(String.valueOf( rtn.check( checkData ) )  );

		return true;
	}
}
