<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0100"
	title	= "ﾃﾞｰﾀ登録"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="ENTRY" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- UPCNT は、ﾃﾞｰﾀがない場合 NULL になり、entry で初期値が書き込まれるため、全件変更される -->
<og:entry command="ENTRY" selectedAll="true" >
	<og:columnSet command="ENTRY" columnId="UPCNT" action="NULLSET" value="0" />
</og:entry>

<!-- VAL,JUDG,RIYU 必須、DATA_TYPE,CDREC,E_MIN,W_MIN,W_MAX,E_MAX を使って、結果を判定します -->
<og:tableFilter classId="JUDG" />

<og:value command="SETTBL" key="DY_HATU" value="DY_HATU" action="FIRST" />
<og:value command="SETTBL" key="SET_KEY" value="SET_KEY" action="FIRST" />
<og:value command="SETTBL" key="SET_GRP" value="SET_GRP" action="FIRST" />
<og:value command="SETTBL" key="DY_YOTE" value="DY_YOTE" action="FIRST" />

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<og:transaction>
	<!-- changeOnly="true" は、DBTableModelのデータ変更があった行のみ処理を行います。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" debug="{@debug}" changeOnly="true">
		<!-- VAL値が同じ場合は、更新しません(insertOnly="true") そうでない場合は、UPCNT +1 して、INSERTします。 -->
		<og:tableUpdateParam
			sqlType		= "INSERT"
			table		= "GG10"
			names		= "DY_HATU,SET_KEY,SET_GRP,TOKEN,VAL,TANI,JUDG,RIYU"
			funcKeys	= "UPCNT"
			funcVals	= "[UPCNT]+1"
		/>
	</og:tableUpdate>

	<!-- 最大の判定結果の取得 -->
	<!-- 先のquery では、ﾀﾌﾞ名称 の絞り込みが行われているので、再度検索する -->
	<og:value command="SQL">
		select max(A.JUDG) as D_JUDG
		from GG10 A inner join (
				select DY_HATU,SET_KEY,SET_GRP,TOKEN,max(UPCNT) as UPCNT
				from GG10
				where	DY_HATU='{@DY_HATU}' and SET_KEY='{@SET_KEY}' and SET_GRP='{@SET_GRP}'
				group by DY_HATU,SET_KEY,SET_GRP,TOKEN
			) B
		on  A.UPCNT   = B.UPCNT
		and A.DY_HATU = B.DY_HATU
		and A.SET_KEY = B.SET_KEY
		and A.SET_GRP = B.SET_GRP
		and A.TOKEN   = B.TOKEN
	</og:value>

	<!-- 予定実績ﾃｰﾌﾞﾙ(GG11)に対してﾃﾞｰﾀ追加、更新します -->
	<og:bizLogic logics="gg11.GG0100A" selectedAll="true"
		keys="JUDG,USRJISI" vals="{@D_JUDG},{@USER.ID}"
	/>
</og:transaction>

<og:forward page="result.jsp" keys="command,TAB_NM" vals="RENEW,{@TAB_NM}" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
