/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.RecordFormatException;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.ExcelLayout;
import org.opengion.hayabusa.report.ExcelLayoutData;

public class ExcelDataPickup {
    private final ExcelLayout layout;
    private final InputStream in;
    private final HSSFWorkbook wb;
    private NumberFormat numFormat;
    private final boolean debug;

    public ExcelDataPickup(ExcelLayout excelLayout, File file, boolean bl) {
        this.layout = excelLayout;
        this.debug = bl;
        try {
            this.in = new FileInputStream(file);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(this.in);
            this.wb = new HSSFWorkbook(pOIFSFileSystem);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file.getName() + "]";
            throw new HybsSystemException(string, iOException);
        }
        catch (RecordFormatException recordFormatException) {
            String string = "\u7121\u52b9\u306e\u5f62\u5f0f/\u30c7\u30fc\u30bf\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + file.getName() + "]\u73fe\u30d0\u30fc\u30b8\u30e7\u30f3\u306ePOI\u3067\u306f\u8aad\u307f\u53d6\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002\u4f8b\u3048\u3070\u3001\u81ea\u52d5\u30d5\u30a3\u30eb\u30bf\u306e\u8a2d\u5b9a\u3055\u308c\u305f\u30b7\u30fc\u30c8\u304c\u542b\u307e\u308c\u308b\u5834\u5408\u306a\u3069\u3067\u3059\u3002";
            throw new HybsSystemException(string, recordFormatException);
        }
    }

    public int getSheetSize() {
        return this.wb.getNumberOfSheets();
    }

    public void execute(int n, int n2, String string) {
        HSSFSheet hSSFSheet = this.wb.getSheetAt(n2);
        this.layout.dataClear();
        if (this.debug) {
            System.out.println(n2 + ":" + this.wb.getSheetName(n2));
        }
        Iterator<ExcelLayoutData> iterator = this.layout.getLayoutDataIterator(n, string);
        while (iterator.hasNext()) {
            ExcelLayoutData excelLayoutData = iterator.next();
            String string2 = excelLayoutData.getClm();
            int n3 = excelLayoutData.getEdbn();
            int n4 = excelLayoutData.getRowNo();
            short s = excelLayoutData.getColNo();
            String string3 = this.getValue(hSSFSheet, n4, s);
            this.layout.addData(string2, n3, string3);
            if (!this.debug) continue;
            System.out.println(excelLayoutData.toString() + "=[" + string3 + "]");
        }
    }

    private String getValue(HSSFSheet hSSFSheet, int n, int n2) {
        HSSFRow hSSFRow = hSSFSheet.getRow(n);
        if (hSSFRow == null) {
            return null;
        }
        HSSFCell hSSFCell = hSSFRow.getCell(n2);
        if (hSSFCell == null) {
            return null;
        }
        String string = "";
        switch (hSSFCell.getCellType()) {
            case NUMERIC: {
                string = this.getNumericTypeString(hSSFCell);
                break;
            }
            case STRING: {
                HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                string = hSSFRichTextString.getString();
                if (!this.debug) break;
                System.out.print("String :");
                break;
            }
            case FORMULA: {
                HSSFRichTextString hSSFRichTextString = hSSFCell.getRichStringCellValue();
                string = hSSFRichTextString.getString();
                if (string == null || string.isEmpty()) {
                    string = this.getNumericTypeString(hSSFCell);
                    break;
                }
                if (!this.debug) break;
                System.out.print("Formula:");
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(hSSFCell.getBooleanCellValue());
                if (!this.debug) break;
                System.out.print("Boolean:");
                break;
            }
            case BLANK: {
                if (!this.debug) break;
                System.out.print("Blank  :");
                break;
            }
            case ERROR: {
                if (!this.debug) break;
                System.out.print("Error  :");
                break;
            }
            default: {
                if (!this.debug) break;
                System.out.print("Other " + hSSFCell.getCellType() + ":");
            }
        }
        return StringUtil.rTrim((String)string);
    }

    private String getNumericTypeString(HSSFCell hSSFCell) {
        String string;
        double d = hSSFCell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)hSSFCell)) {
            string = DateSet.getDate((long)DateUtil.getJavaDate((double)d).getTime(), (String)"yyyyMMddHHmmss");
            if (this.debug) {
                System.out.print("Date   :");
            }
        } else {
            if (this.numFormat == null) {
                this.numFormat = NumberFormat.getInstance();
                if (this.numFormat instanceof DecimalFormat) {
                    ((DecimalFormat)this.numFormat).applyPattern("#.####");
                }
            }
            string = this.numFormat.format(d);
            if (this.debug) {
                System.out.print("Numeric:");
            }
        }
        return string;
    }

    public void close() {
        Closer.ioClose((Closeable)this.in);
    }
}

