/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgCharacterException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.QrcodeImage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.OdsSheet;
import org.opengion.hayabusa.report2.TagParser;

class OdsContentParser {
    private static final String BODY_START_TAG = "<table:table ";
    private static final String BODY_END_TAG = "</table:table>";
    private static final String ROW_START_TAG = "<table:table-row ";
    private static final String ROW_START_TAG_INVISIBLE = "<table:table-row table:visibility=\"collapse\" ";
    private static final String TABLE_CELL_START_TAG = "<table:table-cell";
    private static final String TABLE_CELL_END_TAG = "</table:table-cell>";
    private static final String SHEET_NAME_START = "table:name=\"";
    private static final String OBJECT_SEARCH_STR = "table:end-cell-address=\"";
    private static final String PRINT_RANGE_START = "table:print-ranges=\"";
    private static final String PRINT_RANGE_END = "\"";
    private static final String FIRST_PAGE_NAME = "FIRST";
    private static final String SHEET_BREAK = "SHEETBREAK";
    private static final String VAR_START = "{@";
    private static final String VAR_END = "}";
    private static final String VAR_CON = "_";
    private static final String PAGE_END_CUT = "PAGEENDCUT";
    private static final String PAGE_BREAK = "PAGEBREAK";
    private static final String PAGE_NO = "PAGENO";
    private static final String ROW_NO = "ROWNO";
    private static final String DRAW_IMG_START_TAG = "<draw:image xlink:href=\"";
    private static final String DRAW_IMG_END_TAG = "</draw:image>";
    private static final String DRAW_IMG_HREF_END = "\"";
    private static final String IMG_DIR = "Pictures";
    private static final String QRCODE_PREFIX = "QRCODE.";
    private static final String QRCODE_FILETYPE = ".png";
    private static final int QR_VERSION = HybsSystem.sysInt("REPORT_QR_VERSION");
    private static final char QR_ENCMODE_CH = HybsSystem.sys("REPORT_QR_ENCMODE").charAt(0);
    private static final char QR_ERRCRCT_CH = HybsSystem.sys("REPORT_QR_ERRCRCT").charAt(0);
    private static final String QR_IMAGE_TYPE = "PNG";
    private static final int QR_PIXEL = HybsSystem.sysInt("REPORT_QR_PIXEL");
    private static final QrcodeImage.EncMode QR_ENCMODE = QrcodeImage.EncMode.get((char)QR_ENCMODE_CH);
    private static final QrcodeImage.ErrCrct QR_ERRCRCT = QrcodeImage.ErrCrct.get((char)QR_ERRCRCT_CH);
    private static final String QR_TXT_ENC = HybsSystem.sys("REPORT_QR_TEXT_ENCODE");
    private static final String IMG_PREFIX = "IMG.";
    private static final String OOOC_FUNCTION_START = "oooc:=";
    private static final String OOOC_FUNCTION_START_3 = "of:=";
    private static final String OOOC_FUNCTION_END = ")\" ";
    private static final String OOO_CR = "</text:p><text:p>";
    private static final String GRAPH_START_TAG = "<draw:frame ";
    private static final String GRAPH_END_TAG = "</draw:frame>";
    private static final String GRAPH_UPDATE_RANGE_START = "draw:notify-on-update-of-ranges=\"";
    private static final String GRAPH_UPDATE_RANGE_END = "\"";
    private static final String GRAPH_HREF_START = "xlink:href=\"./";
    private static final String GRAPH_HREF_END = "\"";
    private static final String GRAPH_OBJREPL = "ObjectReplacements";
    private static final String GRAPH_CONTENT_START = "-address=\"";
    private static final String GRAPH_CONTENT_END = "\"";
    private static final String MANIFEST_START_TAG = "<manifest:file-entry ";
    private static final String MANIFEST_END_TAG = "/>";
    private static final String TABLE_CELL_STRING_TYPE = "office:value-type=\"string\"";
    private static final String TABLE_CELL_FLOAT_TYPE = "office:value-type=\"float\"";
    private static final String TABLE_CELL_FLOAT_VAL_START = "office:value=\"";
    private static final String TABLE_CELL_FLOAT_VAL_END = "\"";
    private static final String TEXT_START_TAG = "<text:p>";
    private static final String TEXT_END_TAG = "</text:p>";
    private static final String ANNOTATION_PREFIX = "ANO.";
    private static final String TEXT_START_ANO_TAG = "<text:p";
    private static final String TEXT_START_END_ANO_TAG = ">";
    private static final String ANNOTATION_START_TAG = "<office:annotation";
    private static final String ANNOTATION_END_TAG = "</office:annotation>";
    private static final String DRAW_START_KEY = "<draw:";
    private static final String DRAW_END_KEY = "</draw:";
    private static final String STYLE_START_TAG = "<style:style ";
    private static final String STYLE_END_TAG = "</style:style>";
    private static final String STYLE_NAME_START_TAG = "style:name=\"";
    private static final String STYLE_NAME_END_TAG = "\"";
    private static final String TABLE_STYLE_NAME_START_TAG = "table:style-name=\"";
    private static final String TABLE_STYLE_NAME_END_TAG = "\"";
    private static final String TABLE_COUNT_START_TAG = "meta:table-count=\"";
    private static final String TABLE_COUNT_END_TAG = "\"";
    private static final String CELL_COUNT_START_TAG = "meta:cell-count=\"";
    private static final String CELL_COUNT_END_TAG = "\"";
    private static final String OBJECT_COUNT_START_TAG = "meta:object-count=\"";
    private static final String OBJECT_COUNT_END_TAG = "\"";
    private static final int NORMAL = 0;
    private static final int LASTROW = 1;
    private static final int OVERFLOW = 2;
    private int status = 0;
    private int currentBaseRow;
    private int currentMaxRow;
    private int pages;
    private boolean isPageEndCut;
    private boolean isPageBreak;
    private String xmlHeader;
    private int sheetBreakClm = -1;
    private int sheetNameClm = -1;
    private boolean isNeedsReparse;
    private final ConcurrentMap<String, List<String>> pageNameMap = new ConcurrentHashMap<String, List<String>>();
    private final List<String> repStyleList = new ArrayList<String>();
    private final ConcurrentMap<String, String> addObjMap = new ConcurrentHashMap<String, String>();
    private final ExecQueue queue;
    private final String path;
    private final boolean useChangeType;

    OdsContentParser(ExecQueue execQueue, String string) {
        this.queue = execQueue;
        this.path = string;
        this.currentBaseRow = this.queue.getExecRowCnt();
        this.useChangeType = !this.queue.isFglocal() || HybsSystem.sysBool("REPORT_USE_CHANGETYPE");
    }

    public void exec() {
        this.execStyles();
        this.execContent();
        if (this.isNeedsReparse) {
            this.execContentHeader();
            this.execMergeContent();
        }
        this.execMeta();
        if (!this.addObjMap.isEmpty()) {
            this.execManifest();
        }
    }

    private void execContent() {
        String string = this.path + "content.xml";
        String string2 = this.readOOoXml(string);
        String[] stringArray = OdsContentParser.tag2Array(string2, BODY_START_TAG, BODY_END_TAG);
        String string3 = stringArray[0];
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(string);
            bufferedWriter.write(this.xmlHeader);
            bufferedWriter.write(10);
            bufferedWriter.write(string3);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:error occurer while content.xml(header) " + string + HybsConst.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
            bufferedWriter = null;
        }
        String string4 = stringArray[1];
        ArrayList<OdsSheet> arrayList = new ArrayList<OdsSheet>();
        HashMap<String, OdsSheet> hashMap = new HashMap<String, OdsSheet>();
        DBTableModel dBTableModel = this.queue.getBody();
        int n = dBTableModel.getRowCount();
        OdsSheet odsSheet = null;
        for (int i = 2; i < stringArray.length; ++i) {
            OdsSheet object2 = new OdsSheet();
            object2.analyze(stringArray[i], n);
            String string5 = object2.getSheetName();
            if (string5.startsWith(FIRST_PAGE_NAME)) {
                arrayList.add(object2);
            } else {
                hashMap.put(string5, object2);
                if (odsSheet == null) {
                    odsSheet = object2;
                }
            }
            String string6 = object2.getOrigSheetName();
            if (!this.isNeedsReparse && string3.indexOf("=\"" + string6 + ".") >= 0) {
                this.isNeedsReparse = true;
            }
            this.pageNameMap.put(string6, new ArrayList());
        }
        try {
            if (this.isNeedsReparse) {
                bufferedWriter = this.getWriter(string + ".tmp");
                this.getRepStyleList(string3);
            } else {
                bufferedWriter = this.getWriter(string, true);
            }
            if (this.queue.isUseSheetName()) {
                this.sheetNameClm = dBTableModel.getColumnNo(PAGE_BREAK, false);
            }
            if (this.queue.getExecPagesCnt() == 0) {
                for (OdsSheet odsSheet2 : arrayList) {
                    if (this.currentBaseRow >= n) break;
                    this.writeParsedSheet(odsSheet2, bufferedWriter);
                }
            }
            this.sheetBreakClm = dBTableModel.getColumnNo(SHEET_BREAK, false);
            while (this.currentBaseRow < n) {
                String string7;
                if (this.pages >= 999) {
                    this.queue.setEnd(false);
                    break;
                }
                OdsSheet odsSheet2 = null;
                if (this.sheetBreakClm >= 0 && (string7 = (String)dBTableModel.getValue(this.currentBaseRow, this.sheetBreakClm)) != null && string7.length() > 0) {
                    odsSheet2 = (OdsSheet)hashMap.get(string7);
                }
                if (odsSheet2 == null) {
                    odsSheet2 = odsSheet;
                }
                this.writeParsedSheet(odsSheet2, bufferedWriter);
            }
            this.queue.addExecPageCnt(this.pages);
            this.queue.setExecRowCnt(this.currentBaseRow);
            bufferedWriter.write(string4);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:error occurer while write Parsed Sheet " + string + HybsConst.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
        }
    }

    private void writeParsedSheet(OdsSheet odsSheet, BufferedWriter bufferedWriter) throws IOException {
        String string;
        Object object = null;
        if (this.sheetNameClm >= 0 && (string = (String)this.queue.getBody().getValue(this.currentBaseRow, this.sheetNameClm)) != null) {
            object = string;
        }
        if (object == null && (string = odsSheet.getSheetName()).startsWith(FIRST_PAGE_NAME)) {
            if (StringUtil.startsChar((CharSequence)(string = string.substring(FIRST_PAGE_NAME.length()).trim()), (char)'_')) {
                string = string.substring(1);
            }
            if (string.length() > 0) {
                object = string;
            }
        }
        if (object == null) {
            object = odsSheet.getConfSheetName() == null ? "Page" + (this.queue.getExecPagesCnt() + this.pages) + "_Row" + this.currentBaseRow : odsSheet.getConfSheetName() + (this.queue.getExecPagesCnt() + this.pages + 1);
        }
        this.isPageBreak = false;
        string = odsSheet.getOrigSheetName();
        Object object2 = odsSheet.getHeader().replace(SHEET_NAME_START + string, SHEET_NAME_START + (String)object);
        int n = ((String)object2).indexOf(PRINT_RANGE_START);
        if (n >= 0) {
            int n2 = ((String)object2).indexOf("\"", n + PRINT_RANGE_START.length());
            String string2 = ((String)object2).substring(n, n2);
            string2 = string2.replace(string, (CharSequence)object);
            object2 = ((String)object2).substring(0, n) + string2 + ((String)object2).substring(n2);
        }
        this.writeParsedRow((String)object2, bufferedWriter, string, (String)object);
        String[] stringArray = odsSheet.getRows();
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeParsedRow(stringArray[i], bufferedWriter, string, (String)object);
        }
        if (this.currentBaseRow == this.currentMaxRow && !string.startsWith(FIRST_PAGE_NAME)) {
            this.queue.addMsg("[ERROR]PARSE:No Data defined on Template ODS(" + this.queue.getListId() + ")" + HybsConst.CR);
            throw new HybsSystemException();
        }
        this.currentBaseRow = this.currentMaxRow;
        bufferedWriter.write(odsSheet.getFooter());
        ++this.pages;
        ((List)this.pageNameMap.get(string)).add(object);
    }

    private void writeParsedRow(final String string, BufferedWriter bufferedWriter, String string2, String string3) throws IOException {
        this.isPageEndCut = false;
        String string4 = new TagParser(){

            @Override
            protected void exec(String string4, StringBuilder stringBuilder, int n) {
                String string2 = TagParser.checkKey(string4, stringBuilder);
                if (string2.indexOf(60) >= 0) {
                    OdsContentParser.this.queue.addMsg("[ERROR]PARSE:{@\u3068}\u306e\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059\u3002\u5909\u6570\u5185\u306e\u7279\u5b9a\u306e\u6587\u5b57\u5217\u306b\u66f8\u5f0f\u8a2d\u5b9a\u304c\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u30ad\u30fc=" + string2 + HybsConst.CR);
                    throw new HybsSystemException();
                }
                if (string2.startsWith(OdsContentParser.QRCODE_PREFIX)) {
                    this.setOffset(OdsContentParser.this.makeQRImage(string, n, string2.substring(OdsContentParser.QRCODE_PREFIX.length()), stringBuilder));
                } else if (string2.startsWith(OdsContentParser.IMG_PREFIX)) {
                    this.setOffset(OdsContentParser.this.changeImage(string, n, string2.substring(OdsContentParser.IMG_PREFIX.length()), stringBuilder));
                } else if (string2.startsWith(OdsContentParser.ANNOTATION_PREFIX)) {
                    this.setOffset(OdsContentParser.this.parseByAnnotation(string, n, string2.substring(OdsContentParser.ANNOTATION_PREFIX.length()), stringBuilder));
                } else {
                    String string3 = OdsContentParser.this.getValue(string2);
                    if (OdsContentParser.this.useChangeType) {
                        OdsContentParser.this.changeType(string, n, string3, OdsContentParser.this.getNativeType(string2, string3), stringBuilder);
                    }
                    stringBuilder.append(string3);
                }
                if (OdsContentParser.this.queue.isFgcut() && OdsContentParser.PAGE_END_CUT.equals(string2)) {
                    OdsContentParser.this.isPageEndCut = true;
                }
            }
        }.doParse(string, VAR_START, VAR_END, false);
        if (this.isPageEndCut && (this.status == 2 || this.sheetBreakClm >= 0 && this.isPageBreak)) {
            string4 = string4.replace(ROW_START_TAG, ROW_START_TAG_INVISIBLE);
        }
        if (string4.indexOf(OBJECT_SEARCH_STR) >= 0) {
            string4 = string4.replace(OBJECT_SEARCH_STR + string2, OBJECT_SEARCH_STR + string3);
        }
        string4 = this.replaceOoocError(string4);
        if ((string4 = this.replaceGraphInfo(string4, string2, string3)).indexOf(ANNOTATION_START_TAG) >= 0) {
            string4 = new TagParser(){}.doParse(string4, ANNOTATION_START_TAG, ANNOTATION_END_TAG);
        }
        if (this.isNeedsReparse) {
            for (String string5 : this.repStyleList) {
                if (string4.indexOf(TABLE_STYLE_NAME_START_TAG + string5 + "\"") < 0) continue;
                string4 = string4.replace(TABLE_STYLE_NAME_START_TAG + string5 + "\"", TABLE_STYLE_NAME_START_TAG + string5 + VAR_CON + string3 + "\"");
            }
        }
        bufferedWriter.write(string4);
    }

    private void changeType(String string, int n, String string2, NativeType nativeType, StringBuilder stringBuilder) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        if (nativeType != NativeType.INT && nativeType != NativeType.LONG && nativeType != NativeType.DOUBLE) {
            return;
        }
        if (!this.isCell(string, n)) {
            return;
        }
        if (stringBuilder.lastIndexOf(TEXT_START_TAG) + TEXT_START_TAG.length() == stringBuilder.length() && string.indexOf(TEXT_END_TAG, n) == n) {
            int n2 = stringBuilder.lastIndexOf(TABLE_CELL_STRING_TYPE);
            int n3 = stringBuilder.lastIndexOf(TABLE_CELL_START_TAG);
            if (n2 >= 0 && n3 >= 0 && n2 > n3) {
                stringBuilder.replace(n2, n2 + TABLE_CELL_STRING_TYPE.length(), "office:value-type=\"float\" office:value=\"" + string2 + "\"");
            }
        }
    }

    private NativeType getNativeType(String string, String string2) {
        String string3;
        if (string2 == null || string2.isEmpty()) {
            return NativeType.STRING;
        }
        NativeType nativeType = null;
        if (this.queue.isFglocal()) {
            int n;
            string3 = string;
            int n2 = string.lastIndexOf(VAR_CON);
            if (n2 >= 0) {
                n = -1;
                try {
                    n = Integer.parseInt(string3.substring(n2 + VAR_CON.length(), string3.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = "'_'\u4ee5\u964d\u306e\u6587\u5b57\u3092\u30ab\u30e9\u30e0\u540d\u306e\u4e00\u90e8\u3068\u3057\u3066\u6271\u3044\u307e\u3059\u3002\u30ab\u30e9\u30e0\u540d=[" + string + "]" + HybsConst.CR + numberFormatException.getMessage();
                    System.err.println(string4);
                }
                if (n >= 0) {
                    string3 = string3.substring(0, n2);
                }
            }
            if ((n = this.queue.getBody().getColumnNo(string3, false)) >= 0) {
                nativeType = this.queue.getBody().getDBColumn(n).getNativeType();
            }
        }
        if (nativeType == null && ((nativeType = NativeType.getType((String)(string3 = string2.replace(",", "")))) == NativeType.INT || nativeType == NativeType.LONG) && string3.length() >= 2 && string3.charAt(0) == '0') {
            nativeType = NativeType.STRING;
        }
        return nativeType;
    }

    private int parseByAnnotation(String string, int n, String string2, StringBuilder stringBuilder) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        boolean bl = this.isCell(string, n6);
        if (bl && (n5 = stringBuilder.indexOf(TABLE_CELL_FLOAT_TYPE, n4 = stringBuilder.lastIndexOf(TABLE_CELL_START_TAG, n6))) >= 0) {
            stringBuilder.replace(n5, n5 + TABLE_CELL_FLOAT_TYPE.length(), TABLE_CELL_STRING_TYPE);
            n3 = stringBuilder.indexOf(TABLE_CELL_FLOAT_VAL_START, n5);
            if (n3 >= 0 && (n2 = stringBuilder.indexOf("\"", n3 + TABLE_CELL_FLOAT_VAL_START.length())) >= 0) {
                stringBuilder.replace(n3, n2 + "\"".length(), "");
            }
        }
        int n7 = n4 = bl ? string.indexOf(TABLE_CELL_END_TAG, n6) : string.indexOf(DRAW_END_KEY, n6);
        if (n4 >= 0) {
            n5 = string.indexOf(TEXT_START_ANO_TAG, n6);
            if (bl) {
                while (!this.isCell(string, n5) && n5 >= 0) {
                    n5 = string.indexOf(TEXT_START_ANO_TAG, n5 + 1);
                }
            }
            if (n5 >= 0 && n5 < n4) {
                n3 = string.lastIndexOf(TEXT_END_TAG, n4);
                if (bl) {
                    while (!this.isCell(string, n3) && n3 >= 0) {
                        n3 = string.lastIndexOf(TEXT_END_TAG, n3 - 1);
                    }
                }
                if (n3 >= 0 && n5 < n3 && n3 < n4) {
                    n2 = string.indexOf(TEXT_START_END_ANO_TAG, n5 + TEXT_START_ANO_TAG.length()) + TEXT_START_END_ANO_TAG.length();
                    stringBuilder.append(string.substring(n6, n2));
                    String string3 = TagParser.checkKey(string.substring(n2, n3), stringBuilder);
                    if (string3.indexOf(60) < 0 && string3.indexOf(62) < 0) {
                        String string4 = this.getValue(string2);
                        if (this.useChangeType) {
                            this.changeType(string, n3, string4, this.getNativeType(string2, string3), stringBuilder);
                        }
                        stringBuilder.append(string4);
                    }
                    n6 = n3;
                }
            }
        }
        return n6;
    }

    private boolean isCell(String string, int n) {
        int n2 = string.lastIndexOf(DRAW_START_KEY, n);
        if (n2 < 0) {
            return true;
        }
        int n3 = string.lastIndexOf(TABLE_CELL_START_TAG, n);
        if (n2 < n3) {
            return true;
        }
        int n4 = string.indexOf(DRAW_END_KEY, n);
        if (n4 < 0) {
            return true;
        }
        int n5 = string.indexOf(TABLE_CELL_END_TAG, n);
        return n5 >= 0 && n5 < n4;
    }

    private int makeQRImage(String string, int n, String string2, StringBuilder stringBuilder) {
        int n2 = n;
        n2 = string.indexOf(DRAW_IMG_START_TAG, n2) + DRAW_IMG_START_TAG.length();
        stringBuilder.append(string.substring(n, n2));
        n2 = string.indexOf("\"", n2) + "\"".length();
        String string3 = "Pictures/" + string2 + VAR_CON + this.currentBaseRow + QRCODE_FILETYPE;
        stringBuilder.append(string3).append("\"");
        String string4 = this.getValue(string2);
        String string5 = new File(this.path).getAbsolutePath() + File.separator + IMG_DIR + File.separator + string2 + VAR_CON + this.currentBaseRow + QRCODE_FILETYPE;
        if (!new File(string5).getParentFile().exists() && new File(string5).getParentFile().mkdirs()) {
            System.err.println(string5 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        QrcodeImage qrcodeImage = new QrcodeImage();
        qrcodeImage.init(string4, string5, QR_VERSION, QR_ENCMODE, QR_ERRCRCT, QR_IMAGE_TYPE, QR_PIXEL, QR_TXT_ENC);
        qrcodeImage.saveImage();
        this.addObjMap.put(string3, QRCODE_FILETYPE.substring(1));
        return n2;
    }

    private int changeImage(String string, int n, String string2, StringBuilder stringBuilder) {
        int n2 = n;
        File file = null;
        String string3 = this.getValue(string2);
        if (string3 != null && string3.length() > 0) {
            file = new File(HybsSystem.url2dir(string3));
        }
        if (file != null && file.exists()) {
            n2 = string.indexOf(DRAW_IMG_START_TAG, n2) + DRAW_IMG_START_TAG.length();
            stringBuilder.append(string.substring(n, n2));
            n2 = string.indexOf("\"", n2) + "\"".length();
            String string4 = string3.substring(string3.lastIndexOf(46));
            String string5 = "Pictures/" + Integer.toUnsignedString(file.hashCode()) + string4;
            stringBuilder.append(string5).append("\"");
            File file2 = new File(this.path, string5);
            if (!file2.getParentFile().exists() && file2.getParentFile().mkdirs()) {
                System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            FileUtil.copy((File)file, (File)file2);
            this.addObjMap.put(string5, OdsContentParser.getSuffix(file.getName()));
        } else {
            n2 = string.indexOf(DRAW_IMG_START_TAG, n2);
            stringBuilder.append(string.substring(n, n2));
            n2 = string.indexOf(DRAW_IMG_END_TAG, n2) + DRAW_IMG_END_TAG.length();
        }
        return n2;
    }

    private String replaceOoocError(final String string) {
        String string2;
        if (string.indexOf(OOOC_FUNCTION_START_3) >= 0) {
            string2 = OOOC_FUNCTION_START_3;
        } else if (string.indexOf(OOOC_FUNCTION_START) >= 0) {
            string2 = OOOC_FUNCTION_START;
        } else {
            return string;
        }
        String string3 = new TagParser(){

            @Override
            protected boolean checkIgnore(int n, int n2) {
                int n3 = string.indexOf(OdsContentParser.TEXT_START_END_ANO_TAG, n + 1);
                return n2 >= 0 && n2 < n3;
            }

            @Override
            protected void exec(String string3, StringBuilder stringBuilder, int n) {
                Object object = string3.substring(string2.length(), string3.length() - OdsContentParser.OOOC_FUNCTION_END.length()) + ")";
                object = ((String)object).replace("\"", "&quot;&quot;").replace(OdsContentParser.OOO_CR, "");
                stringBuilder.append(string2).append("IF(ISERROR(").append((String)object).append(");&quot;&quot;;").append((String)object).append(OdsContentParser.OOOC_FUNCTION_END);
            }
        }.doParse(string, string2, OOOC_FUNCTION_END);
        return string3;
    }

    private String replaceGraphInfo(String string, final String string2, final String string3) {
        if (string.indexOf(GRAPH_START_TAG) < 0 || string.indexOf(GRAPH_UPDATE_RANGE_START) < 0) {
            return string;
        }
        return new TagParser(){

            @Override
            protected void exec(String string, StringBuilder stringBuilder, int n) {
                String string22;
                String string32 = string;
                if (string32.indexOf(OdsContentParser.GRAPH_UPDATE_RANGE_START) >= 0 && new File(OdsContentParser.this.path + (string22 = TagParser.getValueFromTag(string32, OdsContentParser.GRAPH_HREF_START, "\""))).exists()) {
                    String string4 = string22 + OdsContentParser.VAR_CON + OdsContentParser.this.pages;
                    FileUtil.copyDirectry((String)(OdsContentParser.this.path + string22), (String)(OdsContentParser.this.path + string4));
                    string32 = string32.replace(OdsContentParser.GRAPH_HREF_START + string22, OdsContentParser.GRAPH_HREF_START + string4);
                    string32 = string32.replace("xlink:href=\"./ObjectReplacements/" + string22, "xlink:href=\"./ObjectReplacements/" + string4);
                    OdsContentParser.this.addObjMap.put(string4, "graph");
                    OdsContentParser.this.parseGraphContent(OdsContentParser.this.path + string4 + File.separator + "content.xml", string2, string3);
                    String string5 = TagParser.getValueFromTag(string, OdsContentParser.GRAPH_UPDATE_RANGE_START, "\"");
                    string32 = string32.replace(OdsContentParser.GRAPH_UPDATE_RANGE_START + string5, OdsContentParser.GRAPH_UPDATE_RANGE_START + string5.replace(string2, string3));
                }
                stringBuilder.append(string32);
            }
        }.doParse(string, GRAPH_START_TAG, GRAPH_END_TAG);
    }

    private void parseGraphContent(String string, final String string2, final String string3) {
        String string4 = this.readOOoXml(string);
        if (string4.indexOf(GRAPH_CONTENT_START) >= 0) {
            string4 = new TagParser(){

                @Override
                protected void exec(String string, StringBuilder stringBuilder, int n) {
                    stringBuilder.append(string.replace(string2, string3));
                }
            }.doParse(string4, GRAPH_CONTENT_START, "\"");
        }
        if (string4.indexOf(VAR_START) >= 0) {
            string4 = new TagParser(){

                @Override
                public void exec(String string, StringBuilder stringBuilder, int n) {
                    stringBuilder.append(OdsContentParser.this.getHeaderFooterValue(string));
                }
            }.doParse(string4, VAR_START, VAR_END, false);
        }
        this.writeOOoXml(string, string4);
    }

    private String getValue(String string) {
        int n = string.lastIndexOf(VAR_CON);
        String string2 = null;
        if (n < 0) {
            string2 = this.getHeaderFooterValue(string);
        } else {
            String string3 = string.substring(0, n);
            int n2 = -1;
            try {
                n2 = Integer.parseInt(string.substring(n + VAR_CON.length(), string.length())) + this.currentBaseRow;
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = "\u96db\u5f62\u306e\u5909\u6570\u5b9a\u7fa9\u3067\u3001\u884c\u756a\u53f7\u6587\u5b57\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002\u30ab\u30e9\u30e0\u540d=[" + string + "]" + HybsConst.CR + numberFormatException.getMessage();
                System.err.println(string4);
            }
            string2 = n2 < 0 ? this.getHeaderFooterValue(string) : this.getBodyValue(string3, n2);
        }
        return this.checkValue(string2);
    }

    private String getHeaderFooterValue(String string) {
        String string2 = "";
        if (PAGE_NO.equals(string)) {
            string2 = String.valueOf(this.pages + 1);
        } else {
            int n;
            DBTableModel dBTableModel;
            DBTableModel dBTableModel2 = dBTableModel = this.status >= 1 ? this.queue.getFooter() : this.queue.getHeader();
            if (dBTableModel != null && (n = dBTableModel.getColumnNo(string, false)) >= 0) {
                string2 = (String)dBTableModel.getValue(0, n);
                if (this.queue.isFglocal()) {
                    string2 = dBTableModel.getDBColumn(n).getWriteValue(string2);
                }
            }
        }
        return string2;
    }

    private String getBodyValue(String string, int n) {
        if (this.isPageBreak) {
            return "";
        }
        DBTableModel dBTableModel = this.queue.getBody();
        int n2 = dBTableModel.getColumnNo(string, false);
        if (n2 < 0 && !ROW_NO.equals(string)) {
            return "";
        }
        int n3 = dBTableModel.getRowCount();
        if (PAGE_BREAK.equals(string)) {
            if (n < n3 - 1 && !((String)dBTableModel.getValue(n, n2)).equals(dBTableModel.getValue(n + 1, n2))) {
                this.isPageBreak = true;
            }
            return "";
        }
        if (this.sheetBreakClm >= 0 && n < n3 && this.currentBaseRow != n && !((String)dBTableModel.getValue(this.currentBaseRow, this.sheetBreakClm)).equals(dBTableModel.getValue(n, this.sheetBreakClm))) {
            this.isPageBreak = true;
            return "";
        }
        if (n >= n3) {
            this.status = 2;
            return "";
        }
        if (n == n3 - 1) {
            this.status = Math.max(1, this.status);
        }
        String string2 = null;
        if (ROW_NO.equals(string)) {
            string2 = String.valueOf(n + 1);
        } else {
            string2 = (String)dBTableModel.getValue(n, n2);
            if (this.queue.isFglocal()) {
                string2 = dBTableModel.getDBColumn(n2).getWriteValue(string2);
            }
        }
        if (this.currentMaxRow < n + 1) {
            this.currentMaxRow = n + 1;
        }
        return string2;
    }

    private String checkValue(String string) {
        int n;
        String string2 = string;
        if (this.queue.isFglocal() && (n = string2.indexOf("<span")) >= 0) {
            String string3 = string2.substring(n, string2.indexOf(62, n) + 1);
            string2 = string2.replace(string3, "").replace("</span>", "");
        }
        if (string2.indexOf(38) >= 0) {
            string2 = string2.replace("&", "&amp;");
        }
        if (string2.indexOf(60) >= 0) {
            string2 = string2.replace("<", "&lt;");
        }
        if (string2.indexOf(62) >= 0) {
            string2 = string2.replace(TEXT_START_END_ANO_TAG, "&gt;");
        }
        if (string2.indexOf(10) >= 0) {
            string2 = string2.replace("\r\n", "\n").replace("\n", OOO_CR);
        }
        return string2;
    }

    private static String[] tag2Array(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        int n2 = 0;
        while (true) {
            if ((n2 = string.indexOf(string2, n + 1)) < 0) break;
            if (n == -1) {
                string4 = string.substring(0, n2);
            } else {
                arrayList.add(string.substring(n, n2));
            }
            n = n2;
        }
        n2 = string.lastIndexOf(string3) + string3.length();
        arrayList.add(string.substring(n, n2));
        string5 = string.substring(n2);
        String[] stringArray = new String[arrayList.size() + 2];
        stringArray[0] = string4;
        stringArray[1] = string5;
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i + 2] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private void execStyles() {
        String string = this.path + "styles.xml";
        String string2 = this.readOOoXml(string);
        if (string2.indexOf(VAR_START) < 0) {
            return;
        }
        string2 = new TagParser(){

            @Override
            public void exec(String string, StringBuilder stringBuilder, int n) {
                stringBuilder.append(OdsContentParser.this.getHeaderFooterValue(string));
            }
        }.doParse(this.readOOoXml(string), VAR_START, VAR_END, false);
        this.writeOOoXml(string, string2);
    }

    private void execMeta() {
        String string;
        String string2 = this.path + "meta.xml";
        String string3 = this.readOOoXml(string2);
        if (string3.indexOf(TABLE_COUNT_START_TAG) >= 0) {
            string = TagParser.getValueFromTag(string3, TABLE_COUNT_START_TAG, "\"");
            string3 = string3.replace(TABLE_COUNT_START_TAG + string, TABLE_COUNT_START_TAG + this.pages);
        }
        if (string3.indexOf(CELL_COUNT_START_TAG) >= 0) {
            string = TagParser.getValueFromTag(string3, CELL_COUNT_START_TAG, "\"");
            string3 = string3.replace(CELL_COUNT_START_TAG + string, CELL_COUNT_START_TAG + Integer.parseInt(string) * this.pages);
        }
        if (string3.indexOf(OBJECT_COUNT_START_TAG) >= 0 && (string = TagParser.getValueFromTag(string3, OBJECT_COUNT_START_TAG, "\"")) != null) {
            string3 = string3.replace(OBJECT_COUNT_START_TAG + string, OBJECT_COUNT_START_TAG + Integer.parseInt(string) * this.pages);
        }
        this.writeOOoXml(string2, string3);
    }

    private void getRepStyleList(String string) {
        String[] stringArray = OdsContentParser.tag2Array(string, STYLE_START_TAG, STYLE_END_TAG);
        Set set = this.pageNameMap.keySet();
        block0: for (int i = 2; i < stringArray.length; ++i) {
            for (String string2 : set) {
                if (stringArray[i].indexOf("=\"" + string2 + ".") < 0) continue;
                String string3 = TagParser.getValueFromTag(stringArray[i], STYLE_NAME_START_TAG, "\"");
                this.repStyleList.add(string3);
                continue block0;
            }
        }
    }

    private void execContentHeader() {
        String string = this.path + "content.xml";
        String string2 = this.readOOoXml(string);
        String[] stringArray = OdsContentParser.tag2Array(string2, STYLE_START_TAG, STYLE_END_TAG);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(string);
            bufferedWriter.write(this.xmlHeader);
            bufferedWriter.write(10);
            bufferedWriter.write(string3);
            for (int i = 2; i < stringArray.length; ++i) {
                boolean bl = false;
                for (Map.Entry entry : this.pageNameMap.entrySet()) {
                    String string5 = (String)entry.getKey();
                    if (stringArray[i].indexOf("=\"" + string5 + ".") < 0) continue;
                    for (String string6 : (List)entry.getValue()) {
                        String string7 = stringArray[i].replace("=\"" + string5 + ".", "=\"" + string6 + ".");
                        String string8 = TagParser.getValueFromTag(string7, STYLE_NAME_START_TAG, "\"");
                        string7 = string7.replace(STYLE_NAME_START_TAG + string8, STYLE_NAME_START_TAG + string8 + VAR_CON + string6);
                        bufferedWriter.write(string7);
                        bl = true;
                    }
                }
                if (bl) continue;
                bufferedWriter.write(stringArray[i]);
            }
            bufferedWriter.write(string4);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:error occurer while write ReParsed Sheet " + string + HybsConst.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
        }
    }

    private void execMergeContent() {
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            fileChannel = new FileInputStream(this.path + "content.xml.tmp").getChannel();
            fileChannel2 = new FileOutputStream(this.path + "content.xml", true).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            try {
                this.queue.addMsg("[ERROR]PARSE:error occurer while merge content.xml" + HybsConst.CR);
                throw new HybsSystemException(iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileChannel);
                Closer.ioClose(fileChannel2);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)fileChannel);
        Closer.ioClose((Closeable)fileChannel2);
        FileUtil.deleteFiles((File)new File(this.path + "content.xml.tmp"));
    }

    private void execManifest() {
        String string = this.path + "META-INF" + File.separator + "manifest.xml";
        String[] stringArray = TagParser.tag2Array(this.readOOoXml(string), MANIFEST_START_TAG, MANIFEST_END_TAG);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(stringArray[0]);
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        for (Map.Entry entry : this.addObjMap.entrySet()) {
            if ("graph".equals(entry.getValue())) {
                stringBuilder.append("<manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"").append((String)entry.getKey()).append("/content.xml\"/><manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"").append((String)entry.getKey()).append("/styles.xml\"/><manifest:file-entry manifest:media-type=\"text/xml\" manifest:full-path=\"").append((String)entry.getKey()).append("/meta.xml\"/><manifest:file-entry manifest:media-type=\"application/vnd.oasis.opendocument.chart\" manifest:full-path=\"").append((String)entry.getKey()).append("/\"/>");
                continue;
            }
            stringBuilder.append("<manifest:file-entry manifest:media-type=\"image/").append((String)entry.getValue()).append("\" manifest:full-path=\"").append((String)entry.getKey()).append("\"/>");
        }
        stringBuilder.append(stringArray[1]);
        this.writeOOoXml(string, stringBuilder.toString());
    }

    private String readOOoXml(String string) {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder(200);
        try {
            bufferedReader = FileUtil.getBufferedReader((File)file, (String)"UTF-8");
            this.xmlHeader = bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (CharacterCodingException characterCodingException) {
            String string3 = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + " [" + string + "] , Encode=[UTF-8]";
            throw new OgCharacterException(string3, (Throwable)characterCodingException);
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:Failed to read " + string + HybsConst.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedReader);
        }
        String string4 = stringBuilder.toString();
        if (this.xmlHeader == null || this.xmlHeader.isEmpty() || string4 == null || string4.isEmpty()) {
            this.queue.addMsg("[ERROR]PARSE:Maybe " + string + " is Broken!" + HybsConst.CR);
            throw new HybsSystemException();
        }
        return string4;
    }

    private void writeOOoXml(String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(string);
            bufferedWriter.write(this.xmlHeader);
            bufferedWriter.write(10);
            bufferedWriter.write(string2);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.queue.addMsg("[ERROR]PARSE:Failed to write " + string + HybsConst.CR);
            throw new HybsSystemException(iOException);
        }
        finally {
            Closer.ioClose((Closeable)bufferedWriter);
        }
    }

    private BufferedWriter getWriter(String string) {
        return this.getWriter(string, false);
    }

    private BufferedWriter getWriter(String string, boolean bl) {
        BufferedWriter bufferedWriter;
        File file = new File(string);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.queue.addMsg("[ERROR] Input File is written by Unsupported Encoding");
            throw new HybsSystemException(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.queue.addMsg("[ERROR] File not Found");
            throw new HybsSystemException(fileNotFoundException);
        }
        return bufferedWriter;
    }

    public static String getSuffix(String string) {
        int n;
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1).toLowerCase(Locale.JAPAN);
        }
        return string2;
    }
}

