<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" useJQUI="true" refresh="{@REFRESH}" >
	<style type="text/css">
		/* モニターテーブルの幅 */
		.MonitorTbl td { vertical-align:bottom; }

		/* 文字の設定 */
		.text {
			font			 : bold x-large;
			background-color : white;
		}
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/none_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7222"
	title	= "ﾄﾞﾗｯｸﾞｻﾝﾌﾟﾙ2"
	date	= "2015/09/14"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:switch key="{@LOC_GRP}">
	<og:case match="BLOCK">
		<og:value key="HIRITU" value="200000" />
		<og:value key="WIDTH"  value="10px" />
	</og:case>
	<og:case match="BRANCH">
		<og:value key="HIRITU" value="100000" />
		<og:value key="WIDTH"  value="5px" />
	</og:case>
	<og:case isDefault="true">
		<og:value key="HIRITU" value="100000" />
		<og:value key="WIDTH"  value="5px" />
	</og:case>
</og:switch>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" quotCheck="false">
		select B.{@LOC_GRP} as LOC_GRP , A.LABEL_NAME , A.UNIQ , A.LOC_COL , A.LOC_ROW
				, SUM(B.SALES)/{@HIRITU}					AS SALES1
				, SUM(B.SALES)								AS SALES
				, SUM(B.AMOUNT)/{@HIRITU} 					AS AMOUNT1
				, SUM(B.AMOUNT)								AS AMOUNT
				, ABS(SUM(B.SALES-B.AMOUNT))/{@HIRITU}		AS PROFIT1
				, SUM(B.SALES-B.AMOUNT)						AS PROFIT
				, rtrim(CASE WHEN SUM(B.SALES-B.AMOUNT) &lt; 0 THEN '0' ELSE '1' END) AS SIGN
		from GE18 A inner join GF43 B
				on B.{@LOC_GRP} = A.R_KEY1
		where A.SYSTEM_ID	= '{@SYSTEM_ID}'
		and   A.FGJ			= '1'
	<og:where startKey="and">
		<og:and value="A.LOC_GRP	= '{@LOC_GRP}'"	/>
		<og:and value="B.YYYY		= '{@YYYY}'"	/>
		<og:and value="B.BLOCK		= '{@BLOCK}'"	/>
	</og:where>
		GROUP BY B.{@LOC_GRP},A.LABEL_NAME , A.UNIQ ,A.LOC_COL , A.LOC_ROW
		ORDER BY SALES1 DESC
</og:query>
 -->

<!-- GE18 検索SQL。 -->
<!-- OPT_NAMES , OPT_JOIN , OPT_WHERE , OPT_ORDER で、それぞれの位置に、SQL文を、追加することが出来ます。 -->
<og:value key="OPT_NAMES" >
	, B.{@LOC_GRP} as LOC_GRP , A.LABEL_NAME
	, SUM(B.SALES)/{@HIRITU}					AS SALES1
	, SUM(B.SALES)								AS SALES
	, SUM(B.AMOUNT)/{@HIRITU} 					AS AMOUNT1
	, SUM(B.AMOUNT)								AS AMOUNT
	, ABS(SUM(B.SALES-B.AMOUNT))/{@HIRITU}		AS PROFIT1
	, SUM(B.SALES-B.AMOUNT)						AS PROFIT
	, rtrim(CASE WHEN SUM(B.SALES-B.AMOUNT) &lt; 0 THEN '0' ELSE '1' END) AS SIGN
</og:value>

<og:value key="OPT_JOIN"  value="inner join GF43 B on B.{@LOC_GRP} = A.R_KEY1" />
<og:value key="OPT_WHERE" >
	<og:where startKey="and">
		<og:and value="B.YYYY	= '{@YYYY}'"	/>
		<og:and value="B.BLOCK	= '{@BLOCK}'"	/>
	</og:where>
</og:value>
<og:value key="OPT_ORDER" value="GROUP BY B.{@LOC_GRP},A.LABEL_NAME , A.UNIQ ,A.LOC_COL , A.LOC_ROW ORDER BY SALES1 DESC" />

<!-- GE18 検索SQL。 -->
<jsp:directive.include file="/jsp/common/dragSelect.jsp" />

<!-- DB検索結果を表示させます。 -->
<!-- ﾄﾞﾗｯｸﾞの dragDiv を作成します。 -->
<og:dragView image="{@LOC_GRP}_japan2.png" bgSize="600px" >		<!-- 背景の画像を指定 -->
	<div style="position:relative;"><og:text>{@SYS.DATE}</og:text></div>
	<og:view
		viewFormType = "CustomData"
		command		 = "{@command}"
		writable	 = "false"
		useScrollBar = "false"
		numberType	 = "delete"
		bgColorCycle = "1"
		useHilightRow= "false"
	>
		<og:tbody usableKey="SIGN" usableList="1" rowspan="1">
		  <!-- モニターを移動させるための設定。style属性に、位置を指定。 -->
		<!-- 黒字の場合 -->
		  <og:dragDiv>
			<table class="MonitorTbl">
				<tr>
					<td><img height="[SALES1]px"  width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_green.gif" alt="[SALES1]"  /></td>
					<td><img height="[AMOUNT1]px" width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_blue.gif"  alt="[AMOUNT1]" /></td>
					<td><img height="[PROFIT1]px" width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_brown.gif" alt="[PROFIT1]" /></td>
				</tr>
				<tr>
					<td colspan="3" class="text"><b>[LOC_GRP]</b></td>
				</tr>
			</table>
		  </og:dragDiv>
		</og:tbody>
		<!-- 赤字の場合 -->
		<og:tbody usableKey="SIGN" usableList="0" rowspan="1" >
		  <!-- モニターを移動させるための設定。style属性に、位置を指定。 -->
		  <og:dragDiv>
			<table class="MonitorTbl">
				<tr>
					<td><img height="[SALES1]px"  width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_green.gif" alt="[SALES1]"  /></td>
					<td><img height="[AMOUNT1]px" width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_blue.gif"  alt="[AMOUNT1]" /></td>
					<td><img height="[PROFIT1]px" width="{@WIDTH}" src="{@SYS.JSP_IMG}/space_red.gif"   alt="[PROFIT1]" /></td>
				</tr>
				<tr>
					<td colspan="3" class="text"><b>[LOC_GRP]</b></td>
				</tr>
			</table>
		  </og:dragDiv>
		</og:tbody>
	</og:view>
</og:dragView>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
