/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTrees;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import org.opengion.fukurou.taglet.AbstractDocTree;
import org.opengion.fukurou.taglet.DocTreeWriter;

public class DocTreeParam
extends AbstractDocTree {
    private static final String OG_PARAM_LVL = "og.paramLevel";
    private static final String OG_CRYPTOGRAPHY = "og.cryptography";
    private static final int CNST = 1000;
    private String systemId = "**";
    private String outfile;

    @Override
    public boolean run(DocletEnvironment docletEnvironment) {
        try (DocTreeWriter docTreeWriter = new DocTreeWriter(this.outfile, "UTF-8");){
            docTreeWriter.printTag("<?xml version=\"1.0\" encoding=\"", "UTF-8", "\" ?>");
            docTreeWriter.printTag("<javadoc>");
            docTreeWriter.printTag(" <systemId>", this.systemId, "</systemId>");
            this.writeContents(docletEnvironment, docTreeWriter);
            docTreeWriter.printTag("</javadoc>");
        }
        catch (Throwable throwable) {
            this.reporter.print(Diagnostic.Kind.ERROR, throwable.getMessage());
        }
        return true;
    }

    private void writeContents(DocletEnvironment docletEnvironment, DocTreeWriter docTreeWriter) {
        DocTrees docTrees = docletEnvironment.getDocTrees();
        for (TypeElement typeElement : ElementFilter.typesIn(docletEnvironment.getIncludedElements())) {
            int n = 0;
            String string = String.valueOf(typeElement.getQualifiedName());
            docTreeWriter.setClassName(string);
            for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                if (!variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                DocCommentTree docCommentTree = docTrees.getDocCommentTree(variableElement);
                String string2 = String.valueOf(variableElement);
                String string3 = String.valueOf(n * 10 + 1000);
                String[] stringArray = this.getTitleCmnt(docCommentTree);
                String string4 = String.valueOf(variableElement.getConstantValue());
                Map<String, List<String>> map = this.blockTagsMap(docCommentTree);
                String string5 = this.getBlockTag(OG_PARAM_LVL, map, "").split(":")[0];
                String string6 = this.getBlockTag(OG_CRYPTOGRAPHY, map, "").split(":")[0];
                docTreeWriter.printTag(" <fieldDoc>");
                docTreeWriter.printTag("   <paramId>", string2, "</paramId>");
                docTreeWriter.printTag("   <seq>", string3, "</seq>");
                docTreeWriter.printTag("   <param>", string4, "</param>");
                docTreeWriter.printTag("   <title>", stringArray[0], "</title>");
                docTreeWriter.printTag("   <contents>", stringArray[1], "</contents>");
                docTreeWriter.printTag("   <paramLevel>", string5, "</paramLevel>");
                docTreeWriter.printTag("   <fgcrypt>", string6, "</fgcrypt>");
                docTreeWriter.printTag(" </fieldDoc>");
                ++n;
            }
        }
    }

    private String[] getTitleCmnt(DocCommentTree docCommentTree) {
        String[] stringArray = new String[]{"", ""};
        if (docCommentTree == null) {
            return stringArray;
        }
        List<? extends DocTree> list = docCommentTree.getFullBody();
        if (list.isEmpty()) {
            return stringArray;
        }
        String string = String.valueOf(list.get(0));
        int n = string.indexOf(65377);
        if (n < 0) {
            n = string.indexOf(10);
        }
        if (n >= 0) {
            stringArray[0] = string.substring(0, n).trim();
            stringArray[1] = string.substring(n).trim();
        } else {
            stringArray[1] = string.trim();
        }
        return stringArray;
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        Doclet.Option[] optionArray = new Doclet.Option[]{new AbstractDocTree.AbstractOption(new String[]{"-outfile", "-systemId"}){

            @Override
            public boolean process(String string, List<String> list) {
                if ("-outfile".equalsIgnoreCase(string)) {
                    DocTreeParam.this.outfile = list.get(0);
                } else if ("-systemId".equalsIgnoreCase(string)) {
                    DocTreeParam.this.systemId = list.get(0);
                }
                return true;
            }
        }};
        return new HashSet<Doclet.Option>(Arrays.asList(optionArray));
    }
}

