<jsp:directive.page pageEncoding="UTF-8" />

<!-- カテゴリがどれだけあるかをピックアップしておきます。 -->
<og:value command="SQL" action="ROW_APPEND">
	select GUIKEY from GE15
	where GUIKEY is not null
--	and   DYLOGIN >= '20210609080000'
--	and   DYLOGIN <= TO_CHAR( TO_DATE( '20210609080000', 'YYYYMMDDHH24MISS' ) + 24/24 , 'YYYYMMDDHH24MISS' )
	group by GUIKEY
	order by GUIKEY
</og:value>

<og:query command="NEW" stopZero="{@stopZero}">
	select '20210609080000' as DYLOGIN , null as GE , null as  GG from dual		-- 区切りの良い時間から始める
	union all
	select DYLOGIN ,
		case when SYSTEM_ID = 'GE' then GUIKEY else null end as GE ,
		case when SYSTEM_ID = 'GG' then GUIKEY else null end as GG
	from GE15
	where GUIKEY is not null
--	and   DYLOGIN >= '20210609080000'
--	and   DYLOGIN <= TO_CHAR( TO_DATE( '20210609080000', 'YYYYMMDDHH24MISS' ) + 24/24 , 'YYYYMMDDHH24MISS' )
	order by 1,2
</og:query>

<fieldset style="display:inline-block;">
	<legend>jsChartV3</legend>
	<og:jsChartV3
		chartType			= "line"
		height				= "{@height}"
		width				= "1000px"
		xscaleType			= "time"
		labelColumn			= "DYLOGIN"
		timeParser			= "yyyyMMddHHmmss"
		timeLblFormat		= "MM/dd HH:mm"
		timeUnit			= "minute"
		timeUnitStepSize	= "20"
		title				= "{@chartTitle}"
		valueQuot			= "true"
		debug				= "{@debug}"
	>
		<og:jsChartDataV3
			chartColumn			= "GE"
			label				= "GE"
			scaleType			= "category"
			categoryList		= ",{@GUIKEY},"
			spanGaps			= "false"
		 />
		<og:jsChartDataV3
			chartColumn			= "GG"
			label				= "GG"
			scaleType			= "category"
			categoryList		= ",{@GUIKEY},"
			spanGaps			= "false"
		 />
	</og:jsChartV3>
</fieldset>

<og:view />
