<jsp:directive.page pageEncoding="UTF-8" />

<og:query command="NEW" stopZero="{@stopZero}">
	SELECT 	 ENAME
			,ROUND( SAL * DBMS_RANDOM.VALUE ) as SAL1
			,SAL as BASE
			FROM EMP
			<og:where>
				<og:and value="DEPTNO = {@SOOUID}" />
				<og:and value="rownum < 4" />
			</og:where>
</og:query>

<style type="text/css">
	.FIELD {
		display:	inline-block;
		position:	relative;
		background-color:	#000000;
	}

	.METER_TXT {
		position:	absolute;
		color:		#ffffff;
		font-size :	5em;
		left:		0;
		right:		0;
		margin:		auto;
		text-align:	center;
		top:		50%;
		-webkit-transform: translateY(-50%);
		transform: translateY(-50%);
	}
</style>

<fieldset class="FIELD" >
	<legend>JavaScript</legend>
	<canvas id="mycanvas" height="400" width="400"><!-- --></canvas>
	<div class="METER_TXT"><og:value command="GETTBL" action="FIRST" key="SAL1" /></div>
</fieldset>

<script type="text/javascript">
	// jsonで取得
	var querydata =
	<og:view
		viewFormType	= "JSON"
		command			= "NEW"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		pageSize		= "0" />
	;

	var datadata1   = [];
	var datadata2   = [];
	var datalabels = [];
	for(var i=0; i < querydata.DATA.length; i++){
		datadata1[i]  = querydata.DATA[i].SAL1;
		datadata2[i]  = querydata.DATA[i].BASE;
		datalabels[i] = querydata.DATA[i].ENAME;
	}

	var chartdata = {
		labels: datalabels,
		datasets: [{
			data: datadata1,
			backgroundColor: [ "PINK","Transparent","Transparent" ],
			borderWidth: 0
		},{
			data: datadata2,
			backgroundColor: [ "#FF6384","#FFCE56","#36A2EB" ],
			borderWidth: 0
		}],
	};

	<og:text>
	var myChart = new Chart( mycanvas,{
					type: 'doughnut',
					data: chartdata,
					options: {
						cutout : '70%' ,			// 円は、0% , ドーナツは、50% が初期値
						responsive: false ,
						animation : false ,			// false にしないと、Chart.plugins.register で、２回呼ばれる。
						plugins:{
							legend:{display:false,},
						},
					}
				});
	</og:text>
</script>

<fieldset class="FIELD" >
	<legend>jsChartV3</legend>
	<og:jsChartV3
		chartType		= "doughnut"
		labelColumn		= "ENAME"
		optOptions		= "animation:false,cutout:'70%'"
		optTicks		= "color:'black'"
		legendDisplay	= "false"
	>
		<og:jsChartDataV3
			chartColumn		= "SAL1"
			backgroundColor	= "PINK,Transparent,Transparent"
			fontColor		= "black"
			borderWidth		= "0"
		/>
		<og:jsChartDataV3
			chartColumn		= "BASE"
			backgroundColor = "#FF6384,#FFCE56,#36A2EB"
			borderWidth		= "0"
		/>
	</og:jsChartV3>
	<div class="METER_TXT"><og:value command="GETTBL" action="FIRST" key="SAL1" /></div>
</fieldset>
