/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.business.ArrayTableModel;
import org.opengion.fukurou.business.BizLogicHelper;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsLoader;
import org.opengion.fukurou.util.HybsLoaderConfig;
import org.opengion.fukurou.util.HybsLoaderFactory;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class BizLogicTag
extends CommonTagSupport {
    private static final String VERSION = "8.0.2.0 (2021/11/30)";
    private static final long serialVersionUID = 802020211130L;
    public static final String CMD_ENTRY = "ENTRY";
    private static final String ERR_MSG_ID = "h_errMsg";
    private String command = "ENTRY";
    private String[] logics;
    private String dbid;
    private transient DBTableModel table;
    private String tableId = "h_tblmdl";
    private boolean selectedAll;
    private String modifyType;
    private String[] keys;
    private String[] vals;
    private boolean stopError = true;
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private transient ErrorMessage errMessage;
    private int errCode = 0;
    private int executeCount = -1;
    private transient DataModel<String> arrTable;
    private transient HybsLoader loader;
    private static final String SRC_PATH = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_SRC_PATH");
    private static final String CLS_PATH = HybsSystem.sys("REAL_PATH") + HybsSystem.sys("BIZLOGIC_CLASS_PATH");
    private static final String WEB_LIB = HybsSystem.sys("REAL_PATH") + "WEB-INF" + File.separator + "lib";
    private static final String WEB_CLS = HybsSystem.sys("REAL_PATH") + "WEB-INF" + File.separator + "classes";
    private String srcDir = SRC_PATH;
    private String classDir = CLS_PATH;
    private boolean isAutoCompile = HybsSystem.sysBool("BIZLOGIC_AUTO_COMPILE");
    private boolean isHotDeploy = HybsSystem.sysBool("BIZLOGIC_HOT_DEPLOY");
    private boolean isMulti;
    private boolean dispError = true;
    private static final String CLASS_PATH;

    @Override
    public int doStartTag() {
        this.useXssCheck(this.xssCheck);
        if (CMD_ENTRY.equals(this.command)) {
            this.startQueryTransaction(this.tableId);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.useQuotCheck(this.quotCheck);
        this.makeVals();
        this.execute();
        String string = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource());
        if (string != null && string.length() > 0) {
            this.setSessionAttribute(ERR_MSG_ID, this.errMessage);
        }
        if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
            this.jspPrint("BizLoicTag \u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
            return 5;
        }
        this.setRequestAttribute("DB.ERR_MSG", string);
        if (this.dispError) {
            this.jspPrint(string);
        }
        if (this.errCode >= 2 && this.stopError) {
            return 5;
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_ENTRY;
        this.logics = null;
        this.dbid = null;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.selectedAll = false;
        this.modifyType = null;
        this.keys = null;
        this.vals = null;
        this.stopError = true;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.errMessage = null;
        this.errCode = 0;
        this.executeCount = -1;
        this.arrTable = null;
        this.loader = null;
        this.srcDir = SRC_PATH;
        this.classDir = CLS_PATH;
        this.isAutoCompile = HybsSystem.sysBool("BIZLOGIC_AUTO_COMPILE");
        this.isHotDeploy = HybsSystem.sysBool("BIZLOGIC_HOT_DEPLOY");
        this.isMulti = false;
        this.dispError = true;
    }

    private void execute() {
        int n2;
        String[] stringArray2;
        ErrMsg[] errMsgArray;
        int[] nArray;
        if (CMD_ENTRY.equals(this.command)) {
            this.table = (DBTableModel)this.getObject(this.tableId);
        }
        if (this.table != null) {
            nArray = this.getParameterRows();
            errMsgArray = new String[nArray.length][this.table.getColumnCount()];
            stringArray2 = new String[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                errMsgArray[n2] = (String[])this.table.getValues(nArray[n2]);
                stringArray2[n2] = this.table.getModifyType(nArray[n2]);
            }
        } else {
            return;
        }
        this.arrTable = new ArrayTableModel(this.table.getNames(), (String[][])errMsgArray, stringArray2);
        errMsgArray = this.getTransaction();
        try {
            this.errMessage = new ErrorMessage();
            this.loader = HybsLoaderFactory.getLoader((HybsLoaderConfig)new HybsLoaderConfig(this.srcDir, this.classDir, this.isAutoCompile, this.isHotDeploy, CLASS_PATH));
            boolean bl = false;
            for (n2 = 0; n2 < this.logics.length && (bl = this.call(this.logics[n2], (Transaction)errMsgArray)); ++n2) {
            }
            if (this.arrTable != null) {
                ConcurrentMap concurrentMap = ((ArrayTableModel)this.arrTable).getModifyVals();
                concurrentMap.forEach((n, stringArray) -> this.table.setValues((Object[])stringArray, nArray[n]));
            }
            this.executeCount = nArray.length;
            this.errCode = this.errMessage.getKekka();
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            if (this.errCode < 2) {
                errMsgArray.commit();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n3 = nArray[i];
                    if ("D".equals(this.table.getModifyType(n3))) {
                        this.table.removeValue(n3);
                        continue;
                    }
                    this.table.resetModify(n3);
                }
            } else {
                errMsgArray.rollback();
            }
        }
        finally {
            if (errMsgArray != null) {
                errMsgArray.close();
            }
        }
        errMsgArray = this.errMessage.toArray();
        ErrorMessage errorMessage = new ErrorMessage();
        for (int i = 0; i < errMsgArray.length; ++i) {
            if (this.table != null && nArray.length > 0) {
                errorMessage.addMessage(errMsgArray[i].copy(nArray[errMsgArray[i].getNo()] + 1));
                continue;
            }
            errorMessage.addMessage(errMsgArray[i].copy(errMsgArray[i].getNo() + 1));
        }
        this.errMessage = errorMessage;
    }

    private boolean call(String string3, Transaction transaction) {
        BizLogicHelper bizLogicHelper = new BizLogicHelper(string3, this.loader);
        if (bizLogicHelper.isRequireTable()) {
            if (this.arrTable == null) {
                String string4 = "TableModel\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002logic=[" + string3 + "]";
                throw new HybsSystemException(string4);
            }
            if (this.arrTable.getRowCount() == 0) {
                return true;
            }
            bizLogicHelper.setTable(this.arrTable);
        }
        bizLogicHelper.setTransaction(transaction);
        bizLogicHelper.setDbid(this.dbid);
        bizLogicHelper.setKeys(this.keys);
        bizLogicHelper.setVals(this.vals);
        bizLogicHelper.setUserId(this.getUser().getUserID());
        bizLogicHelper.setParentPgId(this.getGUIInfoAttri("KEY"));
        bizLogicHelper.setLoader(this.loader);
        if (this.isDebug()) {
            bizLogicHelper.setDebug();
        }
        boolean bl = false;
        try {
            bl = bizLogicHelper.exec();
        }
        catch (Throwable throwable) {
            transaction.rollback();
            String string5 = "\u696d\u52d9\u30ed\u30b8\u30c3\u30af\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + throwable.getMessage();
            throw new HybsSystemException(string5, throwable);
        }
        this.errMessage.append(bizLogicHelper.getErrMsg());
        this.setRequestAttribute(string3 + ".RETURN", bizLogicHelper.getReturn());
        this.setRequestAttribute("RETURN", bizLogicHelper.getReturn());
        Map map = bizLogicHelper.getReturnMap();
        if (map != null) {
            map.forEach((string, string2) -> this.setRequestAttribute((String)string, string2));
        }
        if (this.isDebug()) {
            this.jspPrint(bizLogicHelper.getDebugMsg());
        }
        return bl;
    }

    private void makeVals() {
        if (this.keys != null && this.keys.length > 0) {
            boolean bl;
            boolean bl2 = bl = this.vals != null && this.vals.length > 0;
            if (bl) {
                if (this.keys.length != this.vals.length) {
                    String string = "keys\u3068Vals\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + CR + "  keys=" + Arrays.toString(this.keys) + CR + "  vals=" + Arrays.toString(this.vals);
                    throw new HybsSystemException(string);
                }
            } else {
                this.vals = new String[this.keys.length];
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (bl) {
                    if (this.isMulti) {
                        this.vals[i] = StringUtil.array2csv((String[])this.getRequestParameterValues(this.vals[i]));
                        continue;
                    }
                    this.vals[i] = this.getRequestParameter(this.vals[i]);
                    continue;
                }
                this.vals[i] = this.isMulti ? StringUtil.array2csv((String[])this.getRequestValues(this.keys[i])) : this.getRequestValue(this.keys[i]);
            }
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setLogics(String string) {
        this.logics = this.getCSVParameter(string);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setModifyType(String string) {
        this.modifyType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.modifyType);
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(this.getRequestParameter(string));
    }

    public void setVals(String string) {
        this.vals = StringUtil.csv2Array((String)string);
    }

    public void setStopError(String string) {
        this.stopError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopError);
    }

    public void setDispError(String string) {
        this.dispError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.dispError);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setMulti(String string) {
        this.isMulti = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMulti);
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("logics", (Object[])this.logics).println("dbid", (Object)this.dbid).println("tableId", (Object)this.tableId).println("selectedAll", (Object)this.selectedAll).println("modifyType", (Object)this.modifyType).println("keys", (Object[])this.keys).println("vals", (Object[])this.vals).println("stopError", (Object)this.stopError).println("quotCheck", (Object)this.quotCheck).println("xssCheck", (Object)this.xssCheck).println("executeCount", (Object)this.executeCount).println("errCode", (Object)this.errCode).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }

    static {
        StringBuilder stringBuilder = new StringBuilder(200).append('.').append(File.pathSeparatorChar);
        File file = new File(WEB_LIB);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                stringBuilder.append(file2.getAbsolutePath()).append(File.pathSeparatorChar);
            }
        }
        stringBuilder.append(WEB_CLS).append(File.pathSeparatorChar).append(CLS_PATH).append(File.pathSeparatorChar);
        CLASS_PATH = stringBuilder.toString();
    }
}

