/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.Maps;
import java.util.Map;
import org.openstack4j.model.manila.Share;
import org.openstack4j.model.manila.ShareCreate;
import org.openstack4j.model.manila.builder.ShareCreateBuilder;

@JsonRootName(value="share")
public class ManilaShareCreate
implements ShareCreate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="share_proto")
    private Share.Protocol shareProto;
    private Integer size;
    private String name;
    private String description;
    @JsonProperty(value="display_name")
    private String displayName;
    @JsonProperty(value="display_description")
    private String displayDescription;
    @JsonProperty(value="share_type")
    private String shareType;
    @JsonProperty(value="volume_type")
    private String volumeType;
    @JsonProperty(value="snapshot_id")
    private String snapshotId;
    @JsonProperty(value="is_public")
    private Boolean isPublic;
    private Map<String, String> metadata;
    @JsonProperty(value="share_network_id")
    private String shareNetworkId;
    @JsonProperty(value="consistency_group_id")
    private String consistencyGroupId;
    @JsonProperty(value="availability_zone")
    private String availabilityZone;

    @Override
    public Share.Protocol getShareProto() {
        return this.shareProto;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public String getShareType() {
        return this.shareType;
    }

    @Override
    public String getVolumeType() {
        return this.volumeType;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getShareNetworkId() {
        return this.shareNetworkId;
    }

    @Override
    public String getConsistencyGroupId() {
        return this.consistencyGroupId;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public static ShareCreateBuilder builder() {
        return new ShareCreateConcreteBuilder();
    }

    @Override
    public ShareCreateBuilder toBuilder() {
        return new ShareCreateConcreteBuilder(this);
    }

    public static class ShareCreateConcreteBuilder
    implements ShareCreateBuilder {
        ManilaShareCreate shareCreate;

        public ShareCreateConcreteBuilder() {
            this(new ManilaShareCreate());
        }

        public ShareCreateConcreteBuilder(ManilaShareCreate shareCreate) {
            this.shareCreate = shareCreate;
        }

        @Override
        public ShareCreateBuilder shareProto(Share.Protocol shareProto) {
            this.shareCreate.shareProto = shareProto;
            return this;
        }

        @Override
        public ShareCreateBuilder size(Integer size) {
            this.shareCreate.size = size;
            return this;
        }

        @Override
        public ShareCreateBuilder name(String name) {
            this.shareCreate.name = name;
            return this;
        }

        @Override
        public ShareCreateBuilder description(String description) {
            this.shareCreate.description = description;
            return this;
        }

        @Override
        public ShareCreateBuilder displayName(String displayName) {
            this.shareCreate.displayName = displayName;
            return this;
        }

        @Override
        public ShareCreateBuilder displayDescription(String displayDescription) {
            this.shareCreate.displayDescription = displayDescription;
            return this;
        }

        @Override
        public ShareCreateBuilder shareType(String shareType) {
            this.shareCreate.shareType = shareType;
            return this;
        }

        @Override
        public ShareCreateBuilder volumeType(String volumeType) {
            this.shareCreate.volumeType = volumeType;
            return this;
        }

        @Override
        public ShareCreateBuilder snapshotId(String snapshotId) {
            this.shareCreate.snapshotId = snapshotId;
            return this;
        }

        @Override
        public ShareCreateBuilder isPublic(Boolean isPublic) {
            this.shareCreate.isPublic = isPublic;
            return this;
        }

        @Override
        public ShareCreateBuilder addMetadataItem(String key, String value) {
            if (this.shareCreate.metadata == null) {
                this.shareCreate.metadata = Maps.newHashMap();
            }
            this.shareCreate.metadata.put(key, value);
            return this;
        }

        @Override
        public ShareCreateBuilder metadata(Map<String, String> metadata) {
            this.shareCreate.metadata = metadata;
            return this;
        }

        @Override
        public ShareCreateBuilder shareNetworkId(String shareNetworkId) {
            this.shareCreate.shareNetworkId = shareNetworkId;
            return this;
        }

        @Override
        public ShareCreateBuilder consistencyGroupId(String consistencyGroupId) {
            this.shareCreate.consistencyGroupId = consistencyGroupId;
            return this;
        }

        @Override
        public ShareCreateBuilder availabilityZone(String availabilityZone) {
            this.shareCreate.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public ShareCreate build() {
            return this.shareCreate;
        }

        @Override
        public ShareCreateBuilder from(ShareCreate in) {
            this.shareCreate = (ManilaShareCreate)in;
            return this;
        }
    }
}

