/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.get;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.get.GetAccountReply;
import oracle.cloudstorage.api.get.GetContainerReply;
import oracle.cloudstorage.api.get.GetObjectReply;
import oracle.cloudstorage.api.get.GetRequestProcessor;
import oracle.cloudstorage.api.get.IGetAccountReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSendableProcessor
extends GetRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GetSendableProcessor.class);

    public GetSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    public IGetAccountReply account() throws RetryException {
        IdSetRequestProcessor<IGetAccountReply> processor = new IdSetRequestProcessor<IGetAccountReply>((IRequestProcessor)this){

            @Override
            protected IGetAccountReply buildReply(Map<String, List<Object>> headers, int statusCode, String message, String joinedIds, IReply.Context context) {
                return new GetAccountReply(headers, statusCode, message, joinedIds, context);
            }
        };
        IGetAccountReply reply = (IGetAccountReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IGetContainerReply container() throws RetryException {
        IdSetRequestProcessor<IGetContainerReply> processor = new IdSetRequestProcessor<IGetContainerReply>((IRequestProcessor)this){

            @Override
            protected IGetContainerReply buildReply(Map<String, List<Object>> headers, int statusCode, String message, String joinedIds, IReply.Context context) {
                return new GetContainerReply(headers, statusCode, message, joinedIds, context);
            }
        };
        IGetContainerReply reply = (IGetContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    protected GetObjectReply atomicObject() throws RetryException {
        int chunkSize = ((IGetRequestBuilder)this.getBuilder()).getChunkSize();
        String url = this.getObjectUrl();
        ScopedRequestProcessor<IRequestBuilder, GetObjectReply> processor = new ScopedRequestProcessor<IRequestBuilder, GetObjectReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder requestBuilder) {
                ISendable sendable = this.getSendable();
                sendable.getHeaders().put(Header.accept, (Object)"*/*");
                IResponse response = GetSendableProcessor.this.getSession().send(logger, Marker.get.and(Marker.jaxrs), sendable);
                return response;
            }

            @Override
            protected GetObjectReply buildReply(final IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                InputStream data = response.getInputStream();
                GetObjectReply reply = new GetObjectReply(headers, statusCode, message, data, context){

                    @Override
                    public void close() {
                        super.close();
                        response.close();
                        logger.debug(Marker.get.and(Marker.jaxrs), "Closed response {}\n    used by reply {}.", (Object)response, (Object)this);
                    }
                };
                return reply;
            }

            @Override
            protected boolean closeResponseUsedByReply(IResponse response) {
                return false;
            }
        };
        GetObjectReply reply = (GetObjectReply)processor.execute(this.getBuilder());
        return reply;
    }

    private abstract class IdSetRequestProcessor<R extends IReply>
    extends ScopedRequestProcessor<IRequestBuilder, R> {
        public IdSetRequestProcessor(IRequestProcessor<?, ?> outer) {
            super(outer);
        }

        @Override
        protected IResponse executeRequest(IRequestBuilder requestBuilder) {
            ISendable sendable = this.getSendable();
            sendable.getHeaders().put(Header.accept, (Object)"text/plain");
            IResponse response = GetSendableProcessor.this.getSession().send(logger, Marker.get.and(Marker.jaxrs), sendable);
            return response;
        }

        @Override
        protected R buildReply(IResponse response, IReply.Context context) {
            Map<String, List<Object>> headers = response.getHeaders();
            int statusCode = response.getStatus();
            String message = response.getErrorContent();
            String joinedIds = response.readContent();
            R reply = this.buildReply(headers, statusCode, message, joinedIds, context);
            return reply;
        }

        protected abstract R buildReply(Map<String, List<Object>> var1, int var2, String var3, String var4, IReply.Context var5);
    }
}

