/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Arrays;
import java.util.Locale;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.JsonReader;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ReadJSONTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.7.2 (2014/06/20)";
    private static final long serialVersionUID = 577220140620L;
    private static final int ERROR_ROW_COUNT = 200;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    private String jsonData = null;
    private String readerClass = "Default";
    private int maxRowCount = -1;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String notfoundMsg = "MSG0077";
    private int executeCount = -1;
    private String modifyType = null;
    private String checkColumns = null;
    private String nullCheck = null;
    private transient DBTableModel table = null;
    private String command = "NEW";
    private String tableId = "h_tblmdl";
    private boolean stopZero = false;
    private boolean isMainTrans = true;
    private int skipRowCount = 0;
    private boolean useRenderer = false;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        if (this.jsonData == null || this.jsonData.length() <= 0) {
            this.jsonData = this.getBodyString();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        if (this.jsonData != null && this.jsonData.length() > 0 && this.check(this.command, COMMAND_LIST)) {
            StringBuilder stringBuilder;
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            if ("session".equals(this.getScope())) {
                this.removeSessionAttribute(this.tableId);
                this.removeSessionAttribute("h_vform");
            }
            if (this.maxRowCount < 0) {
                this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
            }
            this.create(this.jsonData);
            if (this.table != null) {
                this.executeCount = this.table.getRowCount();
                if (this.modifyType != null) {
                    for (int i = 0; i < this.executeCount; ++i) {
                        this.table.setModifyType(i, this.modifyType);
                    }
                }
                if ((stringBuilder = this.checkTableColumn(this.table)) != null && !stringBuilder.isOK()) {
                    this.jspPrint(TaglibUtil.makeHTMLErrorTable((ErrorMessage)stringBuilder, this.getResource()));
                    return 5;
                }
            }
            if (!this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("ReadTableTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
            stringBuilder = new StringBuilder(50);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(this.executeCount);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(HybsSystem.BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(HybsSystem.BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.jspPrint(stringBuilder.toString());
        }
        int n = this.executeCount < 0 && this.stopZero ? 5 : 6;
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.readerClass = "Default";
        this.maxRowCount = -1;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.notfoundMsg = "MSG0077";
        this.executeCount = -1;
        this.modifyType = null;
        this.command = CMD_NEW;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.checkColumns = null;
        this.nullCheck = null;
        this.stopZero = false;
        this.isMainTrans = true;
        this.skipRowCount = 0;
        this.useRenderer = false;
        this.jsonData = null;
    }

    protected void create(String string) {
        String string2 = HybsSystem.sys("JsonReader_" + this.readerClass);
        JsonReader jsonReader = (JsonReader)HybsSystem.newInstance(string2);
        jsonReader.setResourceManager(this.getResource());
        jsonReader.setMaxRowCount(this.maxRowCount);
        jsonReader.setSkipRowCount(this.skipRowCount);
        jsonReader.setUseRenderer(this.useRenderer);
        jsonReader.setDebug(this.isDebug());
        jsonReader.readDBTable(string);
        this.table = jsonReader.getDBTableModel();
    }

    private int[] makeClmNos(String string, DBTableModel dBTableModel) {
        int[] nArray;
        if (string == null) {
            nArray = new int[]{};
        } else if ("*".equals(string)) {
            int n = dBTableModel.getColumnCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            String[] stringArray = StringUtil.csv2Array((String)string);
            int n = stringArray.length;
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i]);
            }
        }
        return nArray;
    }

    private ErrorMessage checkTableColumn(DBTableModel dBTableModel) {
        ErrorMessage errorMessage = new ErrorMessage("Check Columns Error!");
        int n = dBTableModel.getRowCount();
        int[] nArray = this.makeClmNos(this.checkColumns, dBTableModel);
        int[] nArray2 = this.makeClmNos(this.nullCheck, dBTableModel);
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            int n3;
            String[] stringArray = (String[])dBTableModel.getValues(i);
            DBColumn[] dBColumnArray = dBTableModel.getDBColumns();
            boolean bl = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                object = dBColumnArray[n2].valueCheck(stringArray[n2]);
                if (object.getKekka() <= 0) continue;
                bl = true;
                errorMessage.append(i + 1, dBColumnArray[n2].valueCheck(stringArray[n2]));
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = nArray2[n3];
                if (stringArray[n2] != null && stringArray[n2].length() != 0) continue;
                bl = true;
                object = dBColumnArray[n2].getLabel();
                errorMessage.addMessage(i + 1, 2, "ERR0012", new String[]{object});
            }
            if (this.isDebug() && bl) {
                errorMessage.addMessage(i + 1, 0, "Debug Info", new String[]{Arrays.toString(dBTableModel.getValues(i))});
            }
            if (errorMessage.size() > 200) break;
        }
        return errorMessage;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setReaderClass(String string) {
        this.readerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.readerClass);
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
        if (this.maxRowCount == 0) {
            this.maxRowCount = Integer.MAX_VALUE;
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setModifyType(String string) {
        this.modifyType = this.getRequestParameter(string);
    }

    public void setCheckColumns(String string) {
        this.checkColumns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkColumns);
    }

    public void setNullCheck(String string) {
        this.nullCheck = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nullCheck);
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setJSONData(String string) {
        this.jsonData = StringUtil.nval((String)this.getRequestParameter(string), (String)this.jsonData);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("readerClass", (Object)this.readerClass).println("maxRowCount", (Object)this.maxRowCount).println("displayMsg", (Object)this.displayMsg).println("executeCount", (Object)this.executeCount).println("modifyType", (Object)this.modifyType).println("checkColumns", (Object)this.checkColumns).println("nullCheck", (Object)this.nullCheck).println("command", (Object)this.command).println("tableId", (Object)this.tableId).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

