/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.ext.ListenerV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.ListenerV2;
import org.openstack4j.model.network.ext.ListenerV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronListenerV2;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class ListenerV2ServiceImpl
extends BaseNetworkingServices
implements ListenerV2Service {
    @Override
    public List<? extends ListenerV2> list() {
        return this.get(NeutronListenerV2.Listeners.class, this.uri("/lbaas/listeners", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends ListenerV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronListenerV2.Listeners> req = this.get(NeutronListenerV2.Listeners.class, this.uri("/lbaas/listeners", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public ListenerV2 get(String listenerId) {
        Preconditions.checkNotNull((Object)listenerId);
        return this.get(NeutronListenerV2.class, this.uri("/lbaas/listeners/%s", listenerId)).execute();
    }

    @Override
    public ActionResponse delete(String listenerId) {
        Preconditions.checkNotNull((Object)listenerId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/listeners/%s", listenerId)).executeWithResponse());
    }

    @Override
    public ListenerV2 create(ListenerV2 listener) {
        Preconditions.checkNotNull((Object)listener);
        return this.post(NeutronListenerV2.class, this.uri("/lbaas/listeners", new Object[0])).entity(listener).execute();
    }

    @Override
    public ListenerV2 update(String listenerId, ListenerV2Update listener) {
        Preconditions.checkNotNull((Object)listenerId);
        Preconditions.checkNotNull((Object)listener);
        return this.put(NeutronListenerV2.class, this.uri("/lbaas/listeners/%s", listenerId)).entity(listener).execute();
    }
}

